/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.loaders;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.openide.util.Exceptions;

public final class UIException {
    private UIException() {
    }

    public static void annotateUser(Throwable t, String msg, String locMsg, Throwable stackTrace, Date date) {
        AnnException ex = AnnException.findOrCreate(t, true);
        LogRecord rec = new LogRecord(OwnLevel.USER, msg);
        if (stackTrace != null) {
            rec.setThrown(stackTrace);
        }
        ex.addRecord(rec);
        if (locMsg != null) {
            Exceptions.attachLocalizedMessage((Throwable)t, (String)locMsg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AnnException
    extends Exception
    implements Callable<LogRecord[]> {
        private List<LogRecord> records;

        static AnnException findOrCreate(Throwable t, boolean create) {
            if (t instanceof AnnException) {
                return (AnnException)t;
            }
            if (t.getCause() == null) {
                if (create) {
                    t.initCause(new AnnException());
                }
                return (AnnException)t.getCause();
            }
            return AnnException.findOrCreate(t.getCause(), create);
        }

        private AnnException() {
        }

        public synchronized void addRecord(LogRecord rec) {
            if (this.records == null) {
                this.records = new ArrayList<LogRecord>();
            }
            this.records.add(rec);
        }

        @Override
        public LogRecord[] call() {
            List<LogRecord> r = this.records;
            LogRecord[] empty = new LogRecord[]{};
            return r == null ? empty : r.toArray(empty);
        }
    }

    private static final class OwnLevel
    extends Level {
        public static final Level USER = new OwnLevel("USER", 1973);

        private OwnLevel(String s, int i) {
            super(s, i);
        }
    }
}

