/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.SaveAsCapable;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class SaveAsAction
extends AbstractAction
implements ContextAwareAction,
LookupListener,
PropertyChangeListener {
    private Lookup context;
    private Lookup.Result<SaveAsCapable> lkpInfo;
    private boolean isEditorWindowActivated;

    private SaveAsAction() {
        this(Utilities.actionsGlobalContext());
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
    }

    private SaveAsAction(Lookup context) {
        super(NbBundle.getMessage(DataObject.class, (String)"CTL_SaveAsAction"));
        this.context = context;
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public static ContextAwareAction create() {
        return new SaveAsAction();
    }

    void init() {
        assert (SwingUtilities.isEventDispatchThread()) : "this shall be called just from AWT thread";
        if (this.lkpInfo != null) {
            return;
        }
        Lookup.Template tpl = new Lookup.Template(SaveAsCapable.class);
        this.lkpInfo = this.context.lookup(tpl);
        this.lkpInfo.addLookupListener((LookupListener)this);
        this.propertyChange(null);
    }

    public boolean isEnabled() {
        this.init();
        return super.isEnabled();
    }

    public void actionPerformed(ActionEvent e) {
        this.init();
        Collection inst = this.lkpInfo.allInstances();
        if (inst.size() > 0) {
            SaveAsCapable saveAs = (SaveAsCapable)inst.iterator().next();
            File newFile = this.getNewFileName();
            if (null != newFile) {
                FileObject newFolder = null;
                try {
                    File targetFolder = newFile.getParentFile();
                    if (null == targetFolder) {
                        throw new IOException(newFile.getAbsolutePath());
                    }
                    newFolder = FileUtil.createFolder((File)targetFolder);
                }
                catch (IOException ioE) {
                    NotifyDescriptor error = new NotifyDescriptor((Object)NbBundle.getMessage(DataObject.class, (String)"MSG_CannotCreateTargetFolder"), NbBundle.getMessage(DataObject.class, (String)"LBL_SaveAsTitle"), -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
                    DialogDisplayer.getDefault().notify(error);
                    return;
                }
                try {
                    saveAs.saveAs(newFolder, newFile.getName());
                }
                catch (IOException ioE) {
                    Exceptions.attachLocalizedMessage((Throwable)ioE, (String)NbBundle.getMessage(DataObject.class, (String)"MSG_SaveAsFailed"));
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, null, ioE);
                }
            }
        }
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnabled(null != this.lkpInfo && this.lkpInfo.allItems().size() != 0 && this.isEditorWindowActivated);
    }

    private File getNewFileName() {
        File newFile = null;
        FileObject currentFileObject = this.getCurrentFileObject();
        if (null != currentFileObject) {
            newFile = FileUtil.toFile((FileObject)currentFileObject);
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getMessage(DataObject.class, (String)"LBL_SaveAsTitle"));
        chooser.setMultiSelectionEnabled(false);
        if (null != newFile) {
            chooser.setSelectedFile(newFile);
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, (File)newFile.getParentFile());
        }
        File origFile = newFile;
        if (0 != chooser.showSaveDialog(WindowManager.getDefault().getMainWindow())) {
            return null;
        }
        newFile = chooser.getSelectedFile();
        if (null == newFile || newFile.equals(origFile)) {
            return null;
        }
        return newFile;
    }

    private FileObject getCurrentFileObject() {
        DataObject dob;
        TopComponent tc = TopComponent.getRegistry().getActivated();
        if (null != tc && null != (dob = (DataObject)tc.getLookup().lookup(DataObject.class))) {
            return dob.getPrimaryFile();
        }
        return null;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new SaveAsAction(actionContext);
    }

    public void propertyChange(PropertyChangeEvent arg0) {
        TopComponent tc = TopComponent.getRegistry().getActivated();
        this.isEditorWindowActivated = null != tc && WindowManager.getDefault().isEditorTopComponent(tc);
        this.resultChanged(null);
    }
}

