/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

class ExecBridge
implements ActionListener,
PropertyChangeListener {
    private Node node;
    private AbstractButton button;
    private static Class execCookieClass = null;

    private static synchronized Class getExecCookieClass() {
        if (execCookieClass == null) {
            try {
                execCookieClass = Class.forName("org.openide.cookies.ExecCookie", true, (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class));
            }
            catch (ClassNotFoundException cnfe) {
                execCookieClass = ExecBridge.class;
            }
        }
        if (execCookieClass == ExecBridge.class) {
            return null;
        }
        return execCookieClass;
    }

    private ExecBridge(Node node, AbstractButton button) {
        this.node = node;
        this.button = button;
        button.addActionListener(this);
        node.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)node));
        this.updateState();
    }

    public void actionPerformed(ActionEvent ev) {
        Class c = ExecBridge.getExecCookieClass();
        if (c == null) {
            return;
        }
        Node.Cookie ec = this.node.getCookie(c);
        if (ec != null) {
            try {
                Method m = ExecBridge.getExecCookieClass().getMethod("start", new Class[0]);
                m.invoke((Object)ec, new Object[0]);
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if ("cookie".equals(ev.getPropertyName())) {
            this.updateState();
        }
        if ("displayName".equals(ev.getPropertyName())) {
            this.updateState();
        }
        if ("icon".equals(ev.getPropertyName())) {
            this.updateState();
        }
    }

    private void updateState() {
        this.button.setText(this.node.getDisplayName());
        ImageIcon icon = new ImageIcon(this.node.getIcon(1));
        this.button.setIcon(icon);
        Class c = ExecBridge.getExecCookieClass();
        this.button.setEnabled(c != null && this.node.getCookie(c) != null);
    }

    public static JMenuItem createMenuItem(DataObject obj) {
        if (!obj.isValid()) {
            return null;
        }
        Node n = obj.getNodeDelegate();
        Class c = ExecBridge.getExecCookieClass();
        if (c == null || n.getCookie(c) == null) {
            return null;
        }
        JMenuItem item = new JMenuItem();
        new ExecBridge(n, item);
        return item;
    }

    public static JButton createButton(DataObject obj) {
        if (!obj.isValid()) {
            return null;
        }
        Node n = obj.getNodeDelegate();
        Class c = ExecBridge.getExecCookieClass();
        if (c == null || n.getCookie(c) == null) {
            return null;
        }
        JButton item = new JButton();
        new ExecBridge(n, item);
        return item;
    }
}

