/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.AWTTask;
import org.openide.awt.Actions;
import org.openide.awt.DynaMenuModel;
import org.openide.awt.ExecBridge;
import org.openide.awt.Mnemonics;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.InstanceSupport;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuBar
extends JMenuBar
implements Externalizable {
    private MenuBarFolder menuBarFolder;
    static final long serialVersionUID = -4721949937356581268L;

    public MenuBar() {
    }

    public MenuBar(DataFolder folder) {
        this();
        DataFolder theFolder;
        boolean GTK = "GTK".equals(UIManager.getLookAndFeel().getID());
        if (!GTK) {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
        if ((theFolder = folder) == null) {
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("Menu");
            if (fo == null) {
                throw new IllegalStateException("No Menu/");
            }
            theFolder = DataFolder.findFolder(fo);
        }
        this.startLoading(theFolder);
        if (folder != null) {
            this.getAccessibleContext().setAccessibleDescription(folder.getName());
        }
    }

    @Override
    public void addImpl(Component c, Object constraint, int idx) {
        if (Utilities.isMac() && Boolean.getBoolean("apple.laf.useScreenMenuBar") && !(c instanceof JMenu)) {
            return;
        }
        super.addImpl(c, constraint, idx);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (Utilities.isMac()) {
            boolean isAlt;
            int mods = e.getModifiers();
            boolean isCtrl = (mods & 2) != 0;
            boolean bl = isAlt = (mods & 8) != 0;
            if (isAlt) {
                return false;
            }
            if (isAlt && !isCtrl) {
                mods &= 0xFFFFFFF7;
                mods &= 0xFFFFFDFF;
                mods |= 2;
                mods |= 0x80;
            } else if (!isAlt && isCtrl) {
                mods &= 0xFFFFFFFD;
                mods &= 0xFFFFFF7F;
                mods |= 8;
                mods |= 0x200;
            } else if (!isAlt && !isCtrl) {
                return super.processKeyBinding(ks, e, condition, pressed);
            }
            MarkedKeyEvent newEvent = new MarkedKeyEvent((Component)e.getSource(), e.getID(), e.getWhen(), mods, e.getKeyCode(), e.getKeyChar(), e.getKeyLocation());
            KeyStroke newStroke = e.getID() == 400 ? KeyStroke.getKeyStroke((int)ks.getKeyChar(), mods) : KeyStroke.getKeyStroke(ks.getKeyCode(), mods, !ks.isOnKeyRelease());
            boolean result = super.processKeyBinding(newStroke, newEvent, condition, pressed);
            if (newEvent.isConsumed()) {
                e.consume();
            }
            return result;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public void waitFinished() {
        this.menuBarFolder.instanceFinished();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.menuBarFolder.getFolder());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.startLoading((DataFolder)in.readObject());
    }

    void startLoading(DataFolder folder) {
        this.menuBarFolder = new MenuBarFolder(folder);
    }

    static void allInstances(InstanceCookie[] arr, List<Object> list) {
        Exception ex = null;
        for (int i = 0; i < arr.length; ++i) {
            Exception newEx = null;
            try {
                Object o = arr[i].instanceCreate();
                list.add(o);
            }
            catch (ClassNotFoundException e) {
                newEx = e;
            }
            catch (IOException e) {
                newEx = e;
            }
            if (newEx == null) continue;
            Throwable t = newEx;
            while (true) {
                if (t.getCause() == null) break;
                t = t.getCause();
            }
            t.initCause(ex);
            ex = newEx;
        }
        if (ex != null) {
            Exceptions.printStackTrace(ex);
        }
    }

    private static class LazyMenu
    extends JMenu
    implements NodeListener,
    Runnable,
    ChangeListener {
        DataFolder master;
        boolean icon;
        MenuFolder slave;
        DynaMenuModel dynaModel;
        private boolean selected = false;

        public LazyMenu(DataFolder df, boolean icon) {
            this.master = df;
            this.icon = icon;
            this.dynaModel = new DynaMenuModel();
            this.slave = new MenuFolder();
            Node n = this.master.getNodeDelegate();
            n.addNodeListener(NodeOp.weakNodeListener((NodeListener)this, (Object)n));
            this.updateProps();
            this.getModel().addChangeListener(this);
        }

        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            if (Utilities.isMac()) {
                boolean isAlt;
                int mods = e.getModifiers();
                boolean isCtrl = (mods & 2) != 0;
                boolean bl = isAlt = (mods & 8) != 0;
                if (isAlt && e instanceof MarkedKeyEvent) {
                    mods &= 0xFFFFFFFD;
                    mods &= 0xFFFFFF7F;
                    mods |= 8;
                    MarkedKeyEvent newEvent = new MarkedKeyEvent((Component)e.getSource(), e.getID(), e.getWhen(), mods |= 0x200, e.getKeyCode(), e.getKeyChar(), e.getKeyLocation());
                    KeyStroke newStroke = e.getID() == 400 ? KeyStroke.getKeyStroke((int)ks.getKeyChar(), mods) : KeyStroke.getKeyStroke(ks.getKeyCode(), mods, !ks.isOnKeyRelease());
                    boolean result = super.processKeyBinding(newStroke, newEvent, condition, pressed);
                    if (newEvent.isConsumed()) {
                        e.consume();
                    }
                    return result;
                }
                if (!isAlt) {
                    return super.processKeyBinding(ks, e, condition, pressed);
                }
                return false;
            }
            return super.processKeyBinding(ks, e, condition, pressed);
        }

        private void updateProps() {
            if (this.master.isValid()) {
                Node n = this.master.getNodeDelegate();
                Mnemonics.setLocalizedText((AbstractButton)this, (String)n.getDisplayName());
                if (this.icon) {
                    this.setIcon(new ImageIcon(n.getIcon(1)));
                }
            } else {
                this.setText(this.master.getName());
                this.setIcon(null);
            }
        }

        public void run() {
            this.updateProps();
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if ("displayName".equals(ev.getPropertyName()) || "name".equals(ev.getPropertyName()) || "icon".equals(ev.getPropertyName())) {
                if (EventQueue.isDispatchThread()) {
                    this.updateProps();
                } else {
                    EventQueue.invokeLater(this);
                }
            }
        }

        public void childrenAdded(NodeMemberEvent ev) {
        }

        public void childrenRemoved(NodeMemberEvent ev) {
        }

        public void childrenReordered(NodeReorderEvent ev) {
        }

        public void nodeDestroyed(NodeEvent ev) {
        }

        public void stateChanged(ChangeEvent event) {
            if (this.selected) {
                this.selected = false;
            } else {
                this.selected = true;
                this.doInitialize();
                this.dynaModel.checkSubmenu(this);
            }
        }

        private void doInitialize() {
            this.slave.waitFinishedSuper();
        }

        private class MenuFolder
        extends FolderInstance {
            public MenuFolder() {
                super(LazyMenu.this.master);
            }

            public String instanceName() {
                return LazyMenu.class.getName();
            }

            public Class instanceClass() {
                return JMenu.class;
            }

            public Object instanceCreate() throws IOException, ClassNotFoundException {
                return LazyMenu.this;
            }

            public void waitFinished() {
            }

            void waitFinishedSuper() {
                super.waitFinished();
            }

            protected InstanceCookie acceptDataObject(DataObject dob) {
                InstanceCookie ic = super.acceptDataObject(dob);
                if (ic == null) {
                    JMenuItem item = ExecBridge.createMenuItem(dob);
                    return item != null ? new InstanceSupport.Instance(item) : null;
                }
                return ic;
            }

            protected InstanceCookie acceptCookie(InstanceCookie cookie) throws IOException, ClassNotFoundException {
                Class c = cookie.instanceClass();
                boolean is = Presenter.Menu.class.isAssignableFrom(c) || JMenuItem.class.isAssignableFrom(c) || JSeparator.class.isAssignableFrom(c) || Action.class.isAssignableFrom(c);
                return is ? cookie : null;
            }

            protected InstanceCookie acceptFolder(DataFolder df) {
                boolean hasIcon = df.getPrimaryFile().getAttribute("SystemFileSystem.icon") != null;
                return new LazyMenu((DataFolder)df, (boolean)hasIcon).slave;
            }

            protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
                LazyMenu m = LazyMenu.this;
                LinkedList<Object> cInstances = new LinkedList<Object>();
                MenuBar.allInstances(cookies, cInstances);
                m.removeAll();
                if (cInstances.isEmpty()) {
                    JMenuItem item = new JMenuItem(NbBundle.getMessage(DataObject.class, (String)"CTL_EmptyMenu"));
                    item.setEnabled(false);
                    m.add(item);
                }
                m.dynaModel.loadSubmenu(cInstances, m);
                return m;
            }

            protected Task postCreationTask(Runnable run) {
                return new AWTTask(run);
            }
        }
    }

    private static final class MarkedKeyEvent
    extends KeyEvent {
        public MarkedKeyEvent(Component c, int id, long when, int mods, int code, char kchar, int loc) {
            super(c, id, when, mods, code, kchar, loc);
        }
    }

    private final class MenuBarFolder
    extends FolderInstance {
        private ArrayList<Component> managed;

        public MenuBarFolder(DataFolder folder) {
            super(folder);
            this.managed = new ArrayList();
            this.recreate();
        }

        private void cleanUp() {
            Iterator<Component> it = this.managed.iterator();
            while (it.hasNext()) {
                MenuBar.this.remove(it.next());
            }
            this.managed.clear();
        }

        private void addComponent(Component c) {
            MenuBar.this.add(c, this.managed.size());
            this.managed.add(c);
        }

        public String instanceName() {
            return MenuBar.class.getName();
        }

        public Class instanceClass() {
            return MenuBar.class;
        }

        protected InstanceCookie acceptCookie(InstanceCookie cookie) throws IOException, ClassNotFoundException {
            Class cls = cookie.instanceClass();
            boolean is = Component.class.isAssignableFrom(cls) || Presenter.Toolbar.class.isAssignableFrom(cls) || Action.class.isAssignableFrom(cls);
            return is ? cookie : null;
        }

        protected InstanceCookie acceptFolder(DataFolder df) {
            return new LazyMenu((DataFolder)df, (boolean)false).slave;
        }

        protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
            LinkedList<Object> ll = new LinkedList<Object>();
            MenuBar.allInstances(cookies, ll);
            MenuBar mb = MenuBar.this;
            if (ll.equals(Arrays.asList(mb.getComponents()))) {
                return mb;
            }
            this.cleanUp();
            for (Object e : ll) {
                Component component = this.convertToComponent(e);
                if (component == null) continue;
                this.addComponent(component);
            }
            mb.validate();
            mb.repaint();
            return mb;
        }

        private Component convertToComponent(Object obj) {
            Component retVal = null;
            if (obj instanceof Component) {
                retVal = (Component)obj;
            } else if (obj instanceof Presenter.Toolbar) {
                retVal = ((Presenter.Toolbar)obj).getToolbarPresenter();
            } else if (obj instanceof Action) {
                Action a = (Action)obj;
                JButton button = new JButton();
                Actions.connect((AbstractButton)button, (Action)a);
                retVal = button;
            }
            if (retVal instanceof JButton) {
                ((JButton)retVal).setBorderPainted(false);
                ((JButton)retVal).setMargin(new Insets(0, 2, 0, 2));
            }
            return retVal;
        }

        DataFolder getFolder() {
            return this.folder;
        }

        protected Task postCreationTask(Runnable run) {
            return new AWTTask(run);
        }
    }
}

