/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.InstanceDataObject;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.actions.SystemAction;

final class DataLdrActions
extends FolderInstance {
    private Reference<DataLoader> ref;
    private Task creation;
    private static RequestProcessor RP = new RequestProcessor("Loader Actions");

    public DataLdrActions(DataFolder f, DataLoader l) {
        super(f);
        this.ref = new WeakReference<DataLoader>(l);
    }

    public synchronized void setActions(final SystemAction[] arr) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DoTheWork
        implements Runnable,
        FileSystem.AtomicAction {
            private int state;

            DoTheWork() {
            }

            private void work() throws IOException {
                DataObject[] now = DataLdrActions.this.folder.getChildren();
                HashMap<Object, DataObject> nowToObj = new HashMap<Object, DataObject>();
                LinkedList<DataObject> sepObjs = new LinkedList<DataObject>();
                for (int i = 0; i < now.length; ++i) {
                    InstanceCookie ic = now[i].getCookie(InstanceCookie.class);
                    if (ic == null) continue;
                    try {
                        Object instance = ic.instanceCreate();
                        if (instance instanceof Action) {
                            nowToObj.put(instance, now[i]);
                            continue;
                        }
                        if (!(instance instanceof JSeparator)) continue;
                        sepObjs.add(now[i]);
                        continue;
                    }
                    catch (ClassNotFoundException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                ArrayList<DataObject> order = new ArrayList<DataObject>();
                for (int i = 0; i < arr.length; ++i) {
                    DataObject obj = (DataObject)nowToObj.remove(arr[i]);
                    if (obj == null) {
                        obj = arr[i] != null ? InstanceDataObject.create(DataLdrActions.this.folder, null, arr[i].getClass()) : (!sepObjs.isEmpty() ? (DataObject)sepObjs.removeFirst() : InstanceDataObject.create(DataLdrActions.this.folder, "Separator" + order.size(), JSeparator.class));
                    }
                    order.add(obj);
                }
                for (DataObject obj : nowToObj.values()) {
                    obj.delete();
                }
                for (DataObject obj : sepObjs) {
                    obj.delete();
                }
                DataLdrActions.this.folder.setOrder(order.toArray(new DataObject[0]));
            }

            @Override
            public void run() {
                try {
                    switch (this.state) {
                        case 0: {
                            this.state = 1;
                            DataLdrActions.this.folder.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)this);
                            break;
                        }
                        case 1: {
                            this.work();
                        }
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        DoTheWork dtw = new DoTheWork();
        this.creation = RP.post((Runnable)dtw);
    }

    protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
        ArrayList<Action> list = new ArrayList<Action>();
        for (int i = 0; i < cookies.length; ++i) {
            Class clazz = cookies[i].instanceClass();
            if (JSeparator.class.isAssignableFrom(clazz)) {
                list.add(null);
                continue;
            }
            Object action = cookies[i].instanceCreate();
            if (!(action instanceof Action)) continue;
            list.add((Action)action);
        }
        DataLoader l = this.ref.get();
        if (l != null) {
            l.setSwingActions(list);
        }
        return list.toArray(new Action[0]);
    }

    protected InstanceCookie acceptFolder(DataFolder df) {
        return null;
    }

    protected Task postCreationTask(Runnable run) {
        return RP.post(run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFinished() {
        Task t;
        DataLdrActions dataLdrActions = this;
        synchronized (dataLdrActions) {
            t = this.creation;
        }
        if (t != null) {
            t.waitFinished();
        }
        super.waitFinished();
    }
}

