/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openide.filesystems.FileObject;
import org.openide.util.Enumerations;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionList
implements Cloneable,
Serializable {
    private static final boolean CASE_INSENSITIVE = Utilities.isWindows() || Utilities.getOperatingSystem() == 2048 || Utilities.getOperatingSystem() == 16384;
    private SortedSet<String> list;
    private SortedSet<String> mimeTypes;
    static final long serialVersionUID = 8868581349510386291L;

    public synchronized Object clone() {
        try {
            ExtensionList l = (ExtensionList)super.clone();
            if (this.list != null) {
                l.list = ExtensionList.createExtensionSet();
                l.list.addAll(this.list);
            }
            if (this.mimeTypes != null) {
                l.mimeTypes = ExtensionList.createExtensionSet();
                l.mimeTypes.addAll(this.mimeTypes);
            }
            return l;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public synchronized void addExtension(String ext) {
        if (this.list == null) {
            this.list = ExtensionList.createExtensionSet();
        }
        this.list.add(ext);
    }

    public void removeExtension(String ext) {
        if (this.list != null) {
            this.list.remove(ext);
        }
    }

    public synchronized void addMimeType(String mime) {
        if (this.mimeTypes == null) {
            this.mimeTypes = new TreeSet<String>();
        }
        this.mimeTypes.add(mime);
    }

    public void removeMimeType(String mime) {
        if (this.mimeTypes != null) {
            this.mimeTypes.remove(mime);
        }
    }

    public boolean isRegistered(String s) {
        if (this.list == null) {
            return false;
        }
        try {
            String ext = s.substring(s.lastIndexOf(46) + 1);
            return this.list.contains(ext);
        }
        catch (StringIndexOutOfBoundsException ex) {
            return false;
        }
    }

    public boolean isRegistered(FileObject fo) {
        if (this.list != null && this.list.contains(fo.getExt())) {
            return true;
        }
        return this.mimeTypes != null && this.mimeTypes.contains(fo.getMIMEType());
    }

    public Enumeration<String> extensions() {
        return ExtensionList.en(this.list);
    }

    public Enumeration<String> mimeTypes() {
        return ExtensionList.en(this.mimeTypes);
    }

    public String toString() {
        return "ExtensionList[" + this.list + this.mimeTypes + "]";
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExtensionList)) {
            return false;
        }
        ExtensionList e = (ExtensionList)o;
        return ExtensionList.equalSets(this.list, e.list, CASE_INSENSITIVE) && ExtensionList.equalSets(this.mimeTypes, e.mimeTypes, false);
    }

    public int hashCode() {
        int x = 0;
        if (this.list != null) {
            x = ((Object)ExtensionList.normalizeSet(this.list, CASE_INSENSITIVE)).hashCode();
        }
        if (this.mimeTypes != null) {
            x += ((Object)ExtensionList.normalizeSet(this.mimeTypes, false)).hashCode();
        }
        return x;
    }

    private static boolean equalSets(Set<String> s1, Set<String> s2, boolean flattenCase) {
        if (s1 == null && s2 == null) {
            return true;
        }
        Set<String> s1a = ExtensionList.normalizeSet(s1, flattenCase);
        Set<String> s2a = ExtensionList.normalizeSet(s2, flattenCase);
        return ((Object)s1a).equals(s2a);
    }

    private static Set<String> normalizeSet(Set<String> s, boolean flattenCase) {
        if (s == null || s.isEmpty()) {
            return Collections.emptySet();
        }
        if (flattenCase) {
            HashSet<String> s2 = new HashSet<String>(s.size() * 4 / 3 + 1);
            for (String item : s) {
                s2.add(item.toLowerCase(Locale.US));
            }
            return s2;
        }
        return s;
    }

    private static Enumeration<String> en(Collection<String> c) {
        if (c == null) {
            return Enumerations.empty();
        }
        return Collections.enumeration(c);
    }

    private static SortedSet<String> createExtensionSet() {
        if (CASE_INSENSITIVE) {
            return new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        }
        return new TreeSet<String>();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gf = ois.readFields();
        Set list = gf.get("list", null);
        if (list instanceof Map) {
            list = ((Map)((Object)list)).keySet();
        }
        if (list != null) {
            this.list = ExtensionList.createExtensionSet();
            this.list.addAll(list);
        }
        this.mimeTypes = (TreeSet)gf.get("mimeTypes", null);
    }
}

