/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.FolderList;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FolderChildren
extends Children.Keys<Pair>
implements PropertyChangeListener,
ChangeListener {
    private DataFolder folder;
    private final DataFilter filter;
    private PropertyChangeListener listener;
    private Logger err;
    private boolean refresh;
    private RequestProcessor.Task refreshTask;
    private ChildrenRefreshRunnable refreshRunnable;
    private static RequestProcessor refRP = new RequestProcessor("FolderChildren_Refresh");

    public FolderChildren(DataFolder f) {
        this(f, DataFilter.ALL);
    }

    public FolderChildren(DataFolder f, DataFilter filter) {
        this.folder = f;
        this.filter = filter;
        this.refreshRunnable = new ChildrenRefreshRunnable();
        this.refreshTask = refRP.create((Runnable)this.refreshRunnable);
        this.listener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.folder);
        this.err = Logger.getLogger("org.openide.loaders.FolderChildren." + f.getPrimaryFile().getPath().replace('/', '.'));
    }

    DataFilter getFilter() {
        return this.filter;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if ("children".equals(ev.getPropertyName())) {
            this.err.fine("Got PROP_CHILDREN");
            this.refreshChildren().schedule(0);
            this.postClearTask();
            return;
        }
        if ("sortMode".equals(ev.getPropertyName()) || "order".equals(ev.getPropertyName())) {
            this.err.fine("Got PROP_SORT_MODE or PROP_ORDER");
            this.refreshChildren().schedule(0);
            this.postClearTask();
            return;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refresh = true;
        this.refreshChildren().schedule(0);
        this.postClearTask();
    }

    private void postClearTask() {
        refRP.post(new Runnable(){

            public void run() {
                FolderChildren.this.refreshRunnable.clear();
            }
        });
    }

    RequestProcessor.Task refreshChildren() {
        return this.refreshTask;
    }

    protected Node[] createNodes(Pair key) {
        this.err.fine("createNodes: " + key);
        FileObject fo = key.primaryFile;
        try {
            DataObject obj = DataObject.find(fo);
            if (this.filter == null || this.filter.acceptDataObject(obj)) {
                return new Node[]{obj.getClonedNodeDelegate(this.filter)};
            }
            return new Node[0];
        }
        catch (DataObjectNotFoundException e) {
            Logger.getLogger(FolderChildren.class.getName()).log(Level.FINE, null, e);
            return new Node[0];
        }
    }

    public Node[] getNodes(boolean optimalResult) {
        Node[] res;
        if (optimalResult) {
            if (FolderChildren.checkChildrenMutex()) {
                this.err.fine("getNodes(true)");
                FolderList.find(this.folder.getPrimaryFile(), true).waitProcessingFinished();
                this.err.fine("getNodes(true): waitProcessingFinished");
                RequestProcessor.Task task = this.refreshChildren();
                res = this.getNodes();
                this.err.fine("getNodes(true): getNodes: " + res.length);
                task.schedule(0);
                task.waitFinished();
                this.err.fine("getNodes(true): waitFinished");
            } else {
                Logger.getLogger(FolderChildren.class.getName()).log(Level.WARNING, null, new IllegalStateException("getNodes(true) called while holding the Children.MUTEX"));
            }
        }
        res = this.getNodes();
        this.err.fine("getNodes(boolean): post clear task");
        this.postClearTask();
        return res;
    }

    public Node findChild(String name) {
        if (FolderChildren.checkChildrenMutex()) {
            this.getNodes(true);
        }
        return super.findChild(name);
    }

    static boolean checkChildrenMutex() {
        return !Children.MUTEX.isReadAccess() && !Children.MUTEX.isWriteAccess();
    }

    protected void addNotify() {
        this.err.fine("addNotify begin");
        this.folder.addPropertyChangeListener(this.listener);
        if (this.filter instanceof ChangeableDataFilter) {
            ((ChangeableDataFilter)this.filter).addChangeListener(this);
        }
        this.refreshChildren().schedule(0);
        this.err.fine("addNotify end");
    }

    protected void removeNotify() {
        this.err.fine("removeNotify begin");
        this.folder.removePropertyChangeListener(this.listener);
        if (this.filter instanceof ChangeableDataFilter) {
            ((ChangeableDataFilter)this.filter).removeChangeListener(this);
        }
        this.setKeys(Collections.emptySet());
        this.err.fine("removeNotify end");
    }

    public String toString() {
        return this.folder != null ? this.folder.getPrimaryFile().toString() : super.toString();
    }

    private final class ChildrenRefreshRunnable
    implements Runnable {
        private DataObject[] ch;

        private ChildrenRefreshRunnable() {
        }

        public void run() {
            assert (refRP.isRequestProcessorThread());
            FolderList.find(FolderChildren.this.folder.getPrimaryFile(), true).waitProcessingFinished();
            this.ch = FolderChildren.this.folder.getChildren();
            FolderChildren.this.err.fine("Children computed");
            Pair[] keys = new Pair[this.ch.length];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = new Pair(this.ch[i].getPrimaryFile());
            }
            FolderChildren.this.setKeys(Arrays.asList(keys));
            if (FolderChildren.this.refresh) {
                FolderChildren.this.refresh = false;
                for (Pair key : keys) {
                    FolderChildren.this.refreshKey(key);
                }
            }
            if (!FolderChildren.this.isInitialized()) {
                this.clear();
            }
        }

        public void clear() {
            assert (refRP.isRequestProcessorThread());
            FolderChildren.this.err.fine("Clearing the reference to children");
            this.ch = null;
        }
    }

    static final class Pair {
        public FileObject primaryFile;
        public int seq;

        public Pair(FileObject primaryFile) {
            this.primaryFile = primaryFile;
            this.seq = DataObjectPool.getPOOL().registrationCount(primaryFile);
        }

        public int hashCode() {
            return this.primaryFile.hashCode() ^ this.seq;
        }

        public boolean equals(Object o) {
            if (o instanceof Pair) {
                Pair p = (Pair)o;
                return this.primaryFile.equals(p.primaryFile) && this.seq == p.seq;
            }
            return false;
        }

        public String toString() {
            return "FolderChildren.Pair[" + this.primaryFile + "," + this.seq + "]";
        }
    }
}

