/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderList;
import org.openide.loaders.FolderListListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FolderInstance
extends Task
implements InstanceCookie {
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Folder Instance Processor");
    private static final ThreadLocal<Object> CURRENT = new ThreadLocal();
    private static final ThreadLocal<Object> LAST_CURRENT = new ThreadLocal();
    protected DataFolder folder;
    private DataObject.Container container;
    private HashMap<FileObject, HoldInstance> map = new HashMap(17);
    private Task[] waitFor;
    private Object object = CURRENT;
    private Listener listener;
    private Logger err;
    private Task recognizingTask;
    private Task creationTask;

    public FolderInstance(DataFolder df) {
        this((DataObject.Container)df);
    }

    public FolderInstance(DataObject.Container container) {
        this(container, null);
    }

    private FolderInstance(DataObject.Container container, String logName) {
        if (container instanceof DataFolder) {
            this.folder = (DataFolder)container;
            if (logName == null) {
                logName = this.folder.getPrimaryFile().getPath().replace('/', '.');
            }
            container = FolderList.find(this.folder.getPrimaryFile(), true);
        }
        this.listener = new Listener();
        logName = logName == null ? "org.openide.loaders.FolderInstance" : "org.openide.loaders.FolderInstance." + logName;
        this.err = Logger.getLogger(logName);
        this.container = container;
        container.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)container));
        if (this.err.isLoggable(Level.FINE)) {
            this.err.fine("new " + (Object)((Object)this));
        }
    }

    public String instanceName() {
        try {
            return this.instanceClass().getName();
        }
        catch (IOException ex) {
            return "java.lang.Object";
        }
        catch (ClassNotFoundException ex) {
            return "java.lang.Object";
        }
    }

    public Class<?> instanceClass() throws IOException, ClassNotFoundException {
        Object object = this.object;
        if (object != null) {
            if (object instanceof IOException) {
                throw (IOException)object;
            }
            if (object instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)object;
            }
            return object.getClass();
        }
        return Object.class;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        Object object = CURRENT.get();
        if (object == null || LAST_CURRENT.get() != this) {
            this.err.fine("do into waitFinished");
            this.waitFinished();
            object = this.object;
        }
        if (this.err.isLoggable(Level.FINE)) {
            this.err.fine("instanceCreate: " + object);
        }
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        if (object instanceof ClassNotFoundException) {
            throw (ClassNotFoundException)object;
        }
        if (object == CURRENT) {
            throw new IOException("Cyclic reference. Somebody is trying to get value from FolderInstance (" + ((Object)((Object)this)).getClass().getName() + ") from the same thread that is processing the instance");
        }
        return object;
    }

    public final void instanceFinished() {
        this.waitFinished();
    }

    public void waitFinished() {
        block7: {
            Task originalRecognizing;
            boolean isLog = this.err.isLoggable(Level.FINE);
            do {
                this.err.fine("waitProcessingFinished on container");
                FolderInstance.waitProcessingFinished(this.container);
                originalRecognizing = this.checkRecognizingStarted();
                if (isLog) {
                    this.err.fine("checkRecognizingStarted: " + originalRecognizing);
                }
                originalRecognizing.waitFinished();
                Task t = this.creationTask;
                if (isLog) {
                    this.err.fine("creationTask: " + this.creationTask);
                }
                if (t != null) {
                    t.waitFinished();
                }
                Task[] toWait = this.waitFor;
                if (isLog) {
                    this.err.fine("toWait: " + toWait);
                }
                if (toWait == null) continue;
                for (int i = 0; i < toWait.length; ++i) {
                    if (isLog) {
                        this.err.fine("  wait[" + i + "]: " + toWait[i]);
                    }
                    toWait[i].waitFinished();
                }
            } while (originalRecognizing != this.checkRecognizingStarted());
            if (!isLog) break block7;
            this.err.fine("breaking the wait loop");
        }
    }

    public void run() {
        this.recreate();
        this.instanceFinished();
    }

    protected InstanceCookie acceptDataObject(DataObject dob) {
        DataObject.Container c;
        DataFolder folder;
        int acceptType = -1;
        Object cookie = dob.getCookie(InstanceCookie.class);
        try {
            cookie = cookie == null ? null : this.acceptCookie((InstanceCookie)cookie);
            acceptType = 1;
        }
        catch (IOException ex) {
            this.err.log(Level.WARNING, null, ex);
            cookie = null;
        }
        catch (ClassNotFoundException ex) {
            this.err.log(Level.WARNING, null, ex);
            cookie = null;
        }
        if (cookie == null && (folder = dob.getCookie(DataFolder.class)) != null) {
            HoldInstance previous = this.map.get(folder.getPrimaryFile());
            if (previous != null && previous.cookie != null) {
                cookie = previous;
                acceptType = 2;
            } else {
                cookie = this.acceptFolder(folder);
                acceptType = 3;
            }
        }
        if (cookie == null && (c = dob.getCookie(DataObject.Container.class)) != null) {
            cookie = this.acceptContainer(c);
            acceptType = 4;
        }
        if (this.err.isLoggable(Level.FINE)) {
            this.err.fine("acceptDataObject: " + dob + " cookie: " + cookie + " acceptType: " + acceptType);
        }
        return cookie;
    }

    protected InstanceCookie acceptCookie(InstanceCookie cookie) throws IOException, ClassNotFoundException {
        return cookie;
    }

    protected InstanceCookie acceptFolder(DataFolder df) {
        return this.acceptContainer(df);
    }

    protected InstanceCookie acceptContainer(DataObject.Container container) {
        return null;
    }

    protected abstract Object createInstance(InstanceCookie[] var1) throws IOException, ClassNotFoundException;

    protected Object instanceForCookie(DataObject obj, InstanceCookie cookie) throws IOException, ClassNotFoundException {
        return cookie.instanceCreate();
    }

    public synchronized void recreate() {
        this.err.fine("recreate");
        this.recognizingTask = FolderInstance.computeChildrenList(this.container, this.listener);
        if (this.err.isLoggable(Level.FINE)) {
            this.err.fine("  recognizing task is now " + this.recognizingTask);
        }
        this.notifyRunning();
    }

    final void checkRecreate() {
        if (this.isFinished()) {
            this.recreate();
        }
    }

    private final synchronized Task checkRecognizingStarted() {
        if (this.recognizingTask == null) {
            this.recreate();
        }
        return this.recognizingTask;
    }

    private static void waitProcessingFinished(DataObject.Container c) {
        if (c instanceof FolderList) {
            ((FolderList)c).waitProcessingFinished();
        }
    }

    private static Task computeChildrenList(final DataObject.Container container, final FolderListListener listener) {
        if (container instanceof FolderList) {
            FolderList list = (FolderList)container;
            return list.computeChildrenList(listener);
        }
        return PROCESSOR.post(new Runnable(){

            public void run() {
                DataObject[] arr = container.getChildren();
                ArrayList<DataObject> list = new ArrayList<DataObject>(arr.length);
                for (int i = 0; i < arr.length; ++i) {
                    listener.process(arr[i], list);
                }
                listener.finished(list);
            }
        });
    }

    final void processObjects(final Collection<DataObject> arr) {
        this.creationTask = this.postCreationTask(new Runnable(){

            public void run() {
                FolderInstance.this.defaultProcessObjects(arr);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void defaultProcessObjects(Collection<DataObject> arr) {
        Object result;
        HoldInstance[] all;
        block39: {
            HashSet<FileObject> toRemove;
            this.err.fine("defaultProcessObjects");
            ArrayList<HoldInstance> cookies = new ArrayList<HoldInstance>();
            ThreadLocal<Object> threadLocal = CURRENT;
            synchronized (threadLocal) {
                toRemove = new HashSet<FileObject>(this.map.keySet());
            }
            for (DataObject obj : arr) {
                if (!obj.isValid()) continue;
                InstanceCookie cookie = this.acceptDataObject(obj);
                if (cookie != null) {
                    FileObject fo = obj.getPrimaryFile();
                    boolean attachListener = true;
                    HoldInstance prevCookie = null;
                    if (toRemove.remove(fo) && (prevCookie = this.map.get(fo)) != null && (prevCookie.cookie == null || !prevCookie.cookie.equals(cookie))) {
                        prevCookie = null;
                        attachListener = false;
                    }
                    if (prevCookie == null) {
                        HoldInstance hold = cookie instanceof HoldInstance ? (HoldInstance)cookie : new HoldInstance(obj, cookie);
                        ThreadLocal<Object> threadLocal2 = CURRENT;
                        synchronized (threadLocal2) {
                            this.map.put(fo, hold);
                        }
                        if (attachListener) {
                            obj.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)obj));
                        }
                        cookies.add(hold);
                        continue;
                    }
                    cookies.add(prevCookie);
                    continue;
                }
                ThreadLocal<Object> threadLocal3 = CURRENT;
                synchronized (threadLocal3) {
                    FileObject fo = obj.getPrimaryFile();
                    toRemove.remove(fo);
                    HoldInstance hold = this.map.get(fo);
                    if (hold != null && hold.cookie == null) {
                        continue;
                    }
                    hold = new HoldInstance(obj, null);
                    this.map.put(fo, hold);
                }
                obj.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)obj));
            }
            ThreadLocal<Object> i$ = CURRENT;
            synchronized (i$) {
                this.map.keySet().removeAll(toRemove);
            }
            all = new HoldInstance[cookies.size()];
            cookies.toArray(all);
            this.updateWaitFor(all);
            result = null;
            result = this.createInstance((InstanceCookie[])all);
            Object var16_19 = null;
            if (!this.err.isLoggable(Level.FINE)) break block39;
            this.err.fine("notifying finished");
            for (int log = 0; log < all.length; ++log) {
                this.err.fine("  #" + log + ": " + all[log]);
            }
        }
        this.object = result;
        Object prevResult = CURRENT.get();
        CURRENT.set(result);
        Object prevLast = LAST_CURRENT.get();
        LAST_CURRENT.set((Object)this);
        try {
            this.notifyFinished();
        }
        finally {
            CURRENT.set(prevResult);
            LAST_CURRENT.set(prevLast);
        }
        {
            catch (IOException ex) {
                result = ex;
                Object var16_20 = null;
                if (this.err.isLoggable(Level.FINE)) {
                    this.err.fine("notifying finished");
                    for (int log = 0; log < all.length; ++log) {
                        this.err.fine("  #" + log + ": " + all[log]);
                    }
                }
                this.object = result;
                prevResult = CURRENT.get();
                CURRENT.set(result);
                prevLast = LAST_CURRENT.get();
                LAST_CURRENT.set((Object)this);
                try {
                    this.notifyFinished();
                }
                finally {
                    CURRENT.set(prevResult);
                    LAST_CURRENT.set(prevLast);
                }
            }
            catch (ClassNotFoundException ex) {
                result = ex;
                Object var16_21 = null;
                if (this.err.isLoggable(Level.FINE)) {
                    this.err.fine("notifying finished");
                    for (int log = 0; log < all.length; ++log) {
                        this.err.fine("  #" + log + ": " + all[log]);
                    }
                }
                this.object = result;
                prevResult = CURRENT.get();
                CURRENT.set(result);
                prevLast = LAST_CURRENT.get();
                LAST_CURRENT.set((Object)this);
                try {
                    this.notifyFinished();
                }
                finally {
                    CURRENT.set(prevResult);
                    LAST_CURRENT.set(prevLast);
                }
            }
        }
        catch (Throwable throwable) {
            Object var16_22 = null;
            if (this.err.isLoggable(Level.FINE)) {
                this.err.fine("notifying finished");
                for (int log = 0; log < all.length; ++log) {
                    this.err.fine("  #" + log + ": " + all[log]);
                }
            }
            this.object = result;
            prevResult = CURRENT.get();
            CURRENT.set(result);
            prevLast = LAST_CURRENT.get();
            LAST_CURRENT.set((Object)this);
            try {
                this.notifyFinished();
            }
            finally {
                CURRENT.set(prevResult);
                LAST_CURRENT.set(prevLast);
            }
            throw throwable;
        }
    }

    private void updateWaitFor(HoldInstance[] arr) {
        ArrayList<Task> out = new ArrayList<Task>(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            Task t = arr[i].getTask();
            if (t == null) continue;
            out.add(t);
        }
        this.waitFor = out.toArray(new Task[out.size()]);
    }

    protected Task postCreationTask(Runnable run) {
        return PROCESSOR.post(run);
    }

    final Logger err() {
        return this.err;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "@" + Integer.toHexString(System.identityHashCode((Object)this)) + "(" + this.container + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HoldInstance
    implements InstanceCookie.Of,
    TaskListener {
        private final DataObject source;
        protected final InstanceCookie cookie;

        public HoldInstance(DataObject source, InstanceCookie cookie) {
            this.cookie = cookie;
            this.source = source;
            if (cookie instanceof Task) {
                Task t = (Task)cookie;
                t.addTaskListener((TaskListener)WeakListeners.create(TaskListener.class, (EventListener)((Object)this), (Object)t));
            }
        }

        public String instanceName() {
            return this.cookie.instanceName();
        }

        public boolean instanceOf(Class<?> type) {
            if (this.cookie instanceof InstanceCookie.Of) {
                InstanceCookie.Of of = (InstanceCookie.Of)this.cookie;
                return of.instanceOf(type);
            }
            try {
                Class clazz = this.cookie.instanceClass();
                return type.isAssignableFrom(clazz);
            }
            catch (IOException ex) {
                return false;
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return this.cookie.instanceClass();
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            return FolderInstance.this.instanceForCookie(this.source, this.cookie);
        }

        public void taskFinished(Task task) {
            FolderInstance.this.checkRecreate();
        }

        public Task getTask() {
            if (this.cookie instanceof Task) {
                return (Task)this.cookie;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Listener
    implements PropertyChangeListener,
    FolderListListener {
        Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            Object s = ev.getSource();
            if (s == FolderInstance.this.container) {
                if ("children".equals(ev.getPropertyName())) {
                    FolderInstance.this.err.fine("PROP_CHILDREN");
                    FolderInstance.this.recreate();
                }
                return;
            }
            if ("name".equals(ev.getPropertyName()) && s instanceof DataObject) {
                FolderInstance.this.err.fine("PROP_NAME");
                FolderInstance.this.recreate();
            }
            if ("cookie".equals(ev.getPropertyName()) && s instanceof DataObject) {
                HoldInstance hi;
                DataObject source = (DataObject)s;
                FolderInstance.this.err.fine("PROP_COOKIE: " + source);
                InstanceCookie ic = FolderInstance.this.acceptDataObject(source);
                FileObject fo = source.getPrimaryFile();
                ThreadLocal threadLocal = CURRENT;
                synchronized (threadLocal) {
                    hi = (HoldInstance)FolderInstance.this.map.get(fo);
                }
                if (hi != null) {
                    FolderInstance.this.err.fine("previous instance: " + hi + " new instance " + ic);
                    if (ic == null || ic != hi && !ic.equals(hi.cookie)) {
                        hi = new HoldInstance(source, ic);
                        threadLocal = CURRENT;
                        synchronized (threadLocal) {
                            FolderInstance.this.map.put(fo, hi);
                        }
                        FolderInstance.this.recreate();
                    }
                }
            }
        }

        @Override
        public void finished(List<DataObject> arr) {
            FolderInstance.this.processObjects(arr);
        }

        @Override
        public void process(DataObject obj, List<DataObject> arr) {
            arr.add(obj);
        }
    }
}

