/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Level;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.MultiDataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiFileLoader
extends DataLoader {
    static final long serialVersionUID = 1521919955690157343L;

    @Deprecated
    protected MultiFileLoader(Class<? extends DataObject> representationClass) {
        super(representationClass);
    }

    protected MultiFileLoader(String representationClassName) {
        super(representationClassName);
    }

    @Override
    protected final DataObject handleFindDataObject(FileObject fo, DataLoader.RecognizedFiles recognized) throws IOException {
        MultiDataObject obj;
        boolean willLog;
        FileObject primary;
        block27: {
            primary = this.findPrimaryFileImpl(fo);
            if (primary == null) {
                return null;
            }
            willLog = ERR.isLoggable(Level.FINE);
            if (willLog) {
                ERR.fine(((Object)((Object)this)).getClass().getName() + " is accepting: " + fo);
            }
            if (primary != fo) {
                if (willLog) {
                    ERR.fine("checking correctness: primary is different than provided file: " + primary + " fo: " + fo);
                }
                Enumeration<DataLoader> en = DataLoaderPool.getDefault().allLoaders();
                while (true) {
                    DataObject snd;
                    MultiFileLoader ml;
                    DataLoader l;
                    if ((l = en.nextElement()) == this) {
                        ERR.fine("ok, consistent");
                        break block27;
                    }
                    if (!(l instanceof MultiFileLoader) || (ml = (MultiFileLoader)l).findPrimaryFile(primary) != primary) continue;
                    if (willLog) {
                        ERR.fine("loader seems to also take care of the file: " + (Object)((Object)ml));
                    }
                    try {
                        snd = ml.findDataObject(primary, recognized);
                    }
                    catch (DataObjectExistsException ex) {
                        snd = ex.getDataObject();
                    }
                    if (snd != null) break;
                }
                return null;
            }
        }
        try {
            obj = this.createMultiObject(primary);
            if (willLog) {
                ERR.fine(((Object)((Object)this)).getClass().getName() + " created object for: " + fo + " obj: " + obj);
            }
        }
        catch (DataObjectExistsException ex) {
            DataObject dataObject = ex.getDataObject();
            if (willLog) {
                ERR.fine(((Object)((Object)this)).getClass().getName() + " object already exists for: " + fo + " obj: " + dataObject);
            }
            if (dataObject.getLoader() != this) {
                if (willLog) {
                    ERR.fine(((Object)((Object)this)).getClass().getName() + " loader is wrong: " + ((Object)((Object)dataObject.getLoader())).getClass().getName());
                }
                if (dataObject.getLoader() instanceof MultiFileLoader) {
                    MultiFileLoader mfl = (MultiFileLoader)dataObject.getLoader();
                    FileObject loaderPrimary = mfl.findPrimaryFileImpl(fo);
                    ERR.log(Level.FINE, "Its primary file is {0}", loaderPrimary);
                    if (loaderPrimary != null && dataObject.getPrimaryFile() != loaderPrimary) {
                        ERR.log(Level.FINE, "Which is different than primary of found: {0}", dataObject);
                        Enumeration<DataLoader> before = DataLoaderPool.getDefault().allLoaders();
                        while (before.hasMoreElements()) {
                            DataLoader o = before.nextElement();
                            if (o == mfl) {
                                ERR.log(Level.FINE, "Returning null");
                                return null;
                            }
                            if (o != this) continue;
                            ERR.log(Level.FINE, "The loader" + (Object)((Object)mfl) + " is after " + (Object)((Object)this) + ". So do break.");
                            break;
                        }
                    }
                }
                dataObject = this.checkCollision(dataObject, fo);
            }
            if (!(dataObject instanceof MultiDataObject)) {
                if (willLog) {
                    ERR.fine(((Object)((Object)this)).getClass().getName() + " object is not MultiDataObject: " + dataObject);
                }
                throw ex;
            }
            obj = (MultiDataObject)dataObject;
        }
        catch (IOException ex) {
            ERR.log(Level.FINE, null, ex);
            throw ex;
        }
        if (obj.getLoader() != this) {
            if (willLog) {
                ERR.fine(((Object)((Object)this)).getClass().getName() + " wrong loader: " + ((Object)((Object)obj.getLoader())).getClass().getName());
            }
            return obj;
        }
        if (willLog) {
            ERR.fine(((Object)((Object)this)).getClass().getName() + " marking secondary entries");
        }
        obj.markSecondaryEntriesRecognized(recognized);
        if (willLog) {
            ERR.fine(((Object)((Object)this)).getClass().getName() + " register entry: " + fo);
        }
        MultiDataObject.Entry e = obj.registerEntry(fo);
        if (willLog) {
            ERR.fine(((Object)((Object)this)).getClass().getName() + " success: " + e);
        }
        return obj;
    }

    protected abstract FileObject findPrimaryFile(FileObject var1);

    protected abstract MultiDataObject createMultiObject(FileObject var1) throws DataObjectExistsException, IOException;

    protected abstract MultiDataObject.Entry createPrimaryEntry(MultiDataObject var1, FileObject var2);

    protected abstract MultiDataObject.Entry createSecondaryEntry(MultiDataObject var1, FileObject var2);

    DataObject checkCollision(DataObject obj, FileObject file) {
        FileObject primary = obj.getPrimaryFile();
        DataObjectPool.getPOOL().revalidate(new HashSet<FileObject>(Collections.singleton(primary)));
        DataObject result = DataObjectPool.getPOOL().find(primary);
        return result;
    }

    void checkConsistency(MultiDataObject obj) {
        FileObject primary = obj.getPrimaryFile();
        if (primary.equals(this.findPrimaryFileImpl(primary))) {
            return;
        }
        try {
            obj.setValid(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    void checkFiles(MultiDataObject obj) {
        FileObject primary = obj.getPrimaryFile();
        assert (primary != null) : "Object " + obj + " cannot have null primary file";
        FileObject parent = primary.getParent();
        assert (parent != null) : "Object " + obj + " cannot have null parent file";
        FileObject[] arr = parent.getChildren();
        for (int i = 0; i < arr.length; ++i) {
            FileObject pf = this.findPrimaryFileImpl(arr[i]);
            if (pf != primary) continue;
            try {
                DataObject.find(arr[i]);
                continue;
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
        }
    }

    MultiDataObject.Entry createSecondaryEntryImpl(MultiDataObject obj, FileObject secondaryFile) {
        return this.createSecondaryEntry(obj, secondaryFile);
    }

    FileObject findPrimaryFileImpl(FileObject fo) {
        return this.findPrimaryFile(fo);
    }
}

