/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.io.SafeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UniFileLoader
extends MultiFileLoader {
    static final long serialVersionUID = -6190649471408985837L;
    public static final String PROP_EXTENSIONS = "extensions";

    @Deprecated
    protected UniFileLoader(Class<? extends DataObject> representationClass) {
        super(representationClass);
    }

    protected UniFileLoader(String representationClassName) {
        super(representationClassName);
    }

    @Override
    protected FileObject findPrimaryFile(FileObject fo) {
        if (fo.isFolder()) {
            return null;
        }
        return this.getExtensions().isRegistered(fo) ? fo : null;
    }

    @Override
    protected abstract MultiDataObject createMultiObject(FileObject var1) throws DataObjectExistsException, IOException;

    @Override
    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        return new FileEntry(obj, primaryFile);
    }

    @Override
    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject obj, FileObject secondaryFile) {
        StringBuffer buf = new StringBuffer("Error in data system. Please reopen the bug #17014 with the following message: ");
        buf.append("\n  DataLoader:");
        buf.append(((Object)((Object)this)).getClass().getName());
        buf.append("\n  DataObject:");
        buf.append(obj);
        buf.append("\n  PrimaryEntry:");
        buf.append(obj.getPrimaryEntry());
        buf.append("\n  PrimaryFile:");
        buf.append(obj.getPrimaryFile());
        buf.append("\n  SecondaryFile:");
        buf.append(secondaryFile);
        buf.append("\n");
        throw new UnsupportedOperationException(buf.toString());
    }

    @Override
    final DataObject checkCollision(DataObject obj, FileObject file) {
        return null;
    }

    @Override
    final void checkConsistency(MultiDataObject obj) {
    }

    @Override
    final void checkFiles(MultiDataObject obj) {
    }

    public void setExtensions(ExtensionList ext) {
        this.putProperty(PROP_EXTENSIONS, ext, true);
    }

    public ExtensionList getExtensions() {
        ExtensionList l = (ExtensionList)this.getProperty(PROP_EXTENSIONS);
        if (l == null) {
            l = new ExtensionList();
            this.putProperty(PROP_EXTENSIONS, l, false);
        }
        return l;
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        super.writeExternal(oo);
        oo.writeObject(this.getProperty(PROP_EXTENSIONS));
    }

    @Override
    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        SafeException se;
        try {
            super.readExternal(oi);
            se = null;
        }
        catch (SafeException se2) {
            se = se2;
        }
        this.setExtensions((ExtensionList)oi.readObject());
        if (se != null) {
            throw se;
        }
    }
}

