/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DataFilesProviderImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectOperations {
    private ProjectOperations() {
    }

    public static List<FileObject> getMetadataFiles(Project prj) {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (DataFilesProviderImplementation i : prj.getLookup().lookupAll(DataFilesProviderImplementation.class)) {
            result.addAll(i.getMetadataFiles());
            assert (!result.contains(null)) : "Nulls in " + result + " from " + i;
        }
        return result;
    }

    public static List<FileObject> getDataFiles(Project prj) {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (DataFilesProviderImplementation i : prj.getLookup().lookupAll(DataFilesProviderImplementation.class)) {
            result.addAll(i.getDataFiles());
            assert (!result.contains(null)) : "Nulls in " + result + " from " + i;
        }
        return result;
    }

    public static boolean isDeleteOperationSupported(Project prj) {
        return prj.getLookup().lookup(DeleteOperationImplementation.class) != null;
    }

    public static void notifyDeleting(Project prj) throws IOException {
        for (DeleteOperationImplementation i : prj.getLookup().lookupAll(DeleteOperationImplementation.class)) {
            i.notifyDeleting();
        }
    }

    public static void notifyDeleted(Project prj) throws IOException {
        for (DeleteOperationImplementation i : prj.getLookup().lookupAll(DeleteOperationImplementation.class)) {
            i.notifyDeleted();
        }
    }

    public static boolean isCopyOperationSupported(Project prj) {
        return prj.getLookup().lookup(CopyOperationImplementation.class) != null;
    }

    public static void notifyCopying(Project prj) throws IOException {
        for (CopyOperationImplementation i : prj.getLookup().lookupAll(CopyOperationImplementation.class)) {
            i.notifyCopying();
        }
    }

    public static void notifyCopied(Project original, Project nue, File originalPath, String name) throws IOException {
        for (CopyOperationImplementation i : original.getLookup().lookupAll(CopyOperationImplementation.class)) {
            i.notifyCopied(null, originalPath, name);
        }
        for (CopyOperationImplementation i : nue.getLookup().lookupAll(CopyOperationImplementation.class)) {
            i.notifyCopied(original, originalPath, name);
        }
    }

    public static void notifyMoving(Project prj) throws IOException {
        for (MoveOperationImplementation i : prj.getLookup().lookupAll(MoveOperationImplementation.class)) {
            i.notifyMoving();
        }
    }

    public static void notifyMoved(Project original, Project nue, File originalPath, String name) throws IOException {
        for (MoveOperationImplementation i : original.getLookup().lookupAll(MoveOperationImplementation.class)) {
            i.notifyMoved(null, originalPath, name);
        }
        for (MoveOperationImplementation i : nue.getLookup().lookupAll(MoveOperationImplementation.class)) {
            i.notifyMoved(original, originalPath, name);
        }
    }

    public static boolean isMoveOperationSupported(Project prj) {
        return true;
    }
}

