/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.wizard;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.xml.core.lib.AbstractUtil;
import org.netbeans.modules.xml.core.wizard.SchemaParser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.ActionManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class Util
extends AbstractUtil {
    private static File lastDirectory;
    public static final Util THIS;
    public static final String NO_NAME_SPACE = "NO_NAME_SPACE";
    private static Map namespaces;
    private static Map prefixes;

    private Util() {
    }

    public static File selectSchemaFile(final String extensions) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                StringTokenizer token = new StringTokenizer(extensions, " ");
                while (token.hasMoreElements()) {
                    if (!f.getName().endsWith(token.nextToken())) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return THIS.getString("PROP_schema_mask");
            }
        });
        if (lastDirectory != null) {
            chooser.setCurrentDirectory(lastDirectory);
        }
        chooser.setDialogTitle(THIS.getString("PROP_schema_dialog_name"));
        while (chooser.showDialog(WindowManager.getDefault().getMainWindow(), THIS.getString("PROP_schema_select_button")) == 0) {
            File f = chooser.getSelectedFile();
            lastDirectory = chooser.getCurrentDirectory();
            if (f != null && f.isFile()) {
                StringTokenizer token = new StringTokenizer(extensions, " ");
                while (token.hasMoreElements()) {
                    if (!f.getName().endsWith(token.nextToken())) continue;
                    return f;
                }
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)THIS.getString("MSG_inValidFile"), 2));
        }
        return null;
    }

    public static String[] getKnownDTDPublicIDs() {
        UserCatalog catalog = UserCatalog.getDefault();
        if (catalog != null) {
            TreeSet<String> idSet = new TreeSet<String>();
            Iterator it = catalog.getPublicIDs();
            while (it.hasNext()) {
                String next = (String)it.next();
                String nextLowerCase = next.toLowerCase();
                if (nextLowerCase.startsWith("schema:") || nextLowerCase.endsWith(".xsd")) continue;
                idSet.add(next);
            }
            return idSet.toArray(new String[idSet.size()]);
        }
        THIS.debug("Note SourceResolver not found!");
        return new String[0];
    }

    public static void performDefaultAction(DataObject dataObject) {
        Node node = dataObject.getNodeDelegate();
        SystemAction action = node.getDefaultAction();
        if (action != null) {
            ActionManager manager = (ActionManager)Lookup.getDefault().lookup(ActionManager.class);
            manager.invokeAction((Action)action, new ActionEvent(node, 1001, ""));
        }
    }

    public static String getDocumentType() {
        return "xsd";
    }

    public static Map getFiles2NSMappingInProj(File rootFile, String docType) {
        List fileList = Util.getFilesWithExtension(rootFile, docType, new ArrayList());
        HashMap<FileObject, String> result = new HashMap<FileObject, String>();
        String xpathQuery = "//xsd:schema/@targetNamespace";
        for (int i = 0; i < fileList.size(); ++i) {
            File file = (File)fileList.get(i);
            if (Thread.currentThread().isInterrupted()) break;
            List targetNSList = null;
            try {
                targetNSList = Util.runXPathQuery(file, xpathQuery);
                String targetNS = null;
                FileObject fobj = FileUtil.toFileObject((File)file);
                targetNS = targetNSList.size() > 0 ? (String)targetNSList.get(0) : NO_NAME_SPACE;
                if (targetNS == NO_NAME_SPACE) continue;
                result.put(fobj, targetNS);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return result;
    }

    public static List getFilesWithExtension(File startFile, String fileExtension, List curList) {
        File[] children;
        String extn;
        int index;
        if (Thread.currentThread().isInterrupted()) {
            return curList;
        }
        if (curList == null) {
            curList = new ArrayList<File>();
        }
        if (startFile.isFile() && (index = startFile.getName().lastIndexOf(".")) != -1 && (extn = startFile.getName().substring(index + 1)) != null && extn.equalsIgnoreCase(fileExtension)) {
            curList.add(startFile);
        }
        if (startFile.isDirectory() && (children = startFile.listFiles()) != null) {
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                Util.getFilesWithExtension(child, fileExtension, curList);
            }
        }
        return curList;
    }

    public static List runXPathQuery(File parsedFile, String xpathExpr) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(Util.getNamespaceContext());
        InputSource inputSource = new InputSource(new FileInputStream(parsedFile));
        NodeList nodes = (NodeList)xpath.evaluate(xpathExpr, inputSource, XPathConstants.NODESET);
        if (nodes != null && nodes.getLength() > 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                org.w3c.dom.Node node = nodes.item(i);
                result.add(node.getNodeValue());
            }
        }
        return result;
    }

    public static String getNamespace(FileObject fobj) {
        SchemaParser parser = new SchemaParser();
        File file = FileUtil.toFile((FileObject)fobj);
        String systemId = file.getAbsolutePath();
        try {
            URL context = fobj.getURL();
            if (!context.toExternalForm().endsWith("/")) {
                context = new URL(context.toExternalForm() + "/");
            }
            if (context != null) {
                systemId = new URL(context, systemId).toExternalForm();
            }
        }
        catch (MalformedURLException ex) {
        }
        catch (FileStateInvalidException e) {
            // empty catch block
        }
        SchemaParser.SchemaInfo info = parser.parse(systemId);
        if (info == null) {
            return null;
        }
        return info.namespace;
    }

    public static SchemaParser.SchemaInfo getRootElements(FileObject fobj) {
        SchemaParser parser = new SchemaParser();
        File file = FileUtil.toFile((FileObject)fobj);
        String systemId = file.getAbsolutePath();
        try {
            URL context = fobj.getURL();
            if (!context.toExternalForm().endsWith("/")) {
                context = new URL(context.toExternalForm() + "/");
            }
            if (context != null) {
                systemId = new URL(context, systemId).toExternalForm();
            }
        }
        catch (MalformedURLException ex) {
        }
        catch (FileStateInvalidException e) {
            // empty catch block
        }
        SchemaParser.SchemaInfo info = parser.parse(systemId);
        if (info == null) {
            return null;
        }
        return info;
    }

    public static String getRelativePath(File file, File relativeTo) throws IOException {
        int i;
        File origFile = file;
        File origRelativeTo = relativeTo;
        ArrayList<File> filePathStack = new ArrayList<File>();
        ArrayList<File> relativeToPathStack = new ArrayList<File>();
        for (file = file.getCanonicalFile(); file != null; file = file.getParentFile()) {
            filePathStack.add(0, file);
        }
        for (relativeTo = relativeTo.getCanonicalFile(); relativeTo != null; relativeTo = relativeTo.getParentFile()) {
            relativeToPathStack.add(0, relativeTo);
        }
        int count = 0;
        file = (File)filePathStack.get(count);
        relativeTo = (File)relativeToPathStack.get(count);
        while (count < filePathStack.size() - 1 && count < relativeToPathStack.size() - 1 && file.equals(relativeTo)) {
            file = (File)filePathStack.get(++count);
            relativeTo = (File)relativeToPathStack.get(count);
        }
        if (file.equals(relativeTo)) {
            ++count;
        }
        StringBuffer relString = new StringBuffer();
        for (i = count; i < relativeToPathStack.size(); ++i) {
            relString.append(".." + File.separator);
        }
        for (i = count; i < filePathStack.size() - 1; ++i) {
            relString.append(((File)filePathStack.get(i)).getName() + File.separator);
        }
        relString.append(((File)filePathStack.get(filePathStack.size() - 1)).getName());
        return relString.toString();
    }

    private static NamespaceContext getNamespaceContext() {
        namespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
        prefixes.put("http://www.w3.org/2001/XMLSchema", "xsd");
        return new HashNamespaceResolver(namespaces, prefixes);
    }

    static {
        THIS = new Util();
        namespaces = new HashMap();
        prefixes = new HashMap();
    }

    public static final class HashNamespaceResolver
    implements NamespaceContext {
        private Map prefixes;
        private Map namespaces;

        public HashNamespaceResolver(Map nsTable) {
            this.namespaces = nsTable;
            this.prefixes = new HashMap();
            Set set = this.namespaces.entrySet();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                this.prefixes.put(e.getValue(), e.getKey());
            }
        }

        public HashNamespaceResolver(Map namespaces, Map prefixes) {
            this.namespaces = namespaces;
            this.prefixes = prefixes;
        }

        public Iterator getPrefixes(String namespaceURI) {
            return Collections.singletonList(this.getPrefix(namespaceURI)).iterator();
        }

        public String getPrefix(String namespaceURI) {
            return (String)this.prefixes.get(namespaceURI);
        }

        public String getNamespaceURI(String prefix) {
            return (String)this.namespaces.get(prefix);
        }
    }
}

