/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.fold;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldStateChange;
import org.netbeans.lib.editor.util.PriorityMutex;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.fold.ApiPackageAccessor;
import org.netbeans.modules.editor.fold.FoldHierarchyTransactionImpl;
import org.netbeans.modules.editor.fold.FoldManagerFactoryProvider;
import org.netbeans.modules.editor.fold.FoldOperationImpl;
import org.netbeans.modules.editor.fold.FoldUtilitiesImpl;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldManagerFactory;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.ErrorManager;

public final class FoldHierarchyExecution
implements DocumentListener {
    private static final String PROPERTY_FOLD_HIERARCHY_MUTEX = "foldHierarchyMutex";
    private static final String PROPERTY_FOLDING_ENABLED = "code-folding-enable";
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.fold");
    private static final boolean debugFire = Boolean.getBoolean("netbeans.debug.editor.fold.fire");
    private static final FoldOperationImpl[] EMPTY_FOLD_OPERTAION_IMPL_ARRAY = new FoldOperationImpl[0];
    private final JTextComponent component;
    private FoldHierarchy hierarchy;
    private Fold rootFold;
    private FoldOperationImpl[] operations = EMPTY_FOLD_OPERTAION_IMPL_ARRAY;
    private Map blocked2block = new HashMap(4);
    private Map block2blockedSet = new HashMap(4);
    private boolean inited;
    private AbstractDocument lastDocument;
    private PriorityMutex mutex;
    private EventListenerList listenerList;
    private boolean foldingEnabled;
    private FoldHierarchyTransactionImpl activeTransaction;
    private PropertyChangeListener componentChangesListener;

    public static synchronized FoldHierarchy getOrCreateFoldHierarchy(JTextComponent component) {
        if (component == null) {
            throw new NullPointerException("component cannot be null");
        }
        FoldHierarchyExecution execution = (FoldHierarchyExecution)component.getClientProperty(FoldHierarchyExecution.class);
        if (execution == null) {
            execution = new FoldHierarchyExecution(component);
            execution.init();
            component.putClientProperty(FoldHierarchyExecution.class, execution);
        }
        return execution.getHierarchy();
    }

    private FoldHierarchyExecution(JTextComponent component) {
        this.component = component;
    }

    private void init() {
        this.listenerList = new EventListenerList();
        this.mutex = (PriorityMutex)this.component.getClientProperty(PROPERTY_FOLD_HIERARCHY_MUTEX);
        if (this.mutex == null) {
            this.mutex = new PriorityMutex();
            this.component.putClientProperty(PROPERTY_FOLD_HIERARCHY_MUTEX, this.mutex);
        }
        this.hierarchy = ApiPackageAccessor.get().createFoldHierarchy(this);
        Document doc = this.component.getDocument();
        try {
            this.rootFold = ApiPackageAccessor.get().createFold(new FoldOperationImpl(this, null, Integer.MAX_VALUE), FoldHierarchy.ROOT_FOLD_TYPE, "root", false, doc, 0, doc.getEndPosition().getOffset(), 0, 0, null);
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        this.foldingEnabled = this.getFoldingEnabledSetting();
        this.startComponentChangesListening();
        this.rebuild();
    }

    public final FoldHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public final void lock() {
        this.mutex.lock();
    }

    public void unlock() {
        this.mutex.unlock();
    }

    public JTextComponent getComponent() {
        return this.component;
    }

    public Fold getRootFold() {
        return this.rootFold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFoldHierarchyListener(FoldHierarchyListener l) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            this.listenerList.add(FoldHierarchyListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFoldHierarchyListener(FoldHierarchyListener l) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            this.listenerList.remove(FoldHierarchyListener.class, l);
        }
    }

    void fireFoldHierarchyListener(FoldHierarchyEvent evt) {
        if (debugFire) {
            System.err.println("Firing FoldHierarchyEvent:\n" + evt);
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$netbeans$api$editor$fold$FoldHierarchyListener == null ? FoldHierarchyExecution.class$("org.netbeans.api.editor.fold.FoldHierarchyListener") : class$org$netbeans$api$editor$fold$FoldHierarchyListener)) continue;
            ((FoldHierarchyListener)listeners[i + 1]).foldHierarchyChanged(evt);
        }
    }

    public boolean add(Fold fold, FoldHierarchyTransactionImpl transaction) {
        if (fold.getParent() != null || this.isBlocked(fold)) {
            throw new IllegalStateException("Fold already added: " + fold);
        }
        boolean added = transaction.addFold(fold);
        return added;
    }

    public void remove(Fold fold, FoldHierarchyTransactionImpl transaction) {
        transaction.removeFold(fold);
    }

    public boolean isAddedOrBlocked(Fold fold) {
        return fold.getParent() != null || this.isBlocked(fold);
    }

    public boolean isBlocked(Fold fold) {
        return this.getBlock(fold) != null;
    }

    Fold getBlock(Fold fold) {
        return this.blocked2block.size() > 0 ? (Fold)this.blocked2block.get(fold) : null;
    }

    void markBlocked(Fold blocked, Fold block) {
        this.blocked2block.put(blocked, block);
        HashSet<Fold> blockedSet = (HashSet<Fold>)this.block2blockedSet.get(block);
        if (blockedSet == null) {
            blockedSet = new HashSet<Fold>();
            this.block2blockedSet.put(block, blockedSet);
        }
        if (!blockedSet.add(blocked)) {
            throw new IllegalStateException("fold " + blocked + " already blocked");
        }
    }

    Fold unmarkBlocked(Fold blocked) {
        Fold block = (Fold)this.blocked2block.remove(blocked);
        if (block == null) {
            throw new IllegalArgumentException("Not blocked: " + blocked);
        }
        Set blockedSet = (Set)this.block2blockedSet.get(block);
        if (!blockedSet.remove(blocked)) {
            throw new IllegalStateException("Not blocker for " + blocked);
        }
        if (blockedSet.size() == 0) {
            this.block2blockedSet.remove(block);
        }
        return block;
    }

    Set unmarkBlock(Fold block) {
        Set blockedSet = (Set)this.block2blockedSet.remove(block);
        if (blockedSet != null) {
            int size = this.blocked2block.size();
            this.blocked2block.keySet().removeAll(blockedSet);
            if (size - this.blocked2block.size() != blockedSet.size()) {
                throw new IllegalStateException("Not all removed: " + blockedSet);
            }
        }
        return blockedSet;
    }

    public void collapse(Collection c) {
        this.setCollapsed(c, true);
    }

    public void expand(Collection c) {
        this.setCollapsed(c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCollapsed(Collection c, boolean collapsed) {
        FoldHierarchyTransactionImpl transaction = this.openTransaction();
        try {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Fold fold = (Fold)it.next();
                transaction.setCollapsed(fold, collapsed);
            }
        }
        finally {
            transaction.commit();
        }
    }

    public FoldHierarchyTransactionImpl openTransaction() {
        if (this.activeTransaction != null) {
            throw new IllegalStateException("Active transaction already exists.");
        }
        this.activeTransaction = new FoldHierarchyTransactionImpl(this);
        return this.activeTransaction;
    }

    void clearActiveTransaction() {
        if (this.activeTransaction == null) {
            throw new IllegalStateException("No transaction in progress");
        }
        this.activeTransaction = null;
    }

    void createAndFireFoldHierarchyEvent(Fold[] removedFolds, Fold[] addedFolds, FoldStateChange[] foldStateChanges, int affectedStartOffset, int affectedEndOffset) {
        if (affectedStartOffset < 0) {
            throw new IllegalArgumentException("affectedStartOffset=" + affectedStartOffset + " < 0");
        }
        if (affectedEndOffset < affectedStartOffset) {
            throw new IllegalArgumentException("affectedEndOffset=" + affectedEndOffset + " < affectedStartOffset=" + affectedStartOffset);
        }
        FoldHierarchyEvent evt = ApiPackageAccessor.get().createFoldHierarchyEvent(this.hierarchy, removedFolds, addedFolds, foldStateChanges, affectedStartOffset, affectedEndOffset);
        this.fireFoldHierarchyListener(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild() {
        boolean releaseOnly;
        AbstractDocument adoc;
        Document doc;
        if (this.lastDocument != null) {
            DocumentUtilities.removeDocumentListener((Document)this.lastDocument, (DocumentListener)this, (DocumentListenerPriority)DocumentListenerPriority.FOLD_UPDATE);
            this.lastDocument = null;
        }
        if ((doc = this.getComponent().getDocument()) instanceof AbstractDocument) {
            adoc = (AbstractDocument)doc;
            releaseOnly = false;
        } else {
            adoc = null;
            releaseOnly = true;
        }
        if (!this.foldingEnabled) {
            releaseOnly = true;
        }
        if (adoc != null) {
            adoc.readLock();
            if (!releaseOnly) {
                this.lastDocument = adoc;
                DocumentUtilities.addDocumentListener((Document)this.lastDocument, (DocumentListener)this, (DocumentListenerPriority)DocumentListenerPriority.FOLD_UPDATE);
            }
        }
        try {
            this.lock();
            try {
                this.rebuildManagers(releaseOnly);
            }
            finally {
                this.unlock();
            }
        }
        finally {
            if (adoc != null) {
                adoc.readUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildManagers(boolean releaseOnly) {
        for (int i = 0; i < this.operations.length; ++i) {
            this.operations[i].release();
        }
        this.operations = EMPTY_FOLD_OPERTAION_IMPL_ARRAY;
        FoldManagerFactoryProvider provider = !releaseOnly ? FoldManagerFactoryProvider.getDefault() : FoldManagerFactoryProvider.getEmpty();
        List factoryList = provider.getFactoryList(this.getHierarchy());
        int factoryListLength = factoryList.size();
        if (debug) {
            System.err.println("FoldHierarchy rebuild(): FoldManager factory count=" + factoryListLength);
        }
        int priority = factoryListLength - 1;
        boolean ok = false;
        try {
            this.operations = new FoldOperationImpl[factoryListLength];
            for (int i = 0; i < factoryListLength; ++i) {
                FoldManagerFactory factory = (FoldManagerFactory)factoryList.get(i);
                FoldManager manager = factory.createFoldManager();
                this.operations[i] = new FoldOperationImpl(this, manager, priority);
                --priority;
            }
            ok = true;
        }
        finally {
            if (!ok) {
                this.operations = EMPTY_FOLD_OPERTAION_IMPL_ARRAY;
            }
        }
        FoldHierarchyTransactionImpl transaction = this.openTransaction();
        ok = false;
        try {
            Fold[] allBlocked = new Fold[this.blocked2block.size()];
            this.blocked2block.keySet().toArray(allBlocked);
            transaction.removeAllFolds(allBlocked);
            for (int i = 0; i < factoryListLength; ++i) {
                this.operations[i].initFolds(transaction);
            }
            ok = true;
        }
        finally {
            if (!ok) {
                this.operations = EMPTY_FOLD_OPERTAION_IMPL_ARRAY;
            }
            transaction.commit();
        }
    }

    private void startComponentChangesListening() {
        if (this.componentChangesListener == null) {
            this.componentChangesListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    String propName = evt.getPropertyName();
                    if ("document".equals(propName)) {
                        FoldHierarchyExecution.this.rebuild();
                    } else if (FoldHierarchyExecution.PROPERTY_FOLDING_ENABLED.equals(propName)) {
                        FoldHierarchyExecution.this.foldingEnabledSettingChange();
                    }
                }
            };
            this.getComponent().addPropertyChangeListener(this.componentChangesListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertUpdate(DocumentEvent evt) {
        this.lock();
        try {
            FoldHierarchyTransactionImpl transaction = this.openTransaction();
            try {
                transaction.insertUpdate(evt);
                int operationsLength = this.operations.length;
                for (int i = 0; i < operationsLength; ++i) {
                    this.operations[i].insertUpdate(evt, transaction);
                }
            }
            finally {
                transaction.commit();
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdate(DocumentEvent evt) {
        this.lock();
        try {
            FoldHierarchyTransactionImpl transaction = this.openTransaction();
            try {
                transaction.removeUpdate(evt);
                int operationsLength = this.operations.length;
                for (int i = 0; i < operationsLength; ++i) {
                    this.operations[i].removeUpdate(evt, transaction);
                }
            }
            finally {
                transaction.commit();
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changedUpdate(DocumentEvent evt) {
        this.lock();
        try {
            FoldHierarchyTransactionImpl transaction = this.openTransaction();
            try {
                transaction.changedUpdate(evt);
                int operationsLength = this.operations.length;
                for (int i = 0; i < operationsLength; ++i) {
                    this.operations[i].changedUpdate(evt, transaction);
                }
            }
            finally {
                transaction.commit();
            }
        }
        finally {
            this.unlock();
        }
    }

    private boolean getFoldingEnabledSetting() {
        Boolean b = (Boolean)this.component.getClientProperty(PROPERTY_FOLDING_ENABLED);
        return b != null ? b : true;
    }

    public void foldingEnabledSettingChange() {
        boolean origFoldingEnabled = this.foldingEnabled;
        this.foldingEnabled = this.getFoldingEnabledSetting();
        if (origFoldingEnabled != this.foldingEnabled) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FoldHierarchyExecution.this.rebuild();
                }
            });
        }
    }

    public void checkConsistency() {
        try {
            FoldHierarchyExecution.checkFoldConsistency(this.getRootFold());
        }
        catch (RuntimeException e) {
            System.err.println("FOLD HIERARCHY INCONSISTENCY FOUND\n" + this);
            throw e;
        }
    }

    private static void checkFoldConsistency(Fold fold) {
        int startOffset = fold.getStartOffset();
        int endOffset = fold.getEndOffset();
        int lastEndOffset = startOffset;
        for (int i = 0; i < fold.getFoldCount(); ++i) {
            Fold child = fold.getFold(i);
            if (child.getParent() != fold) {
                throw new IllegalStateException("Wrong parent of child=" + child + ": " + child.getParent() + " != " + fold);
            }
            int foldIndex = fold.getFoldIndex(child);
            if (foldIndex != i) {
                throw new IllegalStateException("Fold index " + foldIndex + " instead of " + i);
            }
            int childStartOffset = child.getStartOffset();
            int childEndOffset = child.getEndOffset();
            if (childStartOffset < lastEndOffset) {
                throw new IllegalStateException("childStartOffset=" + childStartOffset + " < lastEndOffset=" + lastEndOffset);
            }
            if (childStartOffset > childEndOffset) {
                throw new IllegalStateException("childStartOffset=" + childStartOffset + " > childEndOffset=" + childEndOffset);
            }
            lastEndOffset = childEndOffset;
            FoldHierarchyExecution.checkFoldConsistency(child);
        }
    }

    public String toString() {
        int operationsLength;
        Map.Entry entry;
        Iterator it;
        StringBuffer sb = new StringBuffer();
        sb.append("component=");
        sb.append(System.identityHashCode(this.getComponent()));
        sb.append('\n');
        sb.append(FoldUtilitiesImpl.foldToStringChildren(this.hierarchy.getRootFold(), 0));
        sb.append('\n');
        if (this.blocked2block != null) {
            sb.append("BLOCKED\n");
            it = this.blocked2block.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                sb.append("    ");
                sb.append(entry.getKey());
                sb.append(" blocked-by ");
                sb.append(entry.getValue());
                sb.append('\n');
            }
        }
        if (this.block2blockedSet != null) {
            sb.append("BLOCKERS\n");
            it = this.block2blockedSet.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                sb.append("    ");
                sb.append(entry.getKey());
                sb.append('\n');
                Set blockedSet = (Set)entry.getValue();
                Iterator it2 = blockedSet.iterator();
                while (it2.hasNext()) {
                    sb.append("        blocks ");
                    sb.append(it2.next());
                    sb.append('\n');
                }
            }
        }
        if ((operationsLength = this.operations.length) > 0) {
            sb.append("Fold Managers\n");
            for (int i = 0; i < operationsLength; ++i) {
                sb.append("FOLD MANAGER [");
                sb.append(i);
                sb.append("]:\n");
                sb.append(this.operations[i].getManager());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    static {
        FoldOperation.isBoundsValid(0, 0, 0, 0);
    }
}

