/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.netbeans.api.languages.ASTPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTItem {
    private String mimeType;
    private int offset;
    private int length = -1;
    private List<ASTItem> children;
    private ASTPath path;
    private TreeMap<Integer, ASTItem> childrenMap = null;

    ASTItem(String mimeType, int offset, int length, List<? extends ASTItem> children) {
        this.mimeType = mimeType;
        this.offset = offset;
        this.length = length;
        this.children = new ArrayList<ASTItem>();
        if (children != null) {
            for (ASTItem aSTItem : children) {
                if (aSTItem == null) {
                    throw new NullPointerException();
                }
                this.children.add(aSTItem);
            }
        }
        this.children = Collections.unmodifiableList(this.children);
    }

    public int getOffset() {
        return this.offset;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public List<ASTItem> getChildren() {
        return this.children;
    }

    public int getEndOffset() {
        return this.getOffset() + this.getLength();
    }

    public int getLength() {
        if (this.length < 0) {
            List<ASTItem> l = this.getChildren();
            if (l.isEmpty()) {
                this.length = 0;
            } else {
                ASTItem last = l.get(l.size() - 1);
                this.length = last.getEndOffset() - this.getOffset();
            }
        }
        return this.length;
    }

    public ASTPath findPath(int offset) {
        return this.findPath(new ArrayList<ASTItem>(), offset);
    }

    private ASTPath findPath(List<ASTItem> path, int offset) {
        if (offset < this.getOffset()) {
            return ASTPath.create(path);
        }
        if (offset > this.getEndOffset()) {
            return ASTPath.create(path);
        }
        path.add(this);
        if (this.getChildren().isEmpty()) {
            return ASTPath.create(path);
        }
        if (this.getChildren().size() > 10) {
            return this.findPath2(path, offset);
        }
        for (ASTItem item : this.getChildren()) {
            if (offset >= item.getEndOffset() || item.getOffset() > offset) continue;
            return item.findPath(path, offset);
        }
        return ASTPath.create(path);
    }

    private ASTPath findPath2(List<ASTItem> path, int offset) {
        TreeMap<Integer, ASTItem> childrenMap = this.getChildrenMap();
        SortedMap<Integer, ASTItem> headMap = childrenMap.headMap(new Integer(offset + 1));
        if (headMap.isEmpty()) {
            return ASTPath.create(path);
        }
        Integer key = headMap.lastKey();
        ASTItem item = childrenMap.get(key);
        ASTPath path2 = item.findPath(path, offset);
        if (path2 == null) {
            return ASTPath.create(path);
        }
        return path2;
    }

    private TreeMap<Integer, ASTItem> getChildrenMap() {
        if (this.childrenMap == null) {
            this.childrenMap = new TreeMap();
            for (ASTItem item : this.getChildren()) {
                this.childrenMap.put(new Integer(item.getOffset()), item);
            }
        }
        return this.childrenMap;
    }
}

