/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.Context;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;

public abstract class SyntaxContext
extends Context {
    public abstract ASTPath getASTPath();

    public static SyntaxContext create(Document doc, ASTPath path) {
        return new CookieImpl(doc, path);
    }

    private static class CookieImpl
    extends SyntaxContext {
        private Document doc;
        private ASTPath path;
        private JTextComponent component;
        private TokenSequence tokenSequence;

        CookieImpl(Document doc, ASTPath path) {
            this.doc = doc;
            this.path = path;
        }

        public JTextComponent getJTextComponent() {
            DataObject dob;
            EditorCookie ec;
            if (this.component == null && (ec = (EditorCookie)(dob = NbEditorUtilities.getDataObject((Document)this.doc)).getLookup().lookup(EditorCookie.class)).getOpenedPanes().length > 0) {
                this.component = ec.getOpenedPanes()[0];
            }
            return this.component;
        }

        public ASTPath getASTPath() {
            return this.path;
        }

        public Document getDocument() {
            return this.doc;
        }

        public TokenSequence getTokenSequence() {
            ASTItem leaf;
            if (this.tokenSequence == null) {
                TokenHierarchy th = TokenHierarchy.get((Document)this.doc);
                this.tokenSequence = th.tokenSequence();
            }
            if ((leaf = this.path.getLeaf()) instanceof ASTToken) {
                this.tokenSequence.move(((ASTToken)leaf).getOffset());
            } else {
                this.tokenSequence.move(((ASTNode)leaf).getOffset());
            }
            this.tokenSequence.moveNext();
            return this.tokenSequence;
        }
    }
}

