/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.ParserManagerListener;
import org.netbeans.editor.Registry;

public class EditorParser
extends ParserManager
implements DocumentListener {
    private static Map<Document, WeakReference<EditorParser>> managers = new WeakHashMap<Document, WeakReference<EditorParser>>();
    private Document document;
    private ParserManager parserManager;
    private List<ParserManagerListener> listeners = new ArrayList<ParserManagerListener>();
    private List<ASTEvaluator> evaluators = new CopyOnWriteArrayList<ASTEvaluator>();
    private MyParserListener parserListener;
    private MyChangeListener editorListener;
    private ParserManager.State lastState = ParserManager.State.NOT_PARSED;

    public static synchronized EditorParser get(Document doc) {
        EditorParser pm;
        WeakReference<EditorParser> wr = managers.get(doc);
        EditorParser editorParser = pm = wr != null ? (EditorParser)wr.get() : null;
        if (pm == null) {
            pm = new EditorParser(doc);
            managers.put(doc, new WeakReference<EditorParser>(pm));
        }
        return pm;
    }

    EditorParser(Document document) {
        this.document = document;
        this.setDocument((Document)Registry.getMostActiveDocument());
        this.editorListener = new MyChangeListener();
        Registry.addChangeListener((ChangeListener)this.editorListener);
        document.addDocumentListener(this);
    }

    public ParserManager.State getState() {
        if (this.parserManager != null) {
            return this.parserManager.getState();
        }
        return this.lastState;
    }

    public ASTNode getAST() throws ParseException {
        if (this.parserManager != null) {
            return this.parserManager.getAST();
        }
        return null;
    }

    public void addListener(ParserManagerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ParserManagerListener l) {
        this.listeners.remove(l);
    }

    public void addASTEvaluator(ASTEvaluator e) {
        this.evaluators.add(e);
    }

    public void removeASTEvaluator(ASTEvaluator e) {
        this.evaluators.remove(e);
    }

    private void setDocument(Document document) {
        if (this.document == document) {
            if (this.parserManager != null) {
                return;
            }
            this.parserManager = ParserManager.get(document);
            this.parserListener = new MyParserListener();
            this.parserManager.addListener(this.parserListener);
            this.parserManager.addASTEvaluator(this.parserListener);
            if (this.getState() == ParserManager.State.PARSING) {
                this.parserListener.parsed(ParserManager.State.PARSING, null);
            }
        } else {
            if (this.parserManager == null) {
                return;
            }
            this.parserManager.removeASTEvaluator(this.parserListener);
            this.parserManager.removeListener(this.parserListener);
            this.parserListener = null;
            this.parserManager = null;
        }
    }

    public void insertUpdate(DocumentEvent e) {
    }

    public void removeUpdate(DocumentEvent e) {
    }

    public void changedUpdate(DocumentEvent e) {
    }

    private class MyChangeListener
    implements ChangeListener {
        private MyChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            EditorParser.this.setDocument((Document)Registry.getMostActiveDocument());
        }
    }

    class MyParserListener
    extends ASTEvaluator
    implements ParserManagerListener {
        MyParserListener() {
        }

        public void beforeEvaluation(ParserManager.State state, ASTNode root) {
            if (!EditorParser.this.evaluators.isEmpty()) {
                for (ASTEvaluator e : EditorParser.this.evaluators) {
                    e.beforeEvaluation(state, root);
                }
            }
        }

        public void afterEvaluation(ParserManager.State state, ASTNode root) {
            if (!EditorParser.this.evaluators.isEmpty()) {
                for (ASTEvaluator e : EditorParser.this.evaluators) {
                    e.afterEvaluation(state, root);
                }
            }
        }

        public void evaluate(ParserManager.State state, ASTPath path) {
            if (!EditorParser.this.evaluators.isEmpty()) {
                for (ASTEvaluator e : EditorParser.this.evaluators) {
                    e.evaluate(state, path);
                }
            }
        }

        public void parsed(ParserManager.State state, ASTNode root) {
            EditorParser.this.lastState = state;
            if (!EditorParser.this.listeners.isEmpty()) {
                for (ParserManagerListener l : new ArrayList(EditorParser.this.listeners)) {
                    l.parsed(state, root);
                }
            }
        }
    }
}

