/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.languages.TokenInput;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.Utils;
import org.netbeans.modules.languages.parser.LLSyntaxAnalyser;
import org.netbeans.modules.languages.parser.Parser;
import org.netbeans.modules.languages.parser.Pattern;
import org.netbeans.modules.languages.parser.Petra;
import org.netbeans.modules.languages.parser.StringInput;
import org.netbeans.modules.languages.parser.TokenInputUtils;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Language
extends org.netbeans.api.languages.Language {
    public static final String ACTION = "ACTION";
    public static final String AST = "AST";
    public static final String BRACE = "BRACE";
    public static final String BUNDLE = "BUNDLE";
    public static final String COLOR = "COLOR";
    public static final String COMPLETE = "COMPLETE";
    public static final String COMPLETION = "COMPLETION";
    public static final String FOLD = "FOLD";
    public static final String HYPERLINK = "HYPERLINK";
    public static final String IMPORT = "IMPORT";
    public static final String INDENT = "INDENT";
    public static final String MARK = "MARK";
    public static final String NAVIGATOR = "NAVIGATOR";
    public static final String PARSE = "PARSE";
    public static final String PROPERTIES = "PROPERTIES";
    public static final String REFORMAT = "REFORMAT";
    public static final String SKIP = "SKIP";
    public static final String STORE = "STORE";
    public static final String TOKEN = "TOKEN";
    public static final String TOOLTIP = "TOOLTIP";
    private Parser parser;
    private List<TokenType> tokenTypes = new ArrayList<TokenType>();
    private Set<String> skipTokenTypes;
    private String mimeType;
    private ParseException analyserException;
    private LLSyntaxAnalyser analyser;
    private List<ASTNode> grammarASTNodes = new ArrayList<ASTNode>();
    private List<LLSyntaxAnalyser.Rule> grammarRules;
    private List<Language> importedLangauges = new ArrayList<Language>();
    private boolean bundleResolved = false;
    private ResourceBundle bundle;
    private Feature preprocessorImport;
    private Map<String, Feature> tokenImports = new HashMap<String, Feature>();
    private Map<String, List<Feature>> featureLists = new HashMap<String, List<Feature>>();
    private Map<String, Object> featuresMap = new HashMap<String, Object>();
    private static final Object BLA = new Object();

    public Language(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Parser getParser() {
        if (this.parser == null) {
            this.parser = Parser.create(this.tokenTypes);
        }
        return this.parser;
    }

    public List<TokenType> getTokenTypes() {
        return Collections.unmodifiableList(this.tokenTypes);
    }

    public Set<String> getSkipTokenTypes() {
        if (this.skipTokenTypes == null) {
            this.skipTokenTypes = new HashSet<String>();
            List<Feature> ss = this.getFeatures(SKIP);
            for (Feature s : ss) {
                this.skipTokenTypes.add(s.getSelector().getAsString());
            }
        }
        return this.skipTokenTypes;
    }

    public boolean hasAnalyser() {
        return !this.grammarASTNodes.isEmpty();
    }

    public LLSyntaxAnalyser getAnalyser() throws ParseException {
        if (this.analyserException != null) {
            throw this.analyserException;
        }
        if (this.analyser != null) {
            return this.analyser;
        }
        Language language = this;
        synchronized (language) {
            if (this.analyserException != null) {
                throw this.analyserException;
            }
            if (this.analyser != null) {
                return this.analyser;
            }
            try {
                this.analyser = LLSyntaxAnalyser.create(this);
                return this.analyser;
            }
            catch (ParseException ex) {
                this.analyserException = ex;
                throw ex;
            }
        }
    }

    public List<Language> getImportedLanguages() {
        return this.importedLangauges;
    }

    public static TokenType createTokenType(String startState, Pattern pattern, String type, String endState, int priority, Feature properties) {
        return new TokenType(startState, pattern, type, endState, priority, properties);
    }

    public String localize(String str) {
        if (!this.bundleResolved) {
            String clsName;
            Feature bundleFeature = this.getFeature(BUNDLE);
            if (bundleFeature != null && (clsName = (String)bundleFeature.getValue()) != null) {
                ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                Class<?> clazz = null;
                try {
                    clazz = cl.loadClass(clsName);
                }
                catch (ClassNotFoundException ex) {
                    Utils.notify(ex);
                }
                if (clazz != null) {
                    this.bundle = NbBundle.getBundle(clazz);
                }
            }
            this.bundleResolved = true;
        }
        if (str == null) {
            return null;
        }
        if (this.bundle != null) {
            try {
                return this.bundle.getString(str);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return str;
    }

    public void addToken(String startState, String type, Pattern pattern, String endState, Feature properties) {
        if (this.parser != null) {
            throw new InternalError();
        }
        this.tokenTypes.add(Language.createTokenType(startState, pattern, type, endState, this.tokenTypes.size(), properties));
    }

    void addRule(ASTNode rule) {
        if (this.analyser != null) {
            throw new InternalError();
        }
        this.grammarASTNodes.add(rule);
    }

    public void addRule(LLSyntaxAnalyser.Rule rule) {
        if (this.grammarRules == null) {
            this.grammarRules = new ArrayList<LLSyntaxAnalyser.Rule>();
        }
        this.grammarRules.add(rule);
    }

    public List<LLSyntaxAnalyser.Rule> getRules() {
        if (this.grammarRules == null) {
            this.grammarRules = Petra.convert(this.grammarASTNodes, this.getMimeType());
        }
        return this.grammarRules;
    }

    public Feature getPreprocessorImport() {
        return this.preprocessorImport;
    }

    public Map<String, Feature> getTokenImports() {
        return this.tokenImports;
    }

    void importLanguage(Feature feature) {
        try {
            String mimeType = (String)feature.getValue("mimeType");
            Language language = LanguagesManager.getDefault().getLanguage(mimeType);
            if (feature.getPattern("start") != null) {
                assert (this.preprocessorImport == null);
                this.preprocessorImport = feature;
                this.importedLangauges.add(language);
                return;
            }
            if (feature.getValue("state") == null) {
                String tokenName = feature.getSelector().getAsString();
                assert (!this.tokenImports.containsKey(tokenName));
                this.tokenImports.put(tokenName, feature);
                this.importedLangauges.add(language);
                return;
            }
            String state = (String)feature.getValue("state");
            String tokenName = feature.getSelector().getAsString();
            for (TokenType tt : language.getTokenTypes()) {
                String startState = tt.getStartState();
                Pattern pattern = tt.getPattern().clonePattern();
                String endState = tt.getEndState();
                startState = startState == null || "DEFAULT".equals(startState) ? state : tokenName + '-' + startState;
                endState = endState == null || "DEFAULT".equals(endState) ? state : tokenName + '-' + endState;
                this.addToken(startState, tt.getType(), pattern, endState, tt.getProperties());
            }
            this.grammarASTNodes.addAll(language.grammarASTNodes);
            this.importAllFeatures(language);
            this.importedLangauges.addAll(language.importedLangauges);
            this.tokenImports.putAll(language.tokenImports);
        }
        catch (LanguageDefinitionNotFoundException ex) {
            Utils.notify("Editors/" + this.mimeType + "/language.nbs:", ex);
        }
    }

    private void importAllFeatures(Language l) {
        for (String featureName : l.featureLists.keySet()) {
            List<Feature> features = l.getFeatures(featureName);
            for (Feature f : features) {
                this.addFeature(f);
            }
        }
    }

    public void addFeature(Feature feature) {
        ArrayList<Object> l;
        String featureName = feature.getFeatureName();
        if (featureName.equals(IMPORT)) {
            this.importLanguage(feature);
            return;
        }
        List<Feature> list = this.featureLists.get(featureName);
        if (list == null) {
            list = new ArrayList<Feature>();
            this.featureLists.put(featureName, list);
        }
        list.add(feature);
        if (feature.getSelector() == null) {
            Object o = this.featuresMap.get(featureName);
            if (o == null) {
                this.featuresMap.put(featureName, feature);
            } else if (o instanceof List) {
                ((List)o).add(feature);
            } else {
                ArrayList<Feature> l2 = new ArrayList<Feature>();
                l2.add((Feature)o);
                l2.add(feature);
                this.featuresMap.put(featureName, l2);
            }
            return;
        }
        Map<Object, Feature> m = (HashMap)this.featuresMap.get(featureName);
        if (m == null) {
            m = new HashMap();
            this.featuresMap.put(featureName, m);
        }
        List<String> path = feature.getSelector().getPath();
        for (int i = path.size() - 1; i > 0; --i) {
            String name = path.get(i);
            Object o = m.get(name);
            if (o instanceof Map) {
                m = (Map)o;
                continue;
            }
            HashMap mm = new HashMap();
            if (o != null) {
                mm.put(BLA, o);
            }
            m.put(name, (Feature)((Object)mm));
            m = mm;
        }
        String name = path.get(0);
        Object o = m.get(name);
        if (o instanceof List) {
            ((List)o).add(feature);
        } else if (o instanceof Map) {
            m = (Map)o;
            if ((o = m.get(BLA)) instanceof List) {
                ((List)o).add(feature);
            } else if (o == null) {
                m.put(BLA, feature);
            } else {
                l = new ArrayList();
                l.add(o);
                l.add(feature);
                m.put(BLA, (Feature)((Object)l));
            }
        } else if (o == null) {
            m.put(name, feature);
        } else {
            l = new ArrayList<Object>();
            l.add(o);
            l.add(feature);
            m.put(name, (Feature)((Object)l));
        }
    }

    public List<Feature> getFeatures(String featureName) {
        List<Feature> r = this.featureLists.get(featureName);
        if (r != null) {
            return r;
        }
        return Collections.emptyList();
    }

    public Feature getFeature(String featureName) {
        List<Feature> r = this.featureLists.get(featureName);
        if (r == null) {
            return null;
        }
        if (r.size() == 1) {
            return r.get(0);
        }
        throw new IllegalArgumentException();
    }

    public Feature getFeature(String featureName, ASTPath path) {
        List<Feature> r = this.getFeatures(featureName, path);
        if (r.isEmpty()) {
            return null;
        }
        if (r.size() == 1) {
            return r.get(0);
        }
        throw new IllegalArgumentException();
    }

    public Feature getFeature(String featureName, String id) {
        Map m = (Map)this.featuresMap.get(featureName);
        if (m == null) {
            return null;
        }
        Object o = m.get(id);
        if (o instanceof Map) {
            o = ((Map)o).get(BLA);
        }
        if (o == null) {
            return null;
        }
        if (o instanceof Feature) {
            return (Feature)o;
        }
        List r = (List)o;
        if (r.isEmpty()) {
            return null;
        }
        if (r.size() == 1) {
            return (Feature)r.get(0);
        }
        throw new IllegalArgumentException();
    }

    public List<Feature> getFeatures(String featureName, ASTPath path) {
        Map m = (Map)this.featuresMap.get(featureName);
        if (m == null) {
            return Collections.emptyList();
        }
        Object last = null;
        for (int i = path.size() - 1; i > 0; --i) {
            ASTItem item = path.get(i);
            String name = item instanceof ASTToken ? ((ASTToken)item).getType() : ((ASTNode)item).getNT();
            Object o = m.get(name);
            if (m.containsKey(BLA)) {
                last = m.get(BLA);
            }
            if (!(o instanceof Map)) {
                if (o instanceof List) {
                    return (List)o;
                }
                if (o != null) {
                    return Collections.singletonList((Feature)o);
                }
                if (last == null) break;
                if (last instanceof List) {
                    return last;
                }
                return Collections.singletonList(last);
            }
            m = (Map)o;
        }
        return Collections.emptyList();
    }

    @Override
    public ASTNode parse(InputStream is) throws IOException, ParseException {
        ASTNode root1;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String ln = br.readLine();
        while (ln != null) {
            sb.append(ln).append('\n');
            ln = br.readLine();
        }
        TokenInput ti = TokenInputUtils.create(this.getMimeType(), this.getParser(), new StringInput(sb.toString()), this.getSkipTokenTypes());
        ASTNode root = this.getAnalyser().read(ti, true);
        Feature astProperties = this.getFeature(AST);
        if (astProperties != null && root != null && (root1 = (ASTNode)astProperties.getValue("process", SyntaxContext.create(null, ASTPath.create(root)))) != null) {
            root = root1;
        }
        return root;
    }

    void print() throws ParseException {
        System.out.println("\nPrint " + this.mimeType);
        System.out.println("Tokens:");
        Iterator<TokenType> it = this.getTokenTypes().iterator();
        while (it.hasNext()) {
            TokenType r = it.next();
            System.out.println("  " + r);
        }
        System.out.println("Grammar Rules:");
        Iterator<LLSyntaxAnalyser.Rule> it2 = this.getAnalyser().getRules().iterator();
        while (it.hasNext()) {
            LLSyntaxAnalyser.Rule r = it2.next();
            System.out.println("  " + r);
        }
    }

    public String toString() {
        return "Language " + this.mimeType;
    }

    public static final class TokenType {
        private String startState;
        private Pattern pattern;
        private String type;
        private String endState;
        private int priority;
        private Feature properties;

        private TokenType(String startState, Pattern pattern, String type, String endState, int priority, Feature properties) {
            this.startState = startState == null ? "DEFAULT" : startState;
            this.pattern = pattern;
            this.type = type;
            this.endState = endState == null ? "DEFAULT" : endState;
            this.priority = priority;
            this.properties = properties;
        }

        public String getType() {
            return this.type;
        }

        public String getStartState() {
            return this.startState;
        }

        public String getEndState() {
            return this.endState;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public int getPriority() {
            return this.priority;
        }

        public Feature getProperties() {
            return this.properties;
        }

        public String toString() {
            return "Rule " + this.startState + " : type " + this.type + " : " + this.endState;
        }
    }
}

