/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.ParserManagerListener;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.languages.TokenInput;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.lexer.SLanguageHierarchy;
import org.netbeans.modules.languages.parser.LLSyntaxAnalyser;
import org.netbeans.modules.languages.parser.TokenInputUtils;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserManagerImpl
extends ParserManager {
    private Document doc;
    private TokenHierarchy tokenHierarchy;
    private ASTNode ast = null;
    private ParseException exception = null;
    private ParserManager.State state = ParserManager.State.NOT_PARSED;
    private List<ParserManagerListener> listeners = new ArrayList<ParserManagerListener>();
    private List<ASTEvaluator> evaluators = new CopyOnWriteArrayList<ASTEvaluator>();
    private static RequestProcessor rp = new RequestProcessor("Parser");
    private RequestProcessor.Task parsingTask;

    public ParserManagerImpl(Document doc) {
        this.doc = doc;
        this.tokenHierarchy = TokenHierarchy.get((Document)doc);
        String mimeType = (String)doc.getProperty("mimeType");
        if (this.tokenHierarchy == null && mimeType != null) {
            doc.putProperty(org.netbeans.api.lexer.Language.class, new SLanguageHierarchy(mimeType).language());
            this.tokenHierarchy = TokenHierarchy.get((Document)doc);
        }
        new DocListener(this, this.tokenHierarchy);
        if (this.state == ParserManager.State.NOT_PARSED) {
            try {
                LanguagesManager.getDefault().getLanguage(mimeType);
                this.startParsing();
            }
            catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public ParserManager.State getState() {
        return this.state;
    }

    @Override
    public ASTNode getAST() throws ParseException {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.ast;
    }

    @Override
    public void addListener(ParserManagerListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(ParserManagerListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void addASTEvaluator(ASTEvaluator e) {
        this.evaluators.add(e);
    }

    @Override
    public void removeASTEvaluator(ASTEvaluator e) {
        this.evaluators.remove(e);
    }

    public synchronized void forceEvaluation(ASTEvaluator e) {
        if (this.state != ParserManager.State.ERROR && this.state != ParserManager.State.OK) {
            return;
        }
        e.beforeEvaluation(this.state, this.ast);
        this.evaluate(this.state, this.ast, this.ast, new ArrayList<ASTItem>());
        e.afterEvaluation(this.state, this.ast);
    }

    private synchronized void startParsing() {
        this.setChange(ParserManager.State.PARSING, this.ast);
        if (this.parsingTask != null) {
            String mimeType = (String)this.doc.getProperty("mimeType");
            try {
                Language l = this.getLanguage(mimeType);
                LLSyntaxAnalyser a = l.getAnalyser();
                a.cancel();
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
            this.parsingTask.cancel();
        }
        this.parsingTask = rp.post(new Runnable(){

            public void run() {
                ParserManagerImpl.this.parseAST();
            }
        }, 1000);
    }

    private void setChange(ParserManager.State state, ASTNode root) {
        if (state == this.state) {
            return;
        }
        this.state = state;
        this.ast = root;
        this.exception = null;
        for (ParserManagerListener l : new ArrayList<ParserManagerListener>(this.listeners)) {
            l.parsed(state, root);
        }
        if (state == ParserManager.State.PARSING) {
            return;
        }
        if (!this.evaluators.isEmpty()) {
            for (ASTEvaluator e : this.evaluators) {
                e.beforeEvaluation(state, root);
            }
            this.evaluate(state, root, root, new ArrayList<ASTItem>());
            for (ASTEvaluator e : this.evaluators) {
                e.afterEvaluation(state, root);
            }
        }
        this.refreshPanes();
    }

    private void evaluate(ParserManager.State state, ASTItem root, ASTItem item, List<ASTItem> path) {
        path.add(item);
        ASTPath path2 = ASTPath.create(path);
        for (ASTEvaluator e : this.evaluators) {
            e.evaluate(state, path2);
        }
        Iterator<ASTItem> it2 = item.getChildren().iterator();
        while (it2.hasNext()) {
            this.evaluate(state, root, it2.next(), path);
        }
        path.remove(path.size() - 1);
    }

    private void setChange(ParseException ex) {
        this.state = ParserManager.State.ERROR;
        this.ast = null;
        this.exception = ex;
        for (ParserManagerListener l : new ArrayList<ParserManagerListener>(this.listeners)) {
            l.parsed(this.state, this.ast);
        }
        if (this.state == ParserManager.State.PARSING) {
            return;
        }
        this.refreshPanes();
    }

    private void refreshPanes() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
                    JEditorPane[] eps;
                    EditorCookie ec = (EditorCookie)tc.getLookup().lookup(EditorCookie.class);
                    if (ec == null || (eps = ec.getOpenedPanes()) == null) continue;
                    int k = eps.length;
                    for (int i = 0; i < k; ++i) {
                        if (eps[i].getDocument() != ParserManagerImpl.this.doc) continue;
                        eps[i].repaint();
                    }
                }
            }
        });
    }

    private void parseAST() {
        try {
            this.setChange(ParserManager.State.PARSING, this.ast);
            this.ast = this.parse();
            if (this.ast == null) {
                this.setChange(new ParseException("ast is null?!"));
                return;
            }
            this.ast = this.process(this.ast);
            if (this.ast == null) {
                this.setChange(new ParseException("ast is null?!"));
                return;
            }
            this.setChange(ParserManager.State.OK, this.ast);
        }
        catch (ParseException ex) {
            if (ex.getASTNode() != null) {
                ASTNode ast = this.process(ex.getASTNode());
                ex = new ParseException(ex, ast);
            }
            this.setChange(ex);
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private ASTNode process(ASTNode root) {
        try {
            ASTNode nn;
            String mimeType = (String)this.doc.getProperty("mimeType");
            Language l = this.getLanguage(mimeType);
            Feature astProperties = l.getFeature("AST");
            if (astProperties != null && this.ast != null && (nn = (ASTNode)astProperties.getValue("process", SyntaxContext.create(this.doc, ASTPath.create(root)))) != null) {
                root = nn;
            }
            return root;
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return root;
        }
    }

    private ASTNode parse() throws ParseException {
        String mimeType = (String)this.doc.getProperty("mimeType");
        Language l = this.getLanguage(mimeType);
        LLSyntaxAnalyser a = l.getAnalyser();
        long start = System.currentTimeMillis();
        TokenInput input = this.createTokenInput();
        long to = System.currentTimeMillis() - start;
        ASTNode n = a.read(input, true);
        System.out.println("parse " + this.doc.getProperty("title") + " " + (System.currentTimeMillis() - start) + " " + to);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenInput createTokenInput() {
        try {
            if (this.doc instanceof NbEditorDocument) {
                ((NbEditorDocument)this.doc).readLock();
            }
            if (this.tokenHierarchy == null) {
                TokenInput tokenInput = TokenInputUtils.create(Collections.emptyList());
                return tokenInput;
            }
            TokenSequence ts = this.tokenHierarchy.tokenSequence();
            TokenInput tokenInput = TokenInputUtils.create(ParserManagerImpl.getTokens(ts));
            return tokenInput;
        }
        finally {
            if (this.doc instanceof NbEditorDocument) {
                ((NbEditorDocument)this.doc).readUnlock();
            }
        }
    }

    private static List<ASTToken> getTokens(TokenSequence ts) {
        ArrayList<ASTToken> tokens = new ArrayList<ASTToken>();
        while (ts.moveNext()) {
            Token t = ts.token();
            String type = t.id().name();
            int offset = ts.offset();
            String ttype = (String)t.getProperty((Object)"type");
            if (ttype == null || ttype.equals("E")) {
                List<ASTToken> children = null;
                TokenSequence ts2 = ts.embedded();
                if (ts2 != null) {
                    children = ParserManagerImpl.getTokens(ts2);
                }
                tokens.add(ASTToken.create(ts.language().mimeType(), type, ((Object)t.text()).toString(), offset, t.length(), children));
                continue;
            }
            if (ttype.equals("S")) {
                StringBuilder sb = new StringBuilder(((Object)t.text()).toString());
                ArrayList<ASTToken> children = new ArrayList<ASTToken>();
                TokenSequence ts2 = ts.embedded();
                while (ts.moveNext()) {
                    t = ts.token();
                    ttype = (String)t.getProperty((Object)"type");
                    if (ttype == null) {
                        ts.movePrevious();
                        break;
                    }
                    if (ttype.equals("E")) {
                        ts2 = ts.embedded();
                        children.addAll(ParserManagerImpl.getTokens(ts2));
                        continue;
                    }
                    if (ttype.equals("S")) {
                        ts.movePrevious();
                        break;
                    }
                    if (!ttype.equals("C")) {
                        throw new IllegalArgumentException();
                    }
                    if (!type.equals(t.id().name())) {
                        throw new IllegalArgumentException();
                    }
                    sb.append(((Object)t.text()).toString());
                }
                int no = ts.offset() + ts.token().length();
                tokens.add(ASTToken.create(ts.language().mimeType(), type, sb.toString(), offset, no - offset, children));
                continue;
            }
            throw new IllegalArgumentException();
        }
        return tokens;
    }

    private Language getLanguage(String mimeType) {
        if (mimeType.startsWith("test")) {
            int length = mimeType.length();
            for (int x = 4; x < length; ++x) {
                char c = mimeType.charAt(x);
                if (c >= '0' && c <= '9') continue;
                if (x <= 4 || c != '_' || x >= length - 1) break;
                mimeType = mimeType.substring(x + 1);
                break;
            }
        }
        try {
            return LanguagesManager.getDefault().getLanguage(mimeType);
        }
        catch (LanguageDefinitionNotFoundException ex) {
            return new Language(mimeType);
        }
    }

    private static class DocListener
    implements TokenHierarchyListener,
    LanguagesManager.LanguagesManagerListener {
        private WeakReference<ParserManagerImpl> pmwr;

        DocListener(ParserManagerImpl pm, TokenHierarchy hierarchy) {
            this.pmwr = new WeakReference<ParserManagerImpl>(pm);
            hierarchy.addTokenHierarchyListener((TokenHierarchyListener)this);
            LanguagesManager.getDefault().addLanguagesManagerListener(this);
        }

        private ParserManagerImpl getPM() {
            ParserManagerImpl pm = (ParserManagerImpl)this.pmwr.get();
            if (pm != null) {
                return pm;
            }
            LanguagesManager.getDefault().removeLanguagesManagerListener(this);
            return null;
        }

        public void languageChanged(String mimeType) {
            ParserManagerImpl pm = this.getPM();
            if (pm == null) {
                return;
            }
            pm.startParsing();
        }

        public void tokenHierarchyChanged(TokenHierarchyEvent evt) {
            ParserManagerImpl pm = this.getPM();
            if (pm == null) {
                return;
            }
            pm.startParsing();
        }
    }
}

