/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.awt.Point;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.RequestProcessor;

public class Utils {
    private static Logger logger = Logger.getLogger("org.netbeans.modules.languages");
    private static Map<String, WeakReference> collections;

    public static void notify(String message) {
        logger.log(Level.WARNING, message);
    }

    public static void message(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message));
            }
        });
    }

    public static void notify(Exception exception) {
        logger.log(Level.WARNING, null, exception);
    }

    public static void notify(String message, Exception exception) {
        logger.log(Level.WARNING, message, exception);
    }

    public static void startTest(String name, Collection c) {
        if (collections == null) {
            collections = new HashMap<String, WeakReference>();
            Utils.start();
        }
        collections.put(name, new WeakReference<Collection>(c));
    }

    public static void startTest(String name, Map m) {
        if (collections == null) {
            collections = new HashMap<String, WeakReference>();
            Utils.start();
        }
        collections.put(name, new WeakReference<Map>(m));
    }

    private static void start() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                HashMap cs = new HashMap(collections);
                for (String name : cs.keySet()) {
                    Object o = ((WeakReference)cs.get(name)).get();
                    if (o == null) {
                        collections.remove(name);
                        continue;
                    }
                    System.out.println(":" + name + " " + Utils.size(o));
                }
                Utils.start();
            }
        }, 5000);
    }

    private static int size(Object o) {
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            int s = c.size();
            for (Object item : c) {
                if (!(item instanceof Collection) && !(item instanceof Map)) continue;
                s += Utils.size(item);
            }
            return s;
        }
        Map m = (Map)o;
        int s = m.size();
        for (Object key : m.keySet()) {
            Object value;
            if (key instanceof Collection || key instanceof Map) {
                s += Utils.size(key);
            }
            if (!((value = m.get(key)) instanceof Collection) && !(value instanceof Map)) continue;
            s += Utils.size(value);
        }
        return s;
    }

    public static Point findPosition(String text, int offset) {
        int current = 0;
        int next = text.indexOf(10, current);
        int lineNumber = 1;
        while (next >= 0) {
            if (next > offset) {
                return new Point(lineNumber, offset - current + 1);
            }
            ++lineNumber;
            current = next + 1;
            next = text.indexOf(10, current);
        }
        throw new ArrayIndexOutOfBoundsException();
    }
}

