/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.dataobject;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.editor.ext.plain.PlainSyntax;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUI;
import org.netbeans.modules.languages.features.AnnotationManager;
import org.netbeans.modules.languages.features.BraceCompletionDeleteAction;
import org.netbeans.modules.languages.features.BraceCompletionInsertAction;
import org.netbeans.modules.languages.features.BraceHighlighting;
import org.netbeans.modules.languages.features.CollapseFoldTypeAction;
import org.netbeans.modules.languages.features.ExpandFoldTypeAction;
import org.netbeans.modules.languages.features.HyperlinkListener;
import org.netbeans.modules.languages.features.IndentAction;
import org.netbeans.modules.languages.features.LanguagesGenerateFoldPopupAction;
import org.netbeans.modules.languages.features.MyFirstDrawLayer;
import org.netbeans.modules.languages.features.MySecondDrawLayer;

public class LanguagesEditorKit
extends NbEditorKit {
    private String mimeType;
    private JLabel label;

    public LanguagesEditorKit(final String mimeType) {
        this.mimeType = mimeType;
        if (mimeType == null) {
            throw new NullPointerException();
        }
        Settings.addInitializer((Settings.Initializer)new Settings.Initializer(){

            public String getName() {
                return mimeType;
            }

            public void updateSettingsMap(Class kitClass, Map settingsMap) {
                if (kitClass != null && kitClass.equals(LanguagesEditorKit.class)) {
                    settingsMap.put("code-folding-enable", Boolean.TRUE);
                }
            }
        });
    }

    private JLabel createToolTipComponent() {
        if (this.label == null) {
            this.label = new JLabel(){

                public void setSize(int width, int height) {
                    if (this.getText() == null) {
                        super.setSize(width, height);
                        return;
                    }
                    int docLen = this.getText().length();
                    if (docLen > 0) {
                        Dimension prefSize = this.getPreferredSize();
                        if (width > prefSize.width) {
                            width = prefSize.width;
                            height = height >= prefSize.height ? prefSize.height : -1;
                        } else {
                            super.setSize(width, 100000);
                            int prefHeight = this.getPreferredSize().height;
                            height = prefHeight < height ? prefHeight : -1;
                        }
                    }
                    if (height >= 0) {
                        super.setSize(width, height);
                    } else {
                        this.putClientProperty(PopupManager.Placement.class, null);
                    }
                }
            };
            this.label.setActionMap(new ActionMap());
            this.label.setInputMap(1, null);
            Font font = UIManager.getFont("ToolTip.font");
            Color backColor = UIManager.getColor("ToolTip.background");
            Color foreColor = UIManager.getColor("ToolTip.foreground");
            if (font != null) {
                this.label.setFont(font);
            }
            if (foreColor != null) {
                this.label.setForeground(foreColor);
            }
            if (backColor != null) {
                this.label.setBackground(backColor);
            }
            this.label.setOpaque(true);
            this.label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.label.getForeground()), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        }
        return this.label;
    }

    protected Action[] createActions() {
        Action[] myActions = new Action[]{new BraceCompletionInsertAction(), new BraceCompletionDeleteAction(), new IndentAction(), new LanguagesGenerateFoldPopupAction()};
        return TextAction.augmentList(super.createActions(), myActions);
    }

    public Action getActionByName(String name) {
        if (name == null) {
            return super.getActionByName(name);
        }
        if (name.startsWith("Expand")) {
            return new ExpandFoldTypeAction(name);
        }
        if (name.startsWith("Collapse")) {
            return new CollapseFoldTypeAction(name);
        }
        return super.getActionByName(name);
    }

    protected EditorUI createEditorUI() {
        return new NbEditorUI(){
            private ToolTipSupport toolTipSupport;

            public ToolTipSupport getToolTipSupport() {
                if (this.toolTipSupport == null) {
                    this.toolTipSupport = new ToolTipSupport((ExtEditorUI)this){

                        public void setToolTipText(String text) {
                            if (text == null) {
                                return;
                            }
                            JLabel l = LanguagesEditorKit.this.createToolTipComponent();
                            l.setText(text);
                            this.setToolTip(l);
                        }
                    };
                }
                return this.toolTipSupport;
            }
        };
    }

    public Document createDefaultDocument() {
        Document doc = super.createDefaultDocument();
        this.initDocument(doc);
        return doc;
    }

    protected void initDocument(Document doc) {
        doc.putProperty("mimeType", this.mimeType);
        ((BaseDocument)doc).addLayer((DrawLayer)new MyFirstDrawLayer(this.mimeType), 3000);
        ((BaseDocument)doc).addLayer((DrawLayer)new MySecondDrawLayer(this.mimeType), 1500);
        new AnnotationManager(doc);
    }

    public Syntax createSyntax(Document doc) {
        return new PlainSyntax();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument doc) {
        return new BraceHighlighting(doc);
    }

    public void install(JEditorPane c) {
        super.install(c);
        HyperlinkListener hl = new HyperlinkListener();
        c.addMouseMotionListener(hl);
        c.addMouseListener(hl);
    }

    public String getContentType() {
        return this.mimeType;
    }

    public Object clone() {
        return new LanguagesEditorKit(this.mimeType);
    }
}

