/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.EditorParser;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.openide.text.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationManager
extends ASTEvaluator {
    private NbEditorDocument doc;
    private EditorParser parser;
    private List<ASTItem> items;
    private List<Feature> marks;
    private List<LanguagesAnnotation> annotations = new ArrayList<LanguagesAnnotation>();

    public AnnotationManager(Document doc) {
        this.doc = (NbEditorDocument)doc;
        this.parser = EditorParser.get(doc);
        this.parser.addASTEvaluator(this);
    }

    @Override
    public void beforeEvaluation(ParserManager.State state, ASTNode root) {
        this.items = new ArrayList<ASTItem>();
        this.marks = new ArrayList<Feature>();
    }

    @Override
    public void afterEvaluation(ParserManager.State state, ASTNode root) {
        this.refresh(this.items, this.marks);
    }

    @Override
    public void evaluate(ParserManager.State state, ASTPath path) {
        try {
            ASTItem item = path.getLeaf();
            Language language = LanguagesManager.getDefault().getLanguage(item.getMimeType());
            Feature mark = language.getFeature("MARK", path);
            if (mark != null && mark.getBoolean("condition", SyntaxContext.create((Document)this.doc, path), true)) {
                this.items.add(item);
                this.marks.add(mark);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void remove() {
        this.removeAnnotations();
        this.parser.removeASTEvaluator(this);
    }

    private void removeAnnotations() {
        Iterator<LanguagesAnnotation> it = this.annotations.iterator();
        while (it.hasNext()) {
            this.doc.removeAnnotation((Annotation)it.next());
        }
    }

    private void refresh(final List<ASTItem> items, final List<Feature> marks) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    AnnotationManager.this.removeAnnotations();
                    AnnotationManager.this.annotations = new ArrayList();
                    Iterator it2 = items.iterator();
                    Iterator it3 = marks.iterator();
                    while (it2.hasNext()) {
                        ASTItem item = (ASTItem)it2.next();
                        Feature mark = (Feature)it3.next();
                        LanguagesAnnotation la = new LanguagesAnnotation((String)mark.getValue("type"), (String)mark.getValue("message"));
                        AnnotationManager.this.doc.addAnnotation(AnnotationManager.this.doc.createPosition(item.getOffset()), item.getLength(), (Annotation)la);
                        AnnotationManager.this.annotations.add(la);
                    }
                }
                catch (BadLocationException ex) {
                    System.out.println("AnnotationManager " + ex);
                }
            }
        });
    }

    private static class LanguagesAnnotation
    extends Annotation {
        private String type;
        private String description;

        private LanguagesAnnotation(String type, String description) {
            this.type = type;
            this.description = description;
        }

        public String getAnnotationType() {
            return this.type;
        }

        public String getShortDescription() {
            return this.description;
        }
    }
}

