/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.languages.Context;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;

public class BraceCompletionInsertAction
extends ExtKit.ExtDefaultKeyTypedAction {
    protected void insertString(BaseDocument doc, int dotPos, Caret caret, String str, boolean overwrite) throws BadLocationException {
        try {
            String s;
            String mimeType = (String)doc.getProperty((Object)"mimeType");
            TokenHierarchy th = TokenHierarchy.get((Document)doc);
            if (th == null) {
                super.insertString(doc, dotPos, caret, str, overwrite);
                return;
            }
            TokenSequence ts = th.tokenSequence();
            while (true) {
                ts.move(caret.getDot());
                if (!ts.moveNext()) {
                    super.insertString(doc, dotPos, caret, str, overwrite);
                    return;
                }
                TokenSequence ts2 = ts.embedded();
                if (ts2 == null) break;
                ts = ts2;
            }
            mimeType = ts.language().mimeType();
            Language l = LanguagesManager.getDefault().getLanguage(mimeType);
            List<Feature> completes = l.getFeatures("COMPLETE");
            if (completes == null) {
                super.insertString(doc, dotPos, caret, str, overwrite);
                return;
            }
            Feature methodCall = null;
            for (Feature complete : completes) {
                if (complete.getType() == Feature.Type.METHOD_CALL) {
                    methodCall = complete;
                    continue;
                }
                s = (String)complete.getValue();
                int i = s.indexOf(58);
                String ss = doc.getText(caret.getDot(), s.length() - i - 1);
                if (!s.endsWith(ss) || !str.equals(ss)) continue;
                caret.setDot(caret.getDot() + 1);
                return;
            }
            boolean beg = ts.offset() == caret.getDot();
            super.insertString(doc, dotPos, caret, str, overwrite);
            th = TokenHierarchy.get((Document)doc);
            ts = th.tokenSequence();
            while (true) {
                ts.move(caret.getDot());
                if (!ts.moveNext()) {
                    return;
                }
                TokenSequence ts2 = ts.embedded();
                if (ts2 == null) break;
                ts = ts2;
            }
            if (methodCall != null) {
                if (caret.getDot() < doc.getLength()) {
                    ts.movePrevious();
                }
                if ((s = (String)methodCall.getValue(Context.create((Document)doc, ts))) != null) {
                    int pos = caret.getDot();
                    doc.insertString(pos, s, null);
                    caret.setDot(pos);
                }
            }
            if (!beg && ts.token().id().name().indexOf("whitespace") < 0) {
                return;
            }
            StyledDocument sdoc = (StyledDocument)doc;
            int ln = NbDocument.findLineNumber((StyledDocument)sdoc, (int)caret.getDot());
            int ls = NbDocument.findLineOffset((StyledDocument)sdoc, (int)ln);
            String text = sdoc.getText(ls, caret.getDot() - ls);
            for (Feature complete : completes) {
                int i;
                String s2;
                if (complete.getType() == Feature.Type.METHOD_CALL || !text.endsWith((s2 = (String)complete.getValue()).substring(0, i = s2.indexOf(58)))) continue;
                int pos = caret.getDot();
                doc.insertString(pos, s2.substring(i + 1), null);
                caret.setDot(pos);
                return;
            }
        }
        catch (ParseException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }
}

