/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BraceHighlighting
extends ExtSyntaxSupport {
    private static Map<Language, Map<String, String>[]> braces = new WeakHashMap<Language, Map<String, String>[]>();

    public BraceHighlighting(BaseDocument doc) {
        super(doc);
    }

    public int[] findMatchingBlock(int offset, boolean simpleSearch) throws BadLocationException {
        try {
            BaseDocument doc = this.getDocument();
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
            if (tokenHierarchy == null) {
                return super.findMatchingBlock(offset, simpleSearch);
            }
            TokenSequence tokens = tokenHierarchy.tokenSequence();
            tokens.move(offset);
            tokens.moveNext();
            Token token = tokens.token();
            String mimeType = (String)doc.getProperty((Object)"mimeType");
            Language language = LanguagesManager.getDefault().getLanguage(mimeType);
            Map<String, String>[] bracesValue = BraceHighlighting.getBraces(language);
            if (bracesValue == null) {
                return super.findMatchingBlock(offset, simpleSearch);
            }
            CharSequence text = ((Object)token.text()).toString();
            boolean moveToRight = false;
            String bracket = bracesValue[0].get(text);
            if (bracket != null) {
                moveToRight = true;
            } else {
                bracket = bracesValue[1].get(text);
                if (bracket == null) {
                    return null;
                }
            }
            String focusedBracket = text.toString();
            int focusedBracketLength = focusedBracket.length();
            int length = bracket.length();
            int depth = 1;
            while (moveToRight ? tokens.moveNext() : tokens.movePrevious()) {
                token = tokens.token();
                text = token.text();
                if (text.length() == length && bracket.equals(text.toString())) {
                    if (--depth != 0) continue;
                    int position = token.offset(tokenHierarchy);
                    return new int[]{position, position + token.length()};
                }
                if (text.length() != focusedBracketLength || !focusedBracket.equals(text.toString())) continue;
                ++depth;
            }
        }
        catch (ConcurrentModificationException e) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    private static Map<String, String>[] getBraces(Language l) {
        if (!braces.containsKey(l)) {
            HashMap<String, String> startToEnd = new HashMap<String, String>();
            HashMap<String, String> endToStart = new HashMap<String, String>();
            List<Feature> indents = l.getFeatures("BRACE");
            for (Feature indent : indents) {
                String s = (String)indent.getValue();
                int i = s.indexOf(58);
                String start = s.substring(0, i);
                String end = s.substring(i + 1);
                startToEnd.put(start, end);
                endToStart.put(end, start);
            }
            braces.put(l, new Map[]{startToEnd, endToStart});
        }
        return braces.get(l);
    }
}

