/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.FontColorSettingsFactory;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorsManager {
    public static final String COLOR = "COLOR";
    private static Map<String, Color> colors = new HashMap<String, Color>();

    static List<AttributeSet> getColors(Language l, ASTPath path, Document doc) {
        ArrayList<AttributeSet> result = new ArrayList<AttributeSet>();
        SyntaxContext context = SyntaxContext.create(doc, path);
        List<Feature> fs = l.getFeatures(COLOR, path);
        for (Feature f : fs) {
            if (!f.getBoolean("condition", context, true)) continue;
            result.add(ColorsManager.createColoring(f, null));
        }
        return result;
    }

    public static void initColorings(Language l) {
        FontColorSettingsFactory fcsf = EditorSettings.getDefault().getFontColorSettings(new String[]{l.getMimeType()});
        if (!fcsf.getAllFontColors("NetBeans").isEmpty()) {
            return;
        }
        String bundleName = ColorsManager.getBundleName(l);
        ResourceBundle bundle = bundleName != null ? NbBundle.getBundle((String)bundleName) : null;
        HashMap<String, AttributeSet> colorsMap = new HashMap<String, AttributeSet>();
        Iterator<Language> it = l.getImportedLanguages().iterator();
        while (it.hasNext()) {
            ColorsManager.addColors(colorsMap, it.next(), bundle);
        }
        ColorsManager.addColors(colorsMap, l, bundle);
        fcsf.setAllFontColorsDefaults("NetBeans", colorsMap.values());
        fcsf.setAllFontColors("NetBeans", colorsMap.values());
        if (bundleName != null) {
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            FileObject fo = fs.findResource("Editors/" + l.getMimeType() + "/FontsColors/NetBeans/org-netbeans-modules-editor-settings-CustomFontsColors.xml");
            try {
                if (fo != null) {
                    fo.setAttribute("SystemFileSystem.localizingBundle", (Object)bundleName);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            fo = fs.findResource("Editors/" + l.getMimeType() + "/FontsColors/NetBeans/Defaults/org-netbeans-modules-editor-settings-CustomFontsColors.xml");
            try {
                if (fo != null) {
                    fo.setAttribute("SystemFileSystem.localizingBundle", (Object)bundleName);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private static void addColors(Map<String, AttributeSet> colorsMap, Language l, ResourceBundle bundle) {
        Map<String, AttributeSet> defaultsMap = ColorsManager.getDefaultColors();
        List<Feature> list = l.getFeatures(COLOR);
        for (Feature f : list) {
            AttributeSet as = ColorsManager.createColoring(f, bundle);
            colorsMap.put((String)as.getAttribute(StyleConstants.NameAttribute), as);
        }
        for (Language.TokenType token : l.getTokenTypes()) {
            String type = token.getType();
            if (colorsMap.containsKey(type)) continue;
            SimpleAttributeSet sas = new SimpleAttributeSet();
            sas.addAttribute(StyleConstants.NameAttribute, type);
            String displayName = type;
            if (bundle != null) {
                try {
                    displayName = bundle.getString(type);
                }
                catch (MissingResourceException e) {
                    // empty catch block
                }
            }
            sas.addAttribute(EditorStyleConstants.DisplayName, displayName);
            String def = type;
            int i = def.lastIndexOf(95);
            if (i > 0) {
                def = def.substring(i + 1);
            }
            if (defaultsMap.containsKey(def)) {
                sas.addAttribute(EditorStyleConstants.Default, def);
            }
            colorsMap.put(type, sas);
        }
    }

    private static List<AttributeSet> getColors(Language l, ResourceBundle bundle) {
        List<Feature> list = l.getFeatures("COLORS");
        ArrayList<AttributeSet> result = new ArrayList<AttributeSet>();
        for (Feature f : list) {
            result.add(ColorsManager.createColoring(f, bundle));
        }
        return result;
    }

    private static AttributeSet createColoring(Feature f, ResourceBundle bundle) {
        String colorName = (String)f.getValue("color_name");
        String displayName = null;
        if (colorName == null) {
            colorName = f.getSelector().getAsString();
        }
        if (bundle != null) {
            try {
                displayName = bundle.getString(colorName);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (displayName == null) {
            displayName = colorName;
        }
        return ColorsManager.createColoring(colorName, displayName, (String)f.getValue("default_coloring"), (String)f.getValue("foreground_color"), (String)f.getValue("background_color"), (String)f.getValue("underline_color"), (String)f.getValue("wave_underline_color"), (String)f.getValue("strike_through_color"), (String)f.getValue("font_name"), (String)f.getValue("font_type"));
    }

    private static AttributeSet createColoring(String colorName, String displayName, String defaultColor, String foreground, String background, String underline, String waveunderline, String strikethrough, String fontName, String fontType) {
        SimpleAttributeSet coloring = new SimpleAttributeSet();
        coloring.addAttribute(StyleConstants.NameAttribute, colorName);
        coloring.addAttribute(EditorStyleConstants.DisplayName, displayName);
        if (defaultColor != null) {
            coloring.addAttribute(EditorStyleConstants.Default, defaultColor);
        }
        if (foreground != null) {
            coloring.addAttribute(StyleConstants.Foreground, ColorsManager.readColor(foreground));
        }
        if (background != null) {
            coloring.addAttribute(StyleConstants.Background, ColorsManager.readColor(background));
        }
        if (strikethrough != null) {
            coloring.addAttribute(StyleConstants.StrikeThrough, ColorsManager.readColor(strikethrough));
        }
        if (underline != null) {
            coloring.addAttribute(StyleConstants.Underline, ColorsManager.readColor(underline));
        }
        if (waveunderline != null) {
            coloring.addAttribute(EditorStyleConstants.WaveUnderlineColor, ColorsManager.readColor(waveunderline));
        }
        if (fontName != null) {
            coloring.addAttribute(StyleConstants.FontFamily, fontName);
        }
        if (fontType != null) {
            if (fontType.toLowerCase().indexOf("bold") >= 0) {
                coloring.addAttribute(StyleConstants.Bold, Boolean.TRUE);
            }
            if (fontType.toLowerCase().indexOf("italic") >= 0) {
                coloring.addAttribute(StyleConstants.Italic, Boolean.TRUE);
            }
        }
        return coloring;
    }

    static Color readColor(String color) {
        if (color == null) {
            return null;
        }
        Color result = colors.get(color);
        if (result == null) {
            result = Color.decode(color);
        }
        return result;
    }

    private static void addColor(String tokenType, SimpleAttributeSet sas, Map<String, AttributeSet> colorsMap, Map<String, AttributeSet> defaultsMap) {
        String colorName = (String)(sas = sas == null ? new SimpleAttributeSet() : new SimpleAttributeSet(sas)).getAttribute(StyleConstants.NameAttribute);
        if (colorName == null) {
            colorName = tokenType;
        }
        sas.addAttribute(StyleConstants.NameAttribute, colorName);
        sas.addAttribute(EditorStyleConstants.DisplayName, colorName);
        if (!sas.isDefined(EditorStyleConstants.Default)) {
            String def = colorName;
            int i = def.lastIndexOf(95);
            if (i > 0) {
                def = def.substring(i + 1);
            }
            if (defaultsMap.containsKey(def)) {
                sas.addAttribute(EditorStyleConstants.Default, def);
            }
        }
        colorsMap.put(colorName, sas);
    }

    private static Map<String, AttributeSet> getDefaultColors() {
        Collection defaults = EditorSettings.getDefault().getDefaultFontColorDefaults("NetBeans");
        HashMap<String, AttributeSet> defaultsMap = new HashMap<String, AttributeSet>();
        for (AttributeSet as : defaults) {
            defaultsMap.put((String)as.getAttribute(StyleConstants.NameAttribute), as);
        }
        return defaultsMap;
    }

    private static Map getCurrentColors(Language l) {
        FontColorSettingsFactory fcsf = EditorSettings.getDefault().getFontColorSettings(new String[]{l.getMimeType()});
        Collection colors = fcsf.getAllFontColors("NetBeans");
        HashMap<String, AttributeSet> colorsMap = new HashMap<String, AttributeSet>();
        for (AttributeSet as : colors) {
            colorsMap.put((String)as.getAttribute(StyleConstants.NameAttribute), as);
        }
        return colorsMap;
    }

    private static String getBundleName(Language l) {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject root = fs.findResource("Editors/" + l.getMimeType());
        Object attrValue = root.getAttribute("SystemFileSystem.localizingBundle");
        return (String)attrValue;
    }

    static {
        colors.put("black", Color.black);
        colors.put("blue", Color.blue);
        colors.put("cyan", Color.cyan);
        colors.put("darkGray", Color.darkGray);
        colors.put("gray", Color.gray);
        colors.put("green", Color.green);
        colors.put("lightGray", Color.lightGray);
        colors.put("magenta", Color.magenta);
        colors.put("orange", Color.orange);
        colors.put("pink", Color.pink);
        colors.put("red", Color.red);
        colors.put("white", Color.white);
        colors.put("yellow", Color.yellow);
    }
}

