/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.Context;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.ParserManagerListener;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.features.CompletionSupport;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionProviderImpl
implements CompletionProvider {
    private static final String COMPLETION = "COMPLETION";

    public CompletionTask createTask(int queryType, JTextComponent component) {
        return new CompletionTaskImpl(component);
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        if (".".equals(typedText)) {
            Document doc = component.getDocument();
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            int offset = component.getCaret().getDot();
            if (offset <= 1) {
                return 0;
            }
            tokenSequence.move(offset - 2);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return 0;
            }
            Token token = tokenSequence.token();
            if (token.id().name().indexOf("identifier") > -1) {
                return 1;
            }
        }
        return 0;
    }

    List<CompletionItem> query(JTextComponent component) {
        ListResult r = new ListResult();
        CompletionTaskImpl task = new CompletionTaskImpl(component);
        task.compute(r);
        r.waitFinished();
        return r.getList();
    }

    private static class CompletionResult
    implements Result {
        private CompletionResultSet resultSet;

        CompletionResult(CompletionResultSet resultSet) {
            this.resultSet = resultSet;
        }

        public void addItem(CompletionItem item) {
            this.resultSet.addItem(item);
        }

        public void finish() {
            this.resultSet.finish();
        }

        public boolean isFinished() {
            return this.resultSet.isFinished();
        }
    }

    private static class CompletionTaskImpl
    implements CompletionTask {
        private JTextComponent component;
        private Document doc;
        private boolean ignoreCase;
        private List<CompletionItem> items = new ArrayList<CompletionItem>();

        CompletionTaskImpl(JTextComponent component) {
            this.component = component;
        }

        public void query(CompletionResultSet resultSet) {
            this.compute(new CompletionResult(resultSet));
        }

        public void refresh(CompletionResultSet resultSet) {
            if (resultSet == null) {
                return;
            }
            try {
                String start;
                String type;
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.doc);
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                int offset = this.component.getCaret().getDot();
                tokenSequence.move(offset - 1);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    resultSet.finish();
                    return;
                }
                String mimeType = tokenSequence.language().mimeType();
                Language language = LanguagesManager.getDefault().getLanguage(mimeType);
                Token token = tokenSequence.token();
                int tokenOffset = tokenSequence.offset();
                String tokenType = token.id().name();
                Feature feature = language.getFeature(CompletionProviderImpl.COMPLETION, tokenType);
                String string = type = feature == null ? null : (String)feature.getValue("type");
                if ("operator".equals(type) && offset < tokenOffset + token.length()) {
                    resultSet.finish();
                    return;
                }
                String string2 = start = "operator".equals(type) || "whitespace".equals(type) ? "" : ((Object)token.text()).toString().substring(0, offset - tokenOffset).trim();
                if (this.ignoreCase) {
                    start = start.toLowerCase();
                }
                for (CompletionItem item : this.items) {
                    CharSequence chs = item.getInsertPrefix();
                    String s = chs instanceof String ? (String)chs : ((Object)chs).toString();
                    if (!s.startsWith(start)) continue;
                    resultSet.addItem(item);
                }
                resultSet.finish();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }

        public void cancel() {
        }

        private void compute(Result resultSet) {
            this.doc = this.component.getDocument();
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.doc);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            int offset = this.component.getCaret().getDot();
            this.compute(tokenSequence, offset, resultSet, this.doc);
            this.addParserTags(resultSet);
        }

        private void compute(TokenSequence tokenSequence, int offset, Result resultSet, Document doc) {
            if (tokenSequence == null) {
                return;
            }
            String mimeType = tokenSequence.language().mimeType();
            Feature feature = null;
            String start = null;
            tokenSequence.move(offset - 1);
            if (!tokenSequence.moveNext()) {
                return;
            }
            Token token = tokenSequence.token();
            start = ((Object)token.text()).toString();
            if (tokenSequence.offset() > offset) {
                return;
            }
            try {
                Language language = LanguagesManager.getDefault().getLanguage(mimeType);
                String tokenType = token.id().name();
                feature = language.getFeature(CompletionProviderImpl.COMPLETION, tokenType);
                String type = feature == null ? null : (String)feature.getValue("type");
                int tokenOffset = tokenSequence.offset();
                if ("operator".equals(type) && offset < tokenOffset + token.length()) {
                    return;
                }
                start = "operator".equals(type) || "whitespace".equals(type) ? "" : start.substring(0, offset - tokenOffset).trim();
                this.ignoreCase = false;
                Feature f = language.getFeature("PROPERTIES");
                if (f != null) {
                    this.ignoreCase = f.getBoolean("ignoreCase", false);
                }
                if (this.ignoreCase) {
                    start = start.toLowerCase();
                }
            }
            catch (LanguageDefinitionNotFoundException ex) {
                // empty catch block
            }
            if (feature == null) {
                this.compute(tokenSequence.embedded(), offset, resultSet, doc);
            } else {
                this.addTags(feature, start, Context.create(doc, tokenSequence), resultSet);
            }
        }

        private void addParserTags(final Result resultSet) {
            final ParserManager parserManager = ParserManager.get(this.doc);
            if (parserManager.getState() == ParserManager.State.PARSING) {
                parserManager.addListener(new ParserManagerListener(){

                    public void parsed(ParserManager.State state, ASTNode ast) {
                        if (resultSet.isFinished()) {
                            return;
                        }
                        parserManager.removeListener(this);
                        CompletionTaskImpl.this.addParserTags(ast, resultSet);
                        resultSet.finish();
                    }
                });
            } else {
                try {
                    this.addParserTags(ParserManagerImpl.get(this.doc).getAST(), resultSet);
                }
                catch (ParseException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                resultSet.finish();
            }
        }

        private void addParserTags(ASTNode node, Result resultSet) {
            String type;
            if (node == null) {
                return;
            }
            int offset = this.component.getCaret().getDot();
            ASTPath path = node.findPath(offset - 1);
            if (path == null) {
                return;
            }
            ASTItem item = path.getLeaf();
            if (item instanceof ASTNode) {
                return;
            }
            ASTToken token = (ASTToken)item;
            if (token.getLength() != token.getIdentifier().length()) {
                return;
            }
            Language lang = null;
            try {
                lang = LanguagesManager.getDefault().getLanguage(token.getMimeType());
            }
            catch (ParseException e) {
                // empty catch block
            }
            if (lang == null) {
                return;
            }
            String tokenType = token.getType();
            Feature f = lang.getFeature(CompletionProviderImpl.COMPLETION, tokenType);
            int tokenOffset = token.getOffset();
            String string = type = f == null ? null : (String)f.getValue("type");
            if ("operator".equals(type) && offset < tokenOffset + token.getLength()) {
                return;
            }
            String start = "operator".equals(type) || "whitespace".equals(type) ? "" : token.getIdentifier().substring(0, offset - tokenOffset).trim();
            for (int i = path.size() - 1; i >= 0; --i) {
                item = path.get(i);
                try {
                    Language language = LanguagesManager.getDefault().getLanguage(item.getMimeType());
                    Feature feature = language.getFeature(CompletionProviderImpl.COMPLETION, path.subPath(i));
                    if (feature == null) continue;
                    this.addTags(feature, start, SyntaxContext.create(this.doc, path.subPath(i)), resultSet);
                    continue;
                }
                catch (ParseException ex) {
                    // empty catch block
                }
            }
        }

        private void addTags(Feature feature, String start, Context context, Result resultSet) {
            Object o;
            int j = 1;
            while ((o = feature.getValue("text" + j, context)) != null) {
                if (o instanceof String) {
                    this.addTags((String)o, feature, j, start, resultSet);
                } else {
                    this.addMethodCallTags((List)o, context, resultSet, start);
                }
                ++j;
            }
        }

        private void addMethodCallTags(List keys, Context context, Result resultSet, String start) {
            for (Object o : keys) {
                String s;
                if (o instanceof org.netbeans.api.languages.CompletionItem) {
                    o = new CompletionSupport((org.netbeans.api.languages.CompletionItem)o);
                }
                CompletionItem item = (CompletionItem)o;
                this.items.add(item);
                CharSequence chs = item.getInsertPrefix();
                String string = s = chs instanceof String ? (String)chs : ((Object)chs).toString();
                if (this.ignoreCase) {
                    s = s.toLowerCase();
                }
                if (!s.startsWith(start)) continue;
                resultSet.addItem(item);
            }
        }

        private void addTags(String text, Feature feature, int j, String start, Result resultSet) {
            String description;
            if (this.ignoreCase) {
                text = text.toLowerCase();
            }
            if ((description = (String)feature.getValue("description" + j)) == null) {
                description = text;
            }
            String icon = (String)feature.getValue("icon" + j);
            CompletionSupport item = new CompletionSupport(text, description, null, icon, 2);
            this.items.add(item);
            if (!text.startsWith(start)) {
                return;
            }
            resultSet.addItem(item);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListResult
    implements Result {
        private List<CompletionItem> result = new ArrayList<CompletionItem>();
        private boolean finished = false;
        private Object LOCK = new Object();

        private ListResult() {
        }

        @Override
        public void addItem(CompletionItem item) {
            this.result.add(item);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish() {
            this.finished = true;
            Object object = this.LOCK;
            synchronized (object) {
                this.LOCK.notify();
            }
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitFinished() {
            if (this.finished) {
                return;
            }
            Object object = this.LOCK;
            synchronized (object) {
                try {
                    this.LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public List<CompletionItem> getList() {
            return this.result;
        }
    }

    private static interface Result {
        public void addItem(CompletionItem var1);

        public void finish();

        public boolean isFinished();
    }
}

