/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.languages.CompletionItem;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.ErrorManager;
import org.openide.util.Utilities;

public class CompletionSupport
implements CompletionItem {
    private static Map<String, ImageIcon> icons = new HashMap<String, ImageIcon>();
    private String text;
    private String description;
    private String rightText;
    private String icon;
    private int priority;

    private static ImageIcon getCIcon(String resourceName) {
        if (resourceName == null) {
            resourceName = "org/netbeans/modules/languages/resources/node.gif";
        }
        if (!icons.containsKey(resourceName)) {
            Image image = Utilities.loadImage((String)resourceName);
            if (image == null) {
                image = Utilities.loadImage((String)"org/netbeans/modules/languages/resources/node.gif");
            }
            icons.put(resourceName, new ImageIcon(image));
        }
        return icons.get(resourceName);
    }

    CompletionSupport(org.netbeans.api.languages.CompletionItem item) {
        this.text = item.getText();
        this.rightText = item.getLibrary();
        this.priority = item.getPriority();
        String color = "000000";
        CompletionItem.Type type = item.getType();
        boolean bold = false;
        String key = item.getText();
        switch (type) {
            case KEYWORD: {
                color = "000099";
                this.icon = "/org/netbeans/modules/languages/resources/keyword.jpg";
                bold = true;
                break;
            }
            case INTERFACE: {
                color = "560000";
                this.icon = "/org/netbeans/modules/editor/resources/completion/interface.png";
                break;
            }
            case CLASS: {
                color = "560000";
                this.icon = "/org/netbeans/modules/editor/resources/completion/class_16.png ";
                break;
            }
            case FIELD: {
                this.icon = "/org/netbeans/modules/editor/resources/completion/field_16.png";
                break;
            }
            case METHOD: {
                this.icon = "/org/netbeans/modules/editor/resources/completion/method_16.png";
                bold = true;
                key = key + "()";
                break;
            }
            case CONSTRUCTOR: {
                this.icon = "/org/netbeans/modules/editor/resources/completion/constructor_16.png";
                bold = true;
                key = key + "()";
                break;
            }
            case CONSTANT: {
                this.icon = "/org/netbeans/modules/editor/resources/completion/field_static_16.png";
                break;
            }
            case LOCAL: {
                this.icon = "/org/netbeans/modules/editor/resources/completion/localVariable.gif";
                break;
            }
            case PARAMETER: {
                this.icon = "/org/netbeans/modules/editor/resources/completion/localVariable.gif";
            }
        }
        this.description = item.getDescription() == null ? "<html>" + (bold ? "<b>" : "") + "<font color=#" + color + ">" + key + "</font>" + (bold ? "</b>" : "") + "</html>" : "<html>" + (bold ? "<b>" : "") + "<font color=#" + color + ">" + key + ": </font>" + (bold ? "</b>" : "") + "<font color=#000000> " + item.getDescription() + "</font></html>";
    }

    CompletionSupport(String text, String description, String rightText, String icon, int priority) {
        this.text = text;
        this.description = description;
        this.rightText = rightText;
        this.icon = icon;
        this.priority = priority;
    }

    public void defaultAction(JTextComponent component) {
        NbEditorDocument doc = (NbEditorDocument)component.getDocument();
        int offset = component.getCaret().getDot();
        try {
            int delta;
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
            TokenSequence sequence = tokenHierarchy.tokenSequence();
            while (true) {
                sequence.move(offset - 1);
                sequence.moveNext();
                TokenSequence embedded = sequence.embedded();
                if (embedded == null) break;
                sequence = embedded;
            }
            Token token = sequence.token();
            String tokenType = token.id().name();
            String mimeType = sequence.language().mimeType();
            Language l = LanguagesManager.getDefault().getLanguage(mimeType);
            Feature feature = l.getFeature("COMPLETION", tokenType);
            String t = this.text;
            String start = ((Object)token.text()).toString();
            start = start.substring(0, offset - sequence.offset()).trim();
            int n = delta = feature != null && "true".equals(feature.getValue("doNotUsePrefix")) ? start.length() : 0;
            if (!l.getSkipTokenTypes().contains(token.id().name())) {
                t = this.text.substring(offset - sequence.offset() - delta);
            }
            doc.insertString(offset, t, null);
        }
        catch (BadLocationException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        catch (LanguageDefinitionNotFoundException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        Completion.get().hideAll();
    }

    public void processKeyEvent(KeyEvent evt) {
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.description, (String)this.rightText, (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml((ImageIcon)CompletionSupport.getCIcon(this.icon), (String)this.description, (String)this.rightText, (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent component) {
        return false;
    }

    public int getSortPriority() {
        return this.priority;
    }

    public CharSequence getSortText() {
        return this.text;
    }

    public CharSequence getInsertPrefix() {
        return this.text;
    }
}

