/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.languages.ParseException;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.features.Folds;

public class ExpandFoldTypeAction
extends BaseAction {
    public ExpandFoldTypeAction(String name) {
        super(name);
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
        try {
            String mimeType = (String)target.getDocument().getProperty("mimeType");
            Language l = LanguagesManager.getDefault().getLanguage(mimeType);
            if (this.expand(hierarchy, l)) {
                return;
            }
            Iterator<Language> it = l.getImportedLanguages().iterator();
            while (it.hasNext()) {
                if (!this.expand(hierarchy, it.next())) continue;
                return;
            }
        }
        catch (ParseException ex) {
            // empty catch block
        }
    }

    private boolean expand(FoldHierarchy hierarchy, Language l) {
        List<Feature> folds = l.getFeatures("FOLD");
        for (Feature fold : folds) {
            String collapse;
            String expand = l.localize((String)fold.getValue("expand_type_action_name"));
            if (expand == null || !expand.equals(this.getValue("Name")) || (collapse = l.localize((String)fold.getValue("collapse_type_action_name"))) == null) continue;
            ArrayList<FoldType> types = new ArrayList<FoldType>();
            types.add(Folds.getFoldType(collapse));
            FoldUtilities.expand((FoldHierarchy)hierarchy, types);
            return true;
        }
        return false;
    }
}

