/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.ParseException;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatAction
extends BaseAction {
    public FormatAction() {
        super("Format");
    }

    public void actionPerformed(ActionEvent e, JTextComponent component) {
        try {
            NbEditorDocument doc = (NbEditorDocument)component.getDocument();
            ASTNode root = ParserManagerImpl.get((Document)doc).getAST();
            if (root == null) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            HashMap<String, String> indents = new HashMap<String, String>();
            indents.put("i", "");
            indents.put("ii", "    ");
            FormatAction.indent(root, new ArrayList<ASTItem>(), sb, indents, null, false, doc);
            doc.remove(0, doc.getLength());
            doc.insertString(0, sb.toString(), null);
        }
        catch (ParseException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        catch (BadLocationException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private static void indent(ASTItem item, List<ASTItem> path, StringBuilder sb, Map<String, String> indents, ASTToken whitespace, boolean firstIndented, NbEditorDocument document) {
        try {
            Language language = LanguagesManager.getDefault().getLanguage(item.getMimeType());
            path.add(item);
            ASTPath path2 = ASTPath.create(path);
            for (ASTItem e : item.getChildren()) {
                Feature format;
                String indent = null;
                if (e instanceof ASTToken) {
                    ASTToken token = (ASTToken)e;
                    if (language.getSkipTokenTypes().contains(token.getType())) {
                        whitespace = (ASTToken)e;
                        firstIndented = false;
                        continue;
                    }
                }
                if ((format = language.getFeature("FORMAT", path2)) != null) {
                    indent = (String)format.getValue();
                }
                if (indent != null && indent.equals("NewLine")) {
                    sb.append("\n");
                }
                if (e instanceof ASTToken) {
                    sb.append(((ASTToken)e).getIdentifier());
                    continue;
                }
                FormatAction.indent((ASTNode)e, path, sb, indents, whitespace, firstIndented || indent != null, null);
            }
            path.remove(path.size() - 1);
        }
        catch (ParseException ex) {
            // empty catch block
        }
    }

    private static String chars(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }
}

