/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.event.ActionEvent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ParseException;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.openide.ErrorManager;

public class GenericAction
extends BaseAction {
    String performerName = null;
    String enablerName = null;
    Feature performer = null;
    Feature enabler = null;

    public GenericAction(String name, String performerName, String enablerName) {
        super(name);
        this.performerName = performerName;
        this.enablerName = enablerName;
    }

    private Feature getPerformer() {
        if (this.performer == null) {
            this.performer = Feature.createMethodCallFeature(null, null, this.performerName);
        }
        return this.performer;
    }

    private Feature getEnabler() {
        if (this.enablerName == null) {
            return null;
        }
        if (this.enabler == null) {
            this.enabler = Feature.createMethodCallFeature(null, null, this.enablerName);
        }
        return this.enabler;
    }

    private ASTNode getASTNode(JTextComponent comp) {
        try {
            return ParserManagerImpl.get((Document)((NbEditorDocument)comp.getDocument())).getAST();
        }
        catch (ParseException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return null;
        }
    }

    public void actionPerformed(ActionEvent e, JTextComponent comp) {
        ASTNode node = this.getASTNode(comp);
        if (node != null) {
            this.getPerformer().getValue(new Object[]{node, comp});
        }
    }

    public boolean isEnabled() {
        JTextComponent comp = this.getTextComponent(null);
        if (comp == null) {
            return false;
        }
        ASTNode node = this.getASTNode(comp);
        if (node == null) {
            return false;
        }
        Feature em = this.getEnabler();
        if (em == null) {
            return super.isEnabled();
        }
        Object result = em.getValue(new Object[]{node, comp});
        return (Boolean)result;
    }
}

