/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.Context;
import org.netbeans.api.languages.Highlighting;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.ParserManagerImpl;

public class HyperlinkListener
implements MouseMotionListener,
MouseListener {
    private Context context = null;
    private Runnable runnable = null;
    private static AttributeSet hyperlinkAS = null;
    private static AttributeSet hyperlinkPressedAS = null;

    public void mouseMoved(MouseEvent e) {
        JEditorPane c = (JEditorPane)e.getComponent();
        NbEditorDocument doc = (NbEditorDocument)c.getDocument();
        if (!e.isControlDown()) {
            if (this.context != null) {
                this.removeHighlihgt(doc);
            }
            return;
        }
        Object[] r = this.findEvaluator(doc, c.viewToModel(e.getPoint()));
        if (this.context != null && (r == null || this.context != r[0])) {
            this.removeHighlihgt(doc);
        }
        if (r != null) {
            Feature hyperlink = (Feature)r[1];
            this.runnable = (Runnable)hyperlink.getValue((Context)r[0]);
            if (this.runnable != null) {
                this.context = (Context)r[0];
                this.highlight(doc);
            }
        }
        c.repaint();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (this.context == null) {
            return;
        }
        if (this.runnable != null) {
            this.runnable.run();
        }
        JEditorPane c = (JEditorPane)e.getComponent();
        NbEditorDocument doc = (NbEditorDocument)c.getDocument();
        this.runnable = null;
        this.removeHighlihgt(doc);
        c.repaint();
    }

    public void mousePressed(MouseEvent e) {
        if (this.context == null) {
            return;
        }
        JEditorPane c = (JEditorPane)e.getComponent();
        NbEditorDocument doc = (NbEditorDocument)c.getDocument();
        this.highlight(doc);
        c.repaint();
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    private void highlight(NbEditorDocument doc) {
        if (this.context instanceof SyntaxContext) {
            ASTItem o = null;
            o = ((SyntaxContext)this.context).getASTPath().getLeaf();
            if (o instanceof ASTToken) {
                Highlighting.getHighlighting((Document)doc).highlight((ASTToken)o, HyperlinkListener.getHyperlinkPressedAS());
            } else {
                Highlighting.getHighlighting((Document)doc).highlight((ASTNode)o, HyperlinkListener.getHyperlinkPressedAS());
            }
        } else {
            TokenSequence ts = this.context.getTokenSequence();
            Token t = ts.token();
            ASTToken stoken = ASTToken.create(ts.language().mimeType(), t.id().name(), ((Object)t.text()).toString(), ts.offset());
            Highlighting.getHighlighting((Document)doc).highlight(stoken, HyperlinkListener.getHyperlinkPressedAS());
        }
    }

    private void removeHighlihgt(NbEditorDocument doc) {
        if (this.context instanceof SyntaxContext) {
            ASTItem o = null;
            o = ((SyntaxContext)this.context).getASTPath().getLeaf();
            if (o instanceof ASTToken) {
                Highlighting.getHighlighting((Document)doc).removeHighlight((ASTToken)o);
            } else {
                Highlighting.getHighlighting((Document)doc).removeHighlight((ASTNode)o);
            }
        } else {
            TokenSequence ts = this.context.getTokenSequence();
            Token t = ts.token();
            ASTToken stoken = ASTToken.create(ts.language().mimeType(), t.id().name(), ((Object)t.text()).toString(), ts.offset());
            Highlighting.getHighlighting((Document)doc).highlight(stoken, HyperlinkListener.getHyperlinkPressedAS());
        }
        this.context = null;
    }

    private Object[] findEvaluator(NbEditorDocument doc, int offset) {
        try {
            ASTNode ast = null;
            try {
                ast = ParserManagerImpl.get((Document)doc).getAST();
            }
            catch (ParseException ex) {
                ast = ex.getASTNode();
            }
            if (ast == null) {
                String mimeType = (String)doc.getProperty((Object)"mimeType");
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                tokenSequence.move(offset);
                tokenSequence.moveNext();
                Language language = LanguagesManager.getDefault().getLanguage(mimeType);
                Token token = tokenSequence.token();
                Feature hyperlink = language.getFeature("HYPERLINK", token.id().name());
                if (hyperlink != null) {
                    return new Object[]{Context.create((Document)doc, tokenSequence), hyperlink};
                }
                return null;
            }
            ASTPath path = ast.findPath(offset);
            if (path == null) {
                return null;
            }
            int k = path.size();
            for (int i = 0; i < k; ++i) {
                ASTPath p = path.subPath(i);
                Language language = LanguagesManager.getDefault().getLanguage(p.getLeaf().getMimeType());
                Feature hyperlink = language.getFeature("HYPERLINK", p);
                if (hyperlink == null) continue;
                return new Object[]{SyntaxContext.create((Document)doc, p), hyperlink};
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    private static AttributeSet getHyperlinkAS() {
        if (hyperlinkAS == null) {
            SimpleAttributeSet as = new SimpleAttributeSet();
            as.addAttribute(StyleConstants.Foreground, Color.blue);
            as.addAttribute(StyleConstants.Underline, Color.blue);
            hyperlinkAS = as;
        }
        return hyperlinkAS;
    }

    private static AttributeSet getHyperlinkPressedAS() {
        if (hyperlinkPressedAS == null) {
            SimpleAttributeSet as = new SimpleAttributeSet();
            as.addAttribute(StyleConstants.Foreground, Color.red);
            as.addAttribute(StyleConstants.Underline, Color.red);
            hyperlinkPressedAS = as;
        }
        return hyperlinkPressedAS;
    }
}

