/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.text.JTextComponent;
import org.netbeans.api.languages.ParseException;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;

public class LanguagesGenerateFoldPopupAction
extends NbEditorKit.GenerateFoldPopupAction {
    protected void addAdditionalItems(JTextComponent target, JMenu menu) {
        try {
            String mimeType = (String)target.getDocument().getProperty("mimeType");
            Language l = LanguagesManager.getDefault().getLanguage(mimeType);
            HashSet expands = new HashSet();
            this.addFoldTypes(target, menu, l, expands);
            Iterator<Language> it = l.getImportedLanguages().iterator();
            while (it.hasNext()) {
                this.addFoldTypes(target, menu, it.next(), expands);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void addFoldTypes(JTextComponent target, JMenu menu, Language l, Set expands) {
        List<Feature> features = l.getFeatures("FOLD");
        for (Feature fold : features) {
            String expand = l.localize((String)fold.getValue("expand_type_action_name"));
            if (expand == null || expands.contains(expand)) continue;
            expands.add(expand);
            String collapse = l.localize((String)fold.getValue("collapse_type_action_name"));
            if (collapse == null) continue;
            this.addAction(target, menu, expand);
            this.addAction(target, menu, collapse);
            this.setAddSeparatorBeforeNextAction(true);
        }
    }
}

