/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.lexer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.netbeans.api.languages.ParseException;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.lexer.SLexer;
import org.netbeans.modules.languages.lexer.STokenId;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLanguageHierarchy
extends LanguageHierarchy<STokenId> {
    private String mimeType;
    private Collection<STokenId> tokenIds;
    private HashMap<String, STokenId> tokensMap;

    public SLanguageHierarchy(String mimeType) {
        this.mimeType = mimeType;
    }

    protected Collection<STokenId> createTokenIds() {
        if (this.tokenIds == null) {
            this.tokenIds = new ArrayList<STokenId>();
            this.tokensMap = new HashMap();
            for (Language.TokenType t : this.getLanguage().getTokenTypes()) {
                if (this.tokensMap.containsKey(t.getType())) continue;
                STokenId tokenId = new STokenId(t.getType(), this.tokenIds.size(), t.getType());
                this.tokenIds.add(tokenId);
                this.tokensMap.put(t.getType(), tokenId);
            }
            STokenId errorTokenId = new STokenId("error", this.tokenIds.size(), "error");
            this.tokenIds.add(errorTokenId);
            this.tokensMap.put("error", errorTokenId);
            STokenId embeddingTokenId = new STokenId("PE", this.tokenIds.size(), "PE");
            this.tokenIds.add(embeddingTokenId);
            this.tokensMap.put("PE", embeddingTokenId);
        }
        return this.tokenIds;
    }

    protected Lexer<STokenId> createLexer(LexerRestartInfo<STokenId> info) {
        if (this.tokensMap == null) {
            this.createTokenIds();
        }
        return new SLexer(this.getLanguage(), this.tokensMap, info);
    }

    protected String mimeType() {
        return this.mimeType;
    }

    private Language getLanguage() {
        try {
            return LanguagesManager.getDefault().getLanguage(this.mimeType);
        }
        catch (ParseException ex) {
            return new Language(this.mimeType);
        }
    }
}

