/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DG<N, E, K, V> {
    private Map<N, Node<N, E, K, V>> idToNode = new HashMap<N, Node<N, E, K, V>>();
    private Map<Node<N, E, K, V>, N> nodeToId = new HashMap<Node<N, E, K, V>, N>();
    private N start;
    private Set<N> ends = new HashSet<N>();
    private static Character NN = new Character('\n');
    private static Character NR = new Character('\n');
    private static Character NT = new Character('\n');
    private static Character NS = new Character('\n');
    private static final Character STAR = new Character('\u0000');

    static <N, E, K, V> DG<N, E, K, V> createDG(N node) {
        return new DG<N, E, K, V>(node);
    }

    static <N, E, K, V> DG<N, E, K, V> createDG() {
        return new DG<N, E, K, V>();
    }

    private DG() {
    }

    private DG(N node) {
        this.start = node;
        Node n = new Node();
        this.idToNode.put(node, n);
        this.nodeToId.put(n, node);
        this.ends.add(node);
    }

    N getStartNode() {
        return this.start;
    }

    void setStart(N node) {
        if (this.idToNode.get(node) == null) {
            new NullPointerException();
        }
        this.start = node;
    }

    Set<N> getEnds() {
        return Collections.unmodifiableSet(this.ends);
    }

    void setEnds(Set<N> ends) {
        this.ends = new HashSet<N>(ends);
    }

    void addEnd(N end) {
        assert (end != null);
        this.ends.add(end);
    }

    void removeEnd(N end) {
        this.ends.remove(end);
    }

    void addNode(N node) {
        assert (node != null);
        if (this.idToNode.containsKey(node)) {
            throw new IllegalArgumentException();
        }
        Node n = new Node();
        this.idToNode.put(node, n);
        this.nodeToId.put(n, node);
    }

    void removeNode(N node) {
        Node<N, E, K, V> n = this.idToNode.remove(node);
        this.nodeToId.remove(n);
    }

    boolean containsNode(N node) {
        return this.idToNode.containsKey(node);
    }

    Set<N> getNodes() {
        return Collections.unmodifiableSet(this.idToNode.keySet());
    }

    N getNode(N node, E edge) {
        Node<N, E, K, V> s = this.idToNode.get(node);
        Node<N, E, K, V> e = s.getNode(edge);
        return this.nodeToId.get(e);
    }

    void addEdge(N startNode, N endNode, E edge) {
        assert (startNode != null);
        assert (endNode != null);
        assert (edge != null);
        Node<N, E, K, V> s = this.idToNode.get(startNode);
        Node<N, E, K, V> e = this.idToNode.get(endNode);
        assert (s != null);
        assert (e != null);
        s.addEdge(edge, e);
    }

    Set<E> getEdges(N node) {
        Node<N, E, K, V> n = this.idToNode.get(node);
        return n.edges();
    }

    E getEdge(N node, E edge) {
        Node<N, E, K, V> n = this.idToNode.get(node);
        return n.getEdge(edge);
    }

    V getProperty(N node, K key) {
        Node<N, E, K, V> n = this.idToNode.get(node);
        return n.getProperty(key);
    }

    Map<K, V> getProperties(N node) {
        Node<N, E, K, V> n;
        if (node == null) {
            System.out.println("!");
        }
        if ((n = this.idToNode.get(node)) == null) {
            System.out.println(node);
        }
        if (((Node)n).properties == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(((Node)n).properties);
    }

    void putAllProperties(N node, Map<K, V> properties) {
        if (properties.size() == 0) {
            return;
        }
        Node<N, E, K, V> n = this.idToNode.get(node);
        if (((Node)n).properties == null) {
            ((Node)n).properties = new HashMap();
        }
        ((Node)n).properties.putAll(properties);
    }

    void setProperty(N node, K key, V value) {
        Node<N, E, K, V> n = this.idToNode.get(node);
        n.setProperty(key, value);
    }

    V getProperty(N node, E edge, K key) {
        Node<N, E, K, V> n = this.idToNode.get(node);
        return n.getEdgeProperty(edge, key);
    }

    Map<K, V> getProperties(N node, E edge) {
        Node<N, E, K, V> n = this.idToNode.get(node);
        if (((Node)n).idToProperties == null || ((Node)n).idToProperties.get(edge) == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap((Map)((Node)n).idToProperties.get(edge));
    }

    void putAllProperties(N node, E edge, Map<K, V> properties) {
        if (properties.size() == 0) {
            return;
        }
        Node<N, E, K, V> n = this.idToNode.get(node);
        if (((Node)n).idToProperties == null) {
            ((Node)n).idToProperties = new HashMap();
        }
        if (((Node)n).idToProperties.get(edge) == null) {
            ((Node)n).idToProperties.put(edge, new HashMap());
        }
        ((Map)((Node)n).idToProperties.get(edge)).putAll(properties);
    }

    void setProperty(N node, E edge, K key, V value) {
        Node<N, E, K, V> n = this.idToNode.get(node);
        n.setEdgeProperty(edge, key, value);
    }

    void changeKey(N oldNode, N newNode) {
        Node<N, E, K, V> n = this.idToNode.get(oldNode);
        this.idToNode.remove(oldNode);
        this.idToNode.put(newNode, n);
        this.nodeToId.put(n, newNode);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" start: ").append(this.getStartNode()).append(" end: ");
        Iterator<N> it = this.getEnds().iterator();
        while (it.hasNext()) {
            N end = it.next();
            sb.append(end);
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        sb.append('\n');
        for (N node : this.getNodes()) {
            sb.append(node).append('(');
            Iterator<E> it2 = this.getEdges(node).iterator();
            while (it2.hasNext()) {
                E edge = it2.next();
                N end = this.getNode(node, edge);
                sb.append(this.convert(edge)).append(end);
                if (!it2.hasNext()) continue;
                sb.append(',');
            }
            sb.append(')');
            sb.append('\n');
        }
        for (N node : this.getNodes()) {
            Node<N, E, K, V> n = this.idToNode.get(node);
            sb.append("  ").append(node).append(": ");
            if (((Node)n).properties != null) {
                sb.append(((Node)n).properties);
            }
            sb.append('\n');
            if (((Node)n).idToProperties == null) continue;
            for (Object edge : ((Node)n).idToProperties.keySet()) {
                Map m = (Map)((Node)n).idToProperties.get(edge);
                sb.append("    ").append(this.convert(edge)).append(": ").append(m).append('\n');
            }
        }
        return sb.toString();
    }

    private String convert(E edge) {
        if (STAR.equals(edge)) {
            return ".";
        }
        if (NN.equals(edge)) {
            return "\\n";
        }
        if (NR.equals(edge)) {
            return "\\r";
        }
        if (NT.equals(edge)) {
            return "\\t";
        }
        if (NS.equals(edge)) {
            return "' '";
        }
        return edge.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<N, E, K, V> {
        private Map<K, V> properties;
        private Map<E, Map<K, V>> idToProperties;
        private Map<E, Node<N, E, K, V>> edgeToNode;
        private Map<E, E> edges;

        private Node() {
        }

        V getProperty(K key) {
            if (this.properties == null) {
                return null;
            }
            return this.properties.get(key);
        }

        void setProperty(K key, V value) {
            if (this.properties == null) {
                this.properties = new HashMap();
            }
            this.properties.put(key, value);
        }

        Node<N, E, K, V> getNode(E edge) {
            if (this.edgeToNode == null) {
                return null;
            }
            return this.edgeToNode.get(edge);
        }

        void addEdge(E edge, Node<N, E, K, V> node) {
            if (this.edgeToNode == null) {
                this.edgeToNode = new HashMap<E, Node<N, E, K, V>>();
            }
            if (this.edges == null) {
                this.edges = new HashMap<E, E>();
            }
            this.edgeToNode.put(edge, node);
            this.edges.put(edge, edge);
        }

        E getEdge(E edge) {
            if (this.edges == null) {
                return null;
            }
            return this.edges.get(edge);
        }

        Set<E> edges() {
            if (this.edgeToNode == null) {
                return Collections.emptySet();
            }
            return this.edgeToNode.keySet();
        }

        V getEdgeProperty(E edge, K key) {
            if (this.idToProperties == null) {
                return null;
            }
            if (this.idToProperties.get(edge) == null) {
                return null;
            }
            return this.idToProperties.get(edge).get(key);
        }

        void setEdgeProperty(E edge, K key, V value) {
            Map<K, V> m;
            if (this.idToProperties == null) {
                this.idToProperties = new HashMap<E, Map<K, V>>();
            }
            if ((m = this.idToProperties.get(edge)) == null) {
                m = new HashMap();
                this.idToProperties.put(edge, m);
            }
            m.put(key, value);
        }
    }
}

