/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.languages.TokenInput;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.parser.AnalyserAnalyser;
import org.netbeans.modules.languages.parser.Petra;
import org.netbeans.modules.languages.parser.TokenInputUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LLSyntaxAnalyser {
    private Language language;
    private List<Rule> rules;
    private Map<String, Map> first;
    private Set<String> skip;
    private int traceSteps = -1;
    private boolean cancel = false;
    private boolean printFirst = false;
    private Feature optimiseProperty;
    private boolean removeEmpty = false;
    private boolean removeSimple = false;
    private boolean removeEmptyN = true;
    private boolean removeSimpleN = true;
    private Set<String> empty = new HashSet<String>();
    private Set<String> simple = new HashSet<String>();

    private LLSyntaxAnalyser(Language language) {
        this.language = language;
    }

    public void cancel() {
        this.cancel = true;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public static LLSyntaxAnalyser create(Language language) throws ParseException {
        LLSyntaxAnalyser a = new LLSyntaxAnalyser(language);
        a.rules = language.getRules();
        a.skip = new HashSet<String>(language.getSkipTokenTypes());
        a.skip.add("error");
        a.initTracing();
        a.first = Petra.first2(a.rules);
        boolean hasConflicts = AnalyserAnalyser.printConflicts(a.first, null);
        if (hasConflicts) {
            AnalyserAnalyser.printRules(a.rules, null);
        }
        if (a.printFirst) {
            AnalyserAnalyser.printF(a.first, null);
        }
        AnalyserAnalyser.printUndefinedNTs(a.rules, null);
        return a;
    }

    public static LLSyntaxAnalyser createEmpty(Language language) {
        LLSyntaxAnalyser a = new LLSyntaxAnalyser(language);
        a.rules = Collections.emptyList();
        a.skip = new HashSet<String>(language.getSkipTokenTypes());
        a.first = Collections.emptyMap();
        return a;
    }

    public ASTNode read(TokenInput input, boolean skipErrors) throws ParseException {
        this.cancel = false;
        if (this.rules.isEmpty() || input.eof()) {
            return this.readNoGrammar(input, skipErrors);
        }
        return this.read2(input, skipErrors);
    }

    private ASTNode read2(TokenInput input, boolean skipErrors) throws ParseException {
        Stack<Object> stack = new Stack<Object>();
        Node root = null;
        Node node = null;
        Iterator it = Collections.singleton("S").iterator();
        while (true) {
            int offset = input.getOffset();
            List<ASTItem> whitespaces = this.readWhitespaces(node, input, skipErrors);
            if (node != null) {
                offset = input.getOffset();
            }
            while (!it.hasNext() && !stack.empty()) {
                node = (Node)stack.pop();
                it = (Iterator)stack.pop();
            }
            if (!it.hasNext()) break;
            String current = it.next();
            if (current instanceof String) {
                String nt = current;
                int newRule = this.getRule(nt, input);
                if (newRule == -1) {
                    if (!skipErrors) {
                        throw new ParseException("No rule for " + input.next(1) + " in " + nt + ".", root.createASTNode());
                    }
                    if (input.eof()) {
                        if (node == null) {
                            root = node = new Node("Root", -1, offset, whitespaces);
                        }
                        this.createErrorNode(node, input.getOffset());
                        return root.createASTNode();
                    }
                    this.createErrorNode(node, input.getOffset()).addItem(this.readEmbeddings(input.read(), skipErrors));
                    continue;
                }
                Rule rule = this.rules.get(newRule);
                Feature parse = this.language.getFeature("PARSE", rule.getNT());
                if (parse != null) {
                    stack.push(it);
                    stack.push(node);
                    it = Collections.EMPTY_LIST.iterator();
                    ASTNode nast = (ASTNode)parse.getValue(new Object[]{input, stack});
                    if (nast == null) continue;
                    node.addItem(nast);
                    continue;
                }
                if (node == null || it.hasNext() || !nt.equals(node.nt)) {
                    if (nt.indexOf(36) > 0 || nt.indexOf(35) > 0) {
                        stack.push(it);
                        stack.push(node);
                    } else {
                        Node nnode = new Node(rule.getNT(), newRule, offset, whitespaces);
                        if (node != null) {
                            node.addNode(nnode);
                            stack.push(it);
                            stack.push(node);
                        } else {
                            root = nnode;
                        }
                        node = nnode;
                    }
                }
                it = rule.getRight().iterator();
                continue;
            }
            ASTToken token = (ASTToken)((Object)current);
            if (input.eof()) {
                if (!skipErrors) {
                    throw new ParseException("Unexpected end of file.", root.createASTNode());
                }
                this.createErrorNode(node, input.getOffset());
                return root.createASTNode();
            }
            if (!LLSyntaxAnalyser.isCompatible(token, input.next(1))) {
                if (!skipErrors) {
                    throw new ParseException("Unexpected token " + input.next(1) + ". Expecting " + token, root.createASTNode());
                }
                this.createErrorNode(node, input.getOffset()).addItem(this.readEmbeddings(input.read(), skipErrors));
                continue;
            }
            node.addItem(this.readEmbeddings(input.read(), skipErrors));
        }
        if (!skipErrors && !input.eof()) {
            throw new ParseException("Unexpected token " + input.next(1) + ".", root.createASTNode());
        }
        while (!input.eof()) {
            this.createErrorNode(node, input.getOffset()).addItem(this.readEmbeddings(input.read(), skipErrors));
        }
        return root.createASTNode();
    }

    private static boolean isCompatible(ASTToken t1, ASTToken t2) {
        if (t1.getType() == null) {
            return t1.getIdentifier().equals(t2.getIdentifier());
        }
        if (t1.getIdentifier() == null) {
            return t1.getType().equals(t2.getType());
        }
        return t1.getType().equals(t2.getType()) && t1.getIdentifier().equals(t2.getIdentifier());
    }

    private List<ASTItem> readWhitespaces(Node node, TokenInput input, boolean skipErrors) throws ParseException {
        ArrayList<ASTItem> result = null;
        while (!input.eof() && this.skip.contains(input.next(1).getType())) {
            ASTToken token = input.read();
            if (node != null) {
                node.addItem(this.readEmbeddings(token, skipErrors));
                continue;
            }
            if (result == null) {
                result = new ArrayList<ASTItem>();
            }
            result.add(this.readEmbeddings(token, skipErrors));
        }
        return result;
    }

    private ASTItem readEmbeddings(ASTToken token, boolean skipErrors) throws ParseException {
        List<ASTItem> children = token.getChildren();
        if (children.isEmpty()) {
            return token;
        }
        TokenInput in = TokenInputUtils.create(children);
        try {
            ASTNode newRoot;
            String process_embedded;
            Language language = LanguagesManager.getDefault().getLanguage(children.get(0).getMimeType());
            ASTNode root = language.getAnalyser().read(in, skipErrors);
            Feature astProperties = language.getFeature("AST");
            if (astProperties != null && ((process_embedded = (String)astProperties.getValue("process_embedded")) == null || Boolean.valueOf(process_embedded).booleanValue()) && (newRoot = (ASTNode)astProperties.getValue("process", SyntaxContext.create(null, ASTPath.create(root)))) != null) {
                root = newRoot;
            }
            return ASTToken.create(token.getMimeType(), token.getType(), token.getIdentifier(), token.getOffset(), token.getLength(), Collections.singletonList(root));
        }
        catch (LanguageDefinitionNotFoundException ex) {
            return this.readNoGrammar(in, skipErrors);
        }
    }

    private ASTNode readNoGrammar(TokenInput input, boolean skipErrors) throws ParseException {
        Node root = new Node("S", -1, input.getIndex(), null);
        while (!input.eof()) {
            ASTToken token = input.read();
            root.addItem(this.readEmbeddings(token, skipErrors));
        }
        return root.createASTNode();
    }

    private Node createErrorNode(Node parentNode, int offset) {
        Object possibleErrorNode;
        List<Object> l;
        if (parentNode != null && (l = parentNode.children) != null && l.size() > 0 && (possibleErrorNode = l.get(l.size() - 1)) instanceof Node && ((Node)possibleErrorNode).nt.equals("ERROR")) {
            return (Node)possibleErrorNode;
        }
        Node errorNode = new Node("ERROR", -2, offset, null);
        if (parentNode != null) {
            parentNode.addNode(errorNode);
        }
        return errorNode;
    }

    private int getRule(String nt, TokenInput input) {
        Map m = this.first.get(nt);
        if (m == null) {
            return -1;
        }
        int i = 1;
        while (true) {
            ASTToken token;
            if ((token = input.next(i)) == null) {
                Set result = (Set)m.get("#");
                if (result == null || result.size() > 1) {
                    return -1;
                }
                return (Integer)result.iterator().next();
            }
            T t = new T(token);
            Map r = (Map)m.get(t);
            if (r == null) {
                t.type = null;
                r = (Map)m.get(t);
            }
            if (r == null) {
                t.type = token.getType();
                t.identifier = null;
                r = (Map)m.get(t);
            }
            if (r == null) {
                Set s = (Set)m.get("#");
                if (s == null) {
                    s = (Set)m.get("&");
                }
                if (s == null) {
                    System.out.println("No way! " + nt + " : " + input.next(1) + " " + input.next(2));
                    return -1;
                }
                if (s.size() > 1) {
                    System.out.println("Too many choices! " + nt + " : " + input.next(1) + " " + input.next(2) + ":" + input);
                    return -1;
                }
                return (Integer)s.iterator().next();
            }
            m = r;
            ++i;
        }
    }

    private void initTracing() {
        Feature properties = this.language.getFeature("PROPERTIES");
        if (properties == null) {
            return;
        }
        try {
            this.traceSteps = Integer.parseInt((String)properties.getValue("traceSteps"));
        }
        catch (NumberFormatException ex) {
            this.traceSteps = -2;
        }
        if (properties.getBoolean("printRules", false)) {
            AnalyserAnalyser.printRules(this.rules, null);
        }
        this.printFirst = properties.getBoolean("printFirst", false);
    }

    private boolean removeNT(Node n) {
        if (this.optimiseProperty == null) {
            Feature properties = this.language.getFeature("PROPERTIES");
            this.optimiseProperty = this.language.getFeature("AST");
            if (this.optimiseProperty != null) {
                StringTokenizer st;
                String s = (String)this.optimiseProperty.getValue("removeEmpty");
                if (s != null) {
                    if (s.startsWith("!")) {
                        this.removeEmptyN = false;
                        s = s.substring(1);
                    }
                    this.removeEmpty = "true".equals(s);
                    if (!"false".equals(s)) {
                        st = new StringTokenizer(s, ",");
                        while (st.hasMoreTokens()) {
                            this.empty.add(st.nextToken());
                        }
                    }
                }
                if ((s = (String)this.optimiseProperty.getValue("removeSimple")) != null) {
                    if (s.startsWith("!")) {
                        this.removeSimpleN = false;
                        s = s.substring(1);
                    }
                    this.removeSimple = "true".equals(s);
                    if (!"false".equals(s)) {
                        st = new StringTokenizer(s, ",");
                        while (st.hasMoreTokens()) {
                            this.simple.add(st.nextToken());
                        }
                    }
                }
            }
        }
        if (n.children == null) {
            return this.removeEmpty || this.removeEmptyN == this.empty.contains(n.nt);
        }
        return this.removeSimple || this.removeSimpleN == this.simple.contains(n.nt);
    }

    private class Node {
        String nt;
        int rule;
        int offset;
        List<Object> children;

        Node(String nt, int rule, int offset, List children) {
            this.nt = nt;
            this.rule = rule;
            this.offset = offset;
            if (children != null) {
                for (Object o : children) {
                    if (o instanceof ASTItem) {
                        this.addItem((ASTItem)o);
                        continue;
                    }
                    this.addNode((Node)o);
                }
            }
        }

        void addNode(Node n) {
            if (n == null) {
                throw new NullPointerException();
            }
            if (this.children == null) {
                this.children = new ArrayList<Object>();
            }
            this.children.add(n);
        }

        void addItem(ASTItem item) {
            if (item == null) {
                throw new NullPointerException();
            }
            if (this.children == null) {
                this.children = new ArrayList<Object>();
            }
            this.children.add(item);
        }

        void replace(ASTNode n1, Node n2) {
            if (n1 == null) {
                throw new NullPointerException();
            }
            int k = this.children.size();
            for (int i = 0; i < k; ++i) {
                Object o = this.children.get(i);
                if (!n2.equals(o)) continue;
                this.children.set(i, n1);
                return;
            }
            throw new IllegalStateException();
        }

        private int getEndOffset() {
            if (this.children == null) {
                return this.offset;
            }
            if (this.children.isEmpty()) {
                return this.offset;
            }
            Object l = this.children.get(this.children.size() - 1);
            if (l instanceof ASTToken) {
                return ((ASTToken)l).getOffset() + ((ASTToken)l).getLength();
            }
            if (l instanceof Node) {
                return ((Node)l).getEndOffset();
            }
            return ((ASTNode)l).getEndOffset();
        }

        ASTNode createASTNode() {
            ArrayList<ASTItem> l = new ArrayList<ASTItem>();
            if (this.children == null) {
                if (LLSyntaxAnalyser.this.removeNT(this)) {
                    return null;
                }
            } else {
                if (this.children.size() == 1 && this.children.get(0) instanceof Node && LLSyntaxAnalyser.this.removeNT(this)) {
                    return ((Node)this.children.get(0)).createASTNode();
                }
                for (Object o : this.children) {
                    if (o instanceof Node) {
                        ASTNode nn = ((Node)o).createASTNode();
                        if (nn == null) continue;
                        l.add(nn);
                        continue;
                    }
                    l.add((ASTItem)o);
                }
            }
            return ASTNode.create(LLSyntaxAnalyser.this.language.getMimeType(), this.nt, l, this.offset);
        }

        public String toString() {
            return "LLSyntaxAnalyser$Node " + this.nt;
        }
    }

    public static class Rule {
        private String nt;
        private List right;
        private String toString = null;

        private Rule() {
        }

        public static Rule create(String nt, List right) {
            Rule r = new Rule();
            r.nt = nt;
            r.right = right;
            return r;
        }

        public String getNT() {
            return this.nt;
        }

        public List getRight() {
            return this.right;
        }

        public String toString() {
            if (this.toString == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("Rule ").append(this.nt).append(" = ");
                int i = 0;
                int k = this.right.size();
                if (i < k) {
                    sb.append(this.right.get(i++));
                }
                while (i < k) {
                    sb.append(' ').append(this.right.get(i++));
                }
                this.toString = sb.toString();
            }
            return this.toString;
        }
    }

    public static class T {
        String type;
        String identifier;

        T(ASTToken t) {
            this.type = t.getType();
            this.identifier = t.getIdentifier();
            if (this.type == null && this.identifier == null) {
                System.out.println("null null!!!");
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof T)) {
                return false;
            }
            return !(((T)o).type != null && !((T)o).type.equals(this.type) || ((T)o).identifier != null && !((T)o).identifier.equals(this.identifier));
        }

        public int hashCode() {
            return this.type == null ? -1 : this.type.hashCode() * (this.identifier == null ? -1 : this.identifier.hashCode());
        }

        public String toString() {
            if (this.type == null) {
                return "\"" + this.identifier + "\"";
            }
            if (this.identifier == null) {
                return "<" + this.type + ">";
            }
            return "[" + this.type + "," + this.identifier + "]";
        }
    }
}

