/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.CharInput;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.parser.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    public static final String DEFAULT_STATE = "DEFAULT";
    private Map<Integer, Pattern> stateToPattern = new HashMap<Integer, Pattern>();
    private Map<String, Integer> nameToState = new HashMap<String, Integer>();
    private Map<Integer, String> stateToName = new HashMap<Integer, String>();
    private int counter = 1;
    private Map<String, Pattern> patterns;

    private Parser() {
        this.nameToState.put(DEFAULT_STATE, -1);
        this.stateToName.put(-1, DEFAULT_STATE);
        this.patterns = new HashMap<String, Pattern>();
    }

    public static Parser create(List<Language.TokenType> rules) {
        Parser p = new Parser();
        for (Language.TokenType r : rules) {
            p.add(r);
        }
        return p;
    }

    private void add(Language.TokenType tt) {
        if (tt.getPattern() == null) {
            return;
        }
        String startState = tt.getStartState();
        if (startState == null) {
            startState = DEFAULT_STATE;
        }
        int state = 0;
        if (this.nameToState.containsKey(startState)) {
            state = this.nameToState.get(startState);
        } else {
            state = this.counter++;
            this.nameToState.put(startState, state);
            this.stateToName.put(state, startState);
        }
        Pattern pattern = tt.getPattern();
        pattern.mark(tt.getPriority(), tt);
        if (this.stateToPattern.containsKey(state)) {
            this.stateToPattern.put(state, this.stateToPattern.get(state).merge(pattern));
        } else {
            this.stateToPattern.put(state, pattern);
        }
    }

    public ASTToken read(Cookie cookie, CharInput input, String mimeType) {
        if (input.eof()) {
            return null;
        }
        int originalIndex = input.getIndex();
        Pattern pattern = this.stateToPattern.get(cookie.getState());
        if (pattern == null) {
            return null;
        }
        Language.TokenType tokenType = (Language.TokenType)pattern.read(input);
        if (tokenType == null) {
            return null;
        }
        cookie.setProperties(tokenType.getProperties());
        String endState = tokenType.getEndState();
        int state = -1;
        if (endState != null) {
            state = this.getState(endState);
        }
        cookie.setState(state);
        return ASTToken.create(mimeType, tokenType.getType(), input.getString(originalIndex, input.getIndex()), originalIndex);
    }

    public int getState(String stateName) {
        Integer i = this.nameToState.get(stateName);
        if (i == null) {
            throw new IllegalArgumentException("Unknown lexer state: " + stateName);
        }
        return i;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String state : this.patterns.keySet()) {
            sb.append(state).append(":").append(this.patterns.get(state));
        }
        return sb.toString();
    }

    public static interface Cookie {
        public int getState();

        public void setState(int var1);

        public void setProperties(Feature var1);
    }
}

