/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.CharInput;
import org.netbeans.api.languages.TokenInput;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.parser.Parser;

public abstract class TokenInputUtils {
    public static TokenInput create(String mimeType, Parser parser, CharInput input, Set skip) {
        return new TokenInputImpl(new TokenReader(mimeType, parser, input, skip), input);
    }

    public static TokenInput create(ASTToken[] array) {
        return new ArrayInput(array);
    }

    public static TokenInput create(List list) {
        return new ListInput(list);
    }

    private static class ArrayInput
    extends TokenInput {
        private ASTToken[] array;
        private int index = 0;
        private int length;

        private ArrayInput(ASTToken[] array) {
            this.array = array;
            this.length = array.length;
        }

        public ASTToken read() {
            if (this.index < this.length) {
                return this.array[this.index++];
            }
            return null;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public int getOffset() {
            ASTToken t = null;
            if (this.eof()) {
                if (this.getIndex() == 0) {
                    return 0;
                }
                t = this.array[this.array.length - 1];
                return t.getOffset() + t.getLength();
            }
            t = this.next(1);
            return t.getOffset();
        }

        public boolean eof() {
            return this.index >= this.length;
        }

        public ASTToken next(int i) {
            if (this.index + i - 1 < this.length) {
                return this.array[this.index + i - 1];
            }
            return null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int i = this.index;
            for (int j = 0; j < 10 && i < this.length; ++i, ++j) {
                sb.append(this.array[i]).append(" ");
            }
            return sb.toString();
        }
    }

    private static class ListInput
    extends TokenInput {
        private List list;
        private int index = 0;
        private int length;

        private ListInput(List list) {
            this.list = list;
            this.length = list.size();
        }

        public ASTToken read() {
            if (this.index < this.length) {
                return (ASTToken)this.list.get(this.index++);
            }
            return null;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public int getOffset() {
            ASTToken t = null;
            if (this.eof()) {
                if (this.getIndex() == 0) {
                    return 0;
                }
                t = (ASTToken)this.list.get(this.list.size() - 1);
                return t.getOffset() + t.getLength();
            }
            t = this.next(1);
            return t.getOffset();
        }

        public boolean eof() {
            return this.index >= this.length;
        }

        public ASTToken next(int i) {
            if (this.index + i - 1 < this.length) {
                return (ASTToken)this.list.get(this.index + i - 1);
            }
            return null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int i = this.index;
            for (int j = 0; j < 10 && i < this.length; ++i, ++j) {
                sb.append(this.list.get(i)).append(" ");
            }
            return sb.toString();
        }
    }

    private static class TokenInputImpl
    extends TokenInput {
        private TokenReader tokenReader;
        private List<ASTToken> tokens = new ArrayList<ASTToken>();
        private int index = 0;
        private CharInput input;

        TokenInputImpl(TokenReader tokenReader, CharInput input) {
            this.input = input;
            this.tokenReader = tokenReader;
        }

        public ASTToken next(int i) {
            while (this.index + i - 1 >= this.tokens.size()) {
                this.tokens.add(this.tokenReader.readToken(this.input));
            }
            return this.tokens.get(this.index + i - 1);
        }

        public boolean eof() {
            return this.next(1) == null;
        }

        public int getIndex() {
            return this.index;
        }

        public int getOffset() {
            ASTToken t = null;
            if (this.eof()) {
                if (this.getIndex() == 0) {
                    return 0;
                }
                int i = this.tokens.size() - 1;
                while ((t = this.tokens.get(i--)) == null && i > 0) {
                }
                if (t == null) {
                    return 0;
                }
                return t.getOffset() + t.getLength();
            }
            t = this.next(1);
            return t.getOffset();
        }

        public ASTToken read() {
            ASTToken t = this.next(1);
            if (t != null) {
                ++this.index;
            }
            return t;
        }

        public void setIndex(int index) {
            if (index > this.tokens.size()) {
                throw new IndexOutOfBoundsException();
            }
            this.index = index;
        }

        public String getString(int from) {
            throw new InternalError();
        }

        public String toString() {
            return this.input.toString();
        }
    }

    private static class TokenReader {
        private String mimeType;
        private Parser parser;
        private CharInput input;
        private Set skip;
        private int state = -1;
        private Parser.Cookie cookie = new MyCookie();
        private ASTToken next;

        private TokenReader(String mimeType, Parser parser, CharInput input, Set skip) {
            this.mimeType = mimeType;
            this.parser = parser;
            this.input = input;
            this.skip = skip;
        }

        public ASTToken nextToken(CharInput input) {
            if (this.next == null) {
                this.next = this.readToken(input);
            }
            return this.next;
        }

        public ASTToken readToken(CharInput input) {
            if (this.next != null) {
                ASTToken p = this.next;
                this.next = null;
                return p;
            }
            ASTToken token = null;
            do {
                int start = input.getIndex();
                token = this.parser.read(this.cookie, input, this.mimeType);
                if (token != null) continue;
                return null;
            } while (this.skip.contains(token.getType()));
            return token;
        }

        private class MyCookie
        implements Parser.Cookie {
            private MyCookie() {
            }

            public int getState() {
                return TokenReader.this.state;
            }

            public void setState(int state) {
                TokenReader.this.state = state;
            }

            public void setProperties(Feature tokenProperties) {
            }
        }
    }
}

