/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.project.classpath;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.java.project.classpath.ProjectClassPathModifierAccessor;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.java.project.classpath.ProjectClassPathModifierImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class ProjectClassPathModifier {
    private ProjectClassPathModifier() {
    }

    public static boolean addLibraries(Library[] libraries, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible != null) {
            if (extensible.pcmi != null) {
                assert (extensible.sg != null);
                assert (extensible.classPathType != null);
                return ProjectClassPathModifierAccessor.INSTANCE.addLibraries(libraries, extensible.pcmi, extensible.sg, extensible.classPathType);
            }
            if (extensible.pcpe != null) {
                boolean result = false;
                for (int i = 0; i < libraries.length; ++i) {
                    result |= extensible.pcpe.addLibrary(libraries[i]);
                }
                return result;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static boolean removeLibraries(Library[] libraries, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible != null && extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.removeLibraries(libraries, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        throw new UnsupportedOperationException();
    }

    public static boolean addRoots(URL[] classPathRoots, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible != null) {
            if (extensible.pcmi != null) {
                assert (extensible.sg != null);
                assert (extensible.classPathType != null);
                return ProjectClassPathModifierAccessor.INSTANCE.addRoots(classPathRoots, extensible.pcmi, extensible.sg, extensible.classPathType);
            }
            if (extensible.pcpe != null) {
                boolean result = false;
                for (int i = 0; i < classPathRoots.length; ++i) {
                    FileObject fo;
                    URL urlToAdd = classPathRoots[i];
                    if ("jar".equals(urlToAdd.getProtocol())) {
                        urlToAdd = FileUtil.getArchiveFile((URL)urlToAdd);
                    }
                    if ((fo = URLMapper.findFileObject((URL)urlToAdd)) == null) {
                        throw new UnsupportedOperationException("Adding of a non existent root is not supported by project.");
                    }
                    result |= extensible.pcpe.addArchiveFile(fo);
                }
                return result;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static boolean removeRoots(URL[] classPathRoots, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible != null && extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.removeRoots(classPathRoots, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        throw new UnsupportedOperationException();
    }

    public static boolean addAntArtifacts(AntArtifact[] artifacts, URI[] artifactElements, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible != null) {
            assert (artifacts.length == artifactElements.length);
            if (extensible.pcmi != null) {
                assert (extensible.sg != null);
                assert (extensible.classPathType != null);
                return ProjectClassPathModifierAccessor.INSTANCE.addAntArtifacts(artifacts, artifactElements, extensible.pcmi, extensible.sg, extensible.classPathType);
            }
            if (extensible.pcpe != null) {
                boolean result = false;
                for (int i = 0; i < artifacts.length; ++i) {
                    result |= extensible.pcpe.addAntArtifact(artifacts[i], artifactElements[i]);
                }
                return result;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static boolean removeAntArtifacts(AntArtifact[] artifacts, URI[] artifactElements, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible != null && extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.removeAntArtifacts(artifacts, artifactElements, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        throw new UnsupportedOperationException();
    }

    private static Extensible findExtensible(FileObject fo, String classPathType) {
        ProjectClassPathExtender pe;
        assert (fo != null);
        assert (classPathType != null);
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            return null;
        }
        ProjectClassPathModifierImplementation pm = (ProjectClassPathModifierImplementation)project.getLookup().lookup(ProjectClassPathModifierImplementation.class);
        if (pm != null) {
            SourceGroup[] sgs = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleSourceGroups(pm);
            assert (sgs != null) : "Class: " + pm.getClass() + " returned null as source groups.";
            for (SourceGroup sg : sgs) {
                if (fo != sg.getRootFolder() && !FileUtil.isParentOf((FileObject)sg.getRootFolder(), (FileObject)fo) || !sg.contains(fo)) continue;
                String[] types = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleClassPathTypes(pm, sg);
                assert (types != null) : "Class: " + pm.getClass() + " returned null as classpath types.";
                for (String type : types) {
                    if (!classPathType.equals(type)) continue;
                    return new Extensible(pm, sg, type);
                }
            }
        } else if (classPathType.equals("classpath/compile") && (pe = (ProjectClassPathExtender)project.getLookup().lookup(ProjectClassPathExtender.class)) != null) {
            return new Extensible(pe);
        }
        return null;
    }

    private static final class Extensible {
        private final String classPathType;
        private final SourceGroup sg;
        private final ProjectClassPathModifierImplementation pcmi;
        private final ProjectClassPathExtender pcpe;

        private Extensible(ProjectClassPathModifierImplementation pcmi, SourceGroup sg, String classPathType) {
            assert (pcmi != null);
            assert (sg != null);
            assert (classPathType != null);
            this.pcmi = pcmi;
            this.sg = sg;
            this.classPathType = classPathType;
            this.pcpe = null;
        }

        private Extensible(ProjectClassPathExtender pcpe) {
            assert (pcpe != null);
            this.pcpe = pcpe;
            this.pcmi = null;
            this.sg = null;
            this.classPathType = "classpath/compile";
        }
    }
}

