/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.project.BrokenReferencesCustomizer;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokenReferencesModel
extends AbstractListModel {
    private String[] props;
    private String[] platformsProps;
    private AntProjectHelper helper;
    private ReferenceHelper resolver;
    private List<OneReference> references;
    public static final int REF_TYPE_PROJECT = 1;
    public static final int REF_TYPE_FILE = 2;
    public static final int REF_TYPE_LIBRARY = 3;
    public static final int REF_TYPE_PLATFORM = 4;
    public static final int REF_TYPE_LIBRARY_CONTENT = 5;

    public BrokenReferencesModel(AntProjectHelper helper, ReferenceHelper resolver, String[] props, String[] platformsProps) {
        this.props = props;
        this.platformsProps = platformsProps;
        this.resolver = resolver;
        this.helper = helper;
        this.references = new ArrayList<OneReference>();
        this.refresh();
    }

    public void refresh() {
        LinkedHashSet<OneReference> all = new LinkedHashSet<OneReference>();
        Set<OneReference> s = BrokenReferencesModel.getReferences(this.helper, this.helper.getStandardPropertyEvaluator(), this.props, false);
        all.addAll(s);
        s = BrokenReferencesModel.getPlatforms(this.helper.getStandardPropertyEvaluator(), this.platformsProps, false);
        all.addAll(s);
        BrokenReferencesModel.updateReferencesList(this.references, all);
        this.fireContentsChanged(this, 0, this.getSize());
    }

    @Override
    public Object getElementAt(int index) {
        String bundleID;
        OneReference or = this.getOneReference(index);
        switch (or.type) {
            case 3: 
            case 5: {
                bundleID = "LBL_BrokenLinksCustomizer_BrokenLibrary";
                break;
            }
            case 1: {
                bundleID = "LBL_BrokenLinksCustomizer_BrokenProjectReference";
                break;
            }
            case 2: {
                bundleID = "LBL_BrokenLinksCustomizer_BrokenFileReference";
                break;
            }
            case 4: {
                bundleID = "LBL_BrokenLinksCustomizer_BrokenPlatform";
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        return NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)bundleID, (Object)or.getDisplayID());
    }

    public String getDesciption(int index) {
        String bundleID;
        OneReference or = this.getOneReference(index);
        switch (or.type) {
            case 3: {
                bundleID = "LBL_BrokenLinksCustomizer_BrokenLibraryDesc";
                break;
            }
            case 5: {
                bundleID = "LBL_BrokenLinksCustomizer_BrokenLibraryContentDesc";
                break;
            }
            case 1: {
                bundleID = "LBL_BrokenLinksCustomizer_BrokenProjectReferenceDesc";
                break;
            }
            case 2: {
                bundleID = "LBL_BrokenLinksCustomizer_BrokenFileReferenceDesc";
                break;
            }
            case 4: {
                bundleID = "LBL_BrokenLinksCustomizer_BrokenPlatformDesc";
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        return NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)bundleID, (Object)or.getDisplayID());
    }

    public OneReference getOneReference(int index) {
        assert (index >= 0 && index < this.references.size());
        return this.references.get(index);
    }

    public boolean isBroken(int index) {
        return this.references.get(index).broken;
    }

    @Override
    public int getSize() {
        return this.references.size();
    }

    public static boolean isBroken(AntProjectHelper helper, PropertyEvaluator evaluator, String[] props, String[] platformsProps) {
        Set<OneReference> s = BrokenReferencesModel.getReferences(helper, evaluator, props, true);
        if (s.size() > 0) {
            return true;
        }
        s = BrokenReferencesModel.getPlatforms(evaluator, platformsProps, true);
        return s.size() > 0;
    }

    private static Set<OneReference> getReferences(AntProjectHelper helper, PropertyEvaluator evaluator, String[] ps, boolean abortAfterFirstProblem) {
        LinkedHashSet<OneReference> set = new LinkedHashSet<OneReference>();
        StringBuffer all = new StringBuffer();
        for (String p : ps) {
            String[] vals;
            String prop = evaluator.getProperty(p);
            if (prop == null) continue;
            for (String v : vals = PropertyUtils.tokenizePath((String)prop)) {
                if (!(v.startsWith("${file.reference.") || v.startsWith("${project.") || v.startsWith("${libs."))) {
                    all.append(v);
                    continue;
                }
                if (v.startsWith("${project.")) {
                    String val = v.substring(2, v.indexOf(125));
                    set.add(new OneReference(1, val, true));
                } else {
                    int type = 3;
                    if (v.startsWith("${file.reference")) {
                        type = 2;
                    }
                    String val = v.substring(2, v.length() - 1);
                    set.add(new OneReference(type, val, true));
                }
                if (abortAfterFirstProblem) break;
            }
            if (set.size() > 0 && abortAfterFirstProblem) break;
        }
        for (Map.Entry entry : evaluator.getProperties().entrySet()) {
            File f;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.startsWith("project.")) {
                f = BrokenReferencesModel.getFile(helper, evaluator, value);
                if (f.exists() || all.indexOf(value) == -1) continue;
                set.add(new OneReference(1, key, true));
                continue;
            }
            if (!key.startsWith("file.reference") || (f = BrokenReferencesModel.getFile(helper, evaluator, value)).exists() || all.indexOf(value) == -1) continue;
            set.add(new OneReference(2, key, true));
        }
        HashSet<String> usedLibraries = new HashSet<String>();
        Pattern libPattern = Pattern.compile("\\$\\{(lib.[-._a-zA-Z0-9]+.classpath)\\}");
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        for (String p : ps) {
            String propertyValue = ep.getProperty(p);
            if (propertyValue == null) continue;
            for (String v : PropertyUtils.tokenizePath((String)propertyValue)) {
                Matcher m = libPattern.matcher(v);
                if (!m.matches()) continue;
                usedLibraries.add(m.group(1));
            }
        }
        for (String libraryRef : usedLibraries) {
            String libraryName = libraryRef.substring(5, libraryRef.length() - 10);
            Library lib = LibraryManager.getDefault().getLibrary(libraryName);
            if (lib == null) {
                set.add(new OneReference(3, libraryRef, true));
                continue;
            }
            for (URL url : lib.getContent("classpath")) {
                if ("jar".equals(url.getProtocol())) {
                    url = FileUtil.getArchiveFile((URL)url);
                }
                if (URLMapper.findFileObject((URL)url) != null) continue;
                set.add(new OneReference(5, libraryRef, true));
            }
        }
        return set;
    }

    private static File getFile(AntProjectHelper helper, PropertyEvaluator evaluator, String name) {
        if (helper != null) {
            return new File(helper.resolvePath(name));
        }
        File f = new File(name);
        if (!f.exists()) {
            String basedir = evaluator.getProperty("basedir");
            assert (basedir != null);
            f = new File(new File(basedir), name);
        }
        return f;
    }

    private static Set<OneReference> getPlatforms(PropertyEvaluator evaluator, String[] platformsProps, boolean abortAfterFirstProblem) {
        LinkedHashSet<OneReference> set = new LinkedHashSet<OneReference>();
        for (String pprop : platformsProps) {
            String prop = evaluator.getProperty(pprop);
            if (prop == null) continue;
            if (!BrokenReferencesModel.existPlatform(prop)) {
                if (evaluator.getProperty(pprop + ".description") != null) {
                    prop = evaluator.getProperty(pprop + ".description");
                }
                set.add(new OneReference(4, prop, true));
            }
            if (set.size() > 0 && abortAfterFirstProblem) break;
        }
        return set;
    }

    private static void updateReferencesList(List<OneReference> oldBroken, Set<OneReference> newBroken) {
        for (OneReference or : oldBroken) {
            if (newBroken.contains(or)) {
                or.broken = true;
                continue;
            }
            or.broken = false;
        }
        for (OneReference or : newBroken) {
            if (oldBroken.contains(or)) continue;
            oldBroken.add(or);
        }
    }

    private static boolean existPlatform(String platform) {
        if (platform.equals("default_platform")) {
            return true;
        }
        for (JavaPlatform plat : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            if (!platform.equals(plat.getProperties().get("platform.ant.name")) || plat.getInstallFolders().size() <= 0) continue;
            return true;
        }
        return false;
    }

    void updateReference(int index, File file) {
        this.updateReference0(index, file);
        OneReference or = this.getOneReference(index);
        if (or.getType() != 2) {
            return;
        }
        for (int i = 0; i < this.getSize(); ++i) {
            File f;
            if (!this.isBroken(i) || i == index || (or = this.getOneReference(i)).getType() != 2 || !(f = new File(file.getParentFile(), or.getDisplayID())).exists()) continue;
            this.updateReference0(i, f);
        }
    }

    private void updateReference0(int index, File file) {
        Project p;
        final String reference = this.getOneReference(index).ID;
        FileObject myProjDirFO = this.helper.getProjectDirectory();
        File myProjDir = FileUtil.toFile((FileObject)myProjDirFO);
        String propertiesFile = "nbproject/private/private.properties";
        final String path = file.getAbsolutePath();
        try {
            p = ProjectManager.getDefault().findProject(myProjDirFO);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(65536, (Throwable)ex);
            p = null;
        }
        final Project proj = p;
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                EditableProperties props = BrokenReferencesModel.this.helper.getProperties("nbproject/private/private.properties");
                if (!path.equals(props.getProperty(reference))) {
                    props.setProperty(reference, path);
                    BrokenReferencesModel.this.helper.putProperties("nbproject/private/private.properties", props);
                }
                if ((props = BrokenReferencesModel.this.helper.getProperties("nbproject/project.properties")).containsKey((Object)reference)) {
                    props.remove((Object)reference);
                    BrokenReferencesModel.this.helper.putProperties("nbproject/project.properties", props);
                }
                if (proj != null) {
                    try {
                        ProjectManager.getDefault().saveProject(proj);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify(16, (Throwable)ex);
                    }
                }
            }
        });
    }

    public static class OneReference {
        private int type;
        private boolean broken;
        private String ID;

        public OneReference(int type, String ID, boolean broken) {
            this.type = type;
            this.ID = ID;
            this.broken = broken;
        }

        public int getType() {
            return this.type;
        }

        public String getDisplayID() {
            switch (this.type) {
                case 3: 
                case 5: {
                    return this.ID.substring(5, this.ID.length() - 10);
                }
                case 1: {
                    return this.ID.substring(8);
                }
                case 2: {
                    return this.ID.substring(15);
                }
                case 4: {
                    return this.ID;
                }
            }
            assert (false);
            return this.ID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OneReference)) {
                return false;
            }
            OneReference or = (OneReference)o;
            return this.type == or.type && this.ID.equals(or.ID);
        }

        public int hashCode() {
            int result = 7 * this.type;
            result = 31 * result + this.ID.hashCode();
            return result;
        }
    }
}

