/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

public final class JavaAntLogger
extends AntLogger {
    private static final Pattern STACK_TRACE = Pattern.compile("(?:\t|\\[catch\\] )at ((?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)*)[a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z_$<][a-zA-Z0-9_$>]*\\(([a-zA-Z_$][a-zA-Z0-9_$]*\\.java):([0-9]+)\\)");
    private static final Pattern EXCEPTION_MESSAGE = Pattern.compile("(?:Exception in thread \"(?:main|Main Thread)\" )?(?:(?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)+)([a-zA-Z_$][a-zA-Z0-9_$]*(?:: .+)?)");
    private static final Pattern CLASSPATH_ARGS = Pattern.compile("\r?\n'-classpath'\r?\n'(.*)'\r?\n");
    private static final Pattern JAVA_EXECUTABLE = Pattern.compile("^Executing '(.*)' with arguments:$", 8);
    private static final String[] TASKS_OF_INTEREST = new String[]{"java", "junit", "exec", "nb-run"};
    private static final int[] LEVELS_OF_INTEREST = new int[]{3, 2, 1, 0};

    public boolean interestedInSession(AntSession session) {
        return true;
    }

    public boolean interestedInAllScripts(AntSession session) {
        return true;
    }

    public String[] interestedInTargets(AntSession session) {
        return AntLogger.ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession session) {
        return TASKS_OF_INTEREST;
    }

    public int[] interestedInLogLevels(AntSession session) {
        return LEVELS_OF_INTEREST;
    }

    private SessionData getSessionData(AntSession session) {
        SessionData data = (SessionData)session.getCustomData((AntLogger)this);
        if (data == null) {
            data = new SessionData();
            session.putCustomData((AntLogger)this, (Object)data);
        }
        return data;
    }

    public void messageLogged(AntEvent event) {
        AntSession session = event.getSession();
        int messageLevel = event.getLogLevel();
        int sessionLevel = session.getVerbosity();
        SessionData data = this.getSessionData(session);
        String line = event.getMessage();
        assert (line != null);
        Matcher m = STACK_TRACE.matcher(line);
        if (m.matches()) {
            FileObject source;
            String pkg = m.group(1);
            String filename = m.group(2);
            String resource = pkg.replace('.', '/') + filename;
            int lineNumber = Integer.parseInt(m.group(3));
            for (FileObject root : JavaAntLogger.getCurrentSourceRootsForClasspath(data)) {
                FileObject source2 = root.getFileObject(resource);
                if (source2 == null) continue;
                JavaAntLogger.hyperlink(line, session, event, source2, messageLevel, sessionLevel, data, lineNumber);
                break;
            }
            if (!event.isConsumed() && (source = GlobalPathRegistry.getDefault().findResource(resource)) != null) {
                JavaAntLogger.hyperlink(line, session, event, source, messageLevel, sessionLevel, data, lineNumber);
            }
        } else {
            data.possibleExceptionText = line;
            data.lastExceptionMessage = null;
        }
        if (messageLevel == 3) {
            String executable;
            ClassPath platformSources;
            Matcher m2 = CLASSPATH_ARGS.matcher(line);
            if (m2.find()) {
                String cp = m2.group(1);
                data.setClasspath(cp);
            }
            if ((m2 = JAVA_EXECUTABLE.matcher(line)).find() && (platformSources = this.findPlatformSources(executable = m2.group(1))) != null) {
                data.setPlatformSources(platformSources);
            }
        }
    }

    private ClassPath findPlatformSources(String javaExecutable) {
        for (JavaPlatform p : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            File f;
            FileObject fo = p.findTool("java");
            if (fo == null || !(f = FileUtil.toFile((FileObject)fo)).getAbsolutePath().startsWith(javaExecutable)) continue;
            return p.getSourceFolders();
        }
        return null;
    }

    private static void hyperlink(String line, AntSession session, AntEvent event, FileObject source, int messageLevel, int sessionLevel, SessionData data, int lineNumber) {
        block3: {
            if (messageLevel <= sessionLevel && !event.isConsumed()) {
                event.consume();
                try {
                    session.println(line, true, session.createStandardHyperlink(source.getURL(), JavaAntLogger.guessExceptionMessage(data), lineNumber, -1, -1, -1));
                }
                catch (FileStateInvalidException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)e);
                }
            }
        }
    }

    private static Collection getCurrentSourceRootsForClasspath(SessionData data) {
        if (data.classpath == null) {
            return Collections.EMPTY_SET;
        }
        if (data.classpathSourceRoots == null) {
            data.classpathSourceRoots = new LinkedHashSet<FileObject>();
            StringTokenizer tok = new StringTokenizer(data.classpath, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                URL root;
                URL binroot;
                String binrootS = tok.nextToken();
                File f = FileUtil.normalizeFile((File)new File(binrootS));
                try {
                    binroot = f.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new AssertionError((Object)e);
                }
                if (FileUtil.isArchiveFile((URL)binroot) && (root = FileUtil.getArchiveRoot((URL)binroot)) != null) {
                    binroot = root;
                }
                FileObject[] someRoots = SourceForBinaryQuery.findSourceRoots((URL)binroot).getRoots();
                data.classpathSourceRoots.addAll(Arrays.asList(someRoots));
            }
            if (data.platformSources != null) {
                data.classpathSourceRoots.addAll(Arrays.asList(data.platformSources.getRoots()));
            } else {
                JavaPlatform plat = JavaPlatform.getDefault();
                if (plat != null) {
                    data.classpathSourceRoots.addAll(Arrays.asList(plat.getSourceFolders().getRoots()));
                }
            }
        }
        return data.classpathSourceRoots;
    }

    private static String guessExceptionMessage(SessionData data) {
        if (data.possibleExceptionText != null) {
            if (data.lastExceptionMessage == null) {
                Matcher m = EXCEPTION_MESSAGE.matcher(data.possibleExceptionText);
                if (m.matches()) {
                    data.lastExceptionMessage = m.group(1);
                } else {
                    data.possibleExceptionText = null;
                }
            }
            return data.lastExceptionMessage;
        }
        return null;
    }

    private static final class SessionData {
        public ClassPath platformSources = null;
        public String classpath = null;
        public Collection<FileObject> classpathSourceRoots = null;
        public String possibleExceptionText = null;
        public String lastExceptionMessage = null;

        public void setClasspath(String cp) {
            this.classpath = cp;
            this.classpathSourceRoots = null;
        }

        public void setPlatformSources(ClassPath platformSources) {
            this.platformSources = platformSources;
            this.classpathSourceRoots = null;
        }
    }
}

