/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.spi.java.project.support.ui.IncludeExcludeVisualizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class IncludeExcludeVisualizerPanel
extends JPanel {
    private final IncludeExcludeVisualizer handle;
    private final DocumentListener listener = new DocumentListener(){

        private void changes() {
            IncludeExcludeVisualizerPanel.this.handle.changedPatterns(IncludeExcludeVisualizerPanel.this.includes.getText(), IncludeExcludeVisualizerPanel.this.excludes.getText());
        }

        public void insertUpdate(DocumentEvent e) {
            this.changes();
        }

        public void removeUpdate(DocumentEvent e) {
            this.changes();
        }

        public void changedUpdate(DocumentEvent e) {
        }
    };
    private final DefaultListModel includedListModel = new DefaultListModel();
    private final DefaultListModel excludedListModel = new DefaultListModel();
    private JList excludedList;
    private JLabel excludedListLabel;
    private JScrollPane excludedListPane;
    private JTextField excludes;
    private JLabel excludesLabel;
    private JLabel explanation;
    private JList includedList;
    private JLabel includedListLabel;
    private JScrollPane includedListPane;
    private JTextField includes;
    private JLabel includesLabel;
    private JLabel scanningLabel;

    public IncludeExcludeVisualizerPanel(IncludeExcludeVisualizer handle) {
        this.handle = handle;
        this.initComponents();
        this.includes.getDocument().addDocumentListener(this.listener);
        this.excludes.getDocument().addDocumentListener(this.listener);
        this.includedList.setModel(this.includedListModel);
        this.excludedList.setModel(this.excludedListModel);
    }

    void setFields(String includes, String excludes) {
        assert (EventQueue.isDispatchThread());
        this.includes.getDocument().removeDocumentListener(this.listener);
        this.includes.setText(includes);
        this.includes.getDocument().addDocumentListener(this.listener);
        this.excludes.getDocument().removeDocumentListener(this.listener);
        this.excludes.setText(excludes);
        this.excludes.getDocument().addDocumentListener(this.listener);
    }

    void setFiles(File[] included, File[] excluded, boolean busy) {
        assert (EventQueue.isDispatchThread());
        this.includedListModel.clear();
        for (File f : included) {
            this.includedListModel.addElement(f);
        }
        this.excludedListModel.clear();
        for (File f : excluded) {
            this.excludedListModel.addElement(f);
        }
        this.scanningLabel.setVisible(busy);
    }

    private void initComponents() {
        this.includedListLabel = new JLabel();
        this.includedListPane = new JScrollPane();
        this.includedList = new JList();
        this.excludedListLabel = new JLabel();
        this.excludedListPane = new JScrollPane();
        this.excludedList = new JList();
        this.scanningLabel = new JLabel();
        this.includesLabel = new JLabel();
        this.includes = new JTextField();
        this.excludesLabel = new JLabel();
        this.excludes = new JTextField();
        this.explanation = new JLabel();
        this.includedListLabel.setLabelFor(this.includedList);
        Mnemonics.setLocalizedText((JLabel)this.includedListLabel, (String)NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"IncludeExcludeVisualizerPanel.includedListLabel.text"));
        this.includedListPane.setViewportView(this.includedList);
        this.excludedListLabel.setLabelFor(this.excludedList);
        Mnemonics.setLocalizedText((JLabel)this.excludedListLabel, (String)NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"IncludeExcludeVisualizerPanel.excludedListLabel.text"));
        this.excludedListPane.setViewportView(this.excludedList);
        Mnemonics.setLocalizedText((JLabel)this.scanningLabel, (String)NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"IncludeExcludeVisualizerPanel.scanningLabel.text"));
        this.includesLabel.setLabelFor(this.includes);
        Mnemonics.setLocalizedText((JLabel)this.includesLabel, (String)NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"IncludeExcludeVisualizerPanel.includesLabel.text"));
        this.excludesLabel.setLabelFor(this.excludes);
        Mnemonics.setLocalizedText((JLabel)this.excludesLabel, (String)NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"IncludeExcludeVisualizerPanel.excludesLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.explanation, (String)NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"IncludeExcludeVisualizerPanel.explanation.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.includesLabel).add((Component)this.excludesLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.excludes, -1, 371, Short.MAX_VALUE).add((Component)this.includes, -1, 371, Short.MAX_VALUE))).add((Component)this.scanningLabel).add((Component)this.includedListLabel)).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.excludedListLabel).addContainerGap(361, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.includedListPane, -1, 440, Short.MAX_VALUE).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.explanation, -1, 440, Short.MAX_VALUE).add((Component)this.excludedListPane, -1, 440, Short.MAX_VALUE)).addContainerGap()))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.includesLabel).add((Component)this.includes, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.excludesLabel).add((Component)this.excludes, -2, -1, -2)).addPreferredGap(0).add((Component)this.scanningLabel).addPreferredGap(0).add((Component)this.includedListLabel).addPreferredGap(0).add((Component)this.includedListPane, -2, -1, -2).addPreferredGap(0).add((Component)this.excludedListLabel).addPreferredGap(0).add((Component)this.excludedListPane, -2, 143, -2).addPreferredGap(0).add((Component)this.explanation, -1, 40, Short.MAX_VALUE).addContainerGap()));
    }
}

