/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.xml.xam.AbstractModel;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.spi.ModelAccessProvider;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelFactory<M extends Model> {
    public static final int DELAY_SYNCER = 2000;
    public static final int DELAY_DIRTY = 1000;
    public static final String MODEL_LOADED_PROPERTY = "modelLoaded";
    private WeakHashMap<Object, WeakReference<M>> cachedModels = new WeakHashMap();
    private PropertyChangeSupport propSupport;
    private static List<WeakReference<AbstractModelFactory>> factories = new ArrayList<WeakReference<AbstractModelFactory>>();
    private static RequestProcessor.Task SYNCER = null;

    public AbstractModelFactory() {
        factories.add(new WeakReference<AbstractModelFactory>(this));
        this.propSupport = new PropertyChangeSupport(this);
    }

    protected abstract M createModel(ModelSource var1);

    public M createFreshModel(ModelSource modelSource) {
        M model = this.createModel(modelSource);
        try {
            if (model != null) {
                model.sync();
                this.propSupport.firePropertyChange(MODEL_LOADED_PROPERTY, null, model);
            }
        }
        catch (IOException ioe) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Sync has errors", ioe);
        }
        return model;
    }

    protected Object getKey(ModelSource source) {
        ModelAccessProvider p = this.getEffectiveAccessProvider(source);
        if (p != null) {
            return p.getModelSourceKey(source);
        }
        return (File)source.getLookup().lookup(File.class);
    }

    private ModelAccessProvider getEffectiveAccessProvider(ModelSource ms) {
        ModelAccessProvider p = (ModelAccessProvider)ms.getLookup().lookup(ModelAccessProvider.class);
        return p == null ? AbstractModelFactory.getAccessProvider() : p;
    }

    public static ModelAccessProvider getAccessProvider() {
        return (ModelAccessProvider)Lookup.getDefault().lookup(ModelAccessProvider.class);
    }

    protected synchronized M getModel(ModelSource source) {
        Model<Object> model;
        if (source == null) {
            return null;
        }
        Object key = this.getKey(source);
        assert (key != null);
        WeakReference<M> modelRef = this.cachedModels.get(key);
        Model model2 = model = modelRef == null ? null : (Model)modelRef.get();
        if (model == null && (model = this.createModel(source)) != null) {
            try {
                model.sync();
            }
            catch (IOException ioe) {
                Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Sync has errors", ioe);
            }
            this.cachedModels.put(key, new WeakReference<Model<Object>>(model));
            this.propSupport.firePropertyChange(MODEL_LOADED_PROPERTY, null, model);
        }
        return (M)model;
    }

    private static synchronized List<AbstractModel> getAllModels() {
        ArrayList<AbstractModel> models = new ArrayList<AbstractModel>();
        ArrayList<WeakReference<AbstractModelFactory>> mfactories = new ArrayList<WeakReference<AbstractModelFactory>>(factories);
        for (WeakReference weakReference : mfactories) {
            AbstractModelFactory factory = (AbstractModelFactory)weakReference.get();
            if (factory == null) continue;
            for (Object m : factory.getModels()) {
                if (!(m instanceof AbstractModel)) continue;
                AbstractModel am = (AbstractModel)m;
                models.add(am);
            }
        }
        return models;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<M> getModels() {
        ArrayList<WeakReference<M>> refs;
        AbstractModelFactory abstractModelFactory = this;
        synchronized (abstractModelFactory) {
            refs = new ArrayList<WeakReference<M>>(this.cachedModels.values());
        }
        ArrayList<Model> ret = new ArrayList<Model>();
        for (WeakReference weakReference : refs) {
            Model model;
            if (weakReference == null || (model = (Model)weakReference.get()) == null) continue;
            ret.add(model);
        }
        return ret;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.removePropertyChangeListener(l);
    }

    static {
        if (AbstractModelFactory.getAccessProvider() != null) {
            SYNCER = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        for (AbstractModel model : AbstractModelFactory.getAllModels()) {
                            if (!model.isAutoSyncActive() || model.getAccess().dirtyIntervalMillis() <= 1000L) continue;
                            model.runAutoSync();
                        }
                    }
                    catch (Exception e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "auto-sync", e);
                    }
                    SYNCER.schedule(2000);
                }
            }, 2000);
        }
    }
}

