/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.ValidationResult;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validation {
    private static Collection<Validator> validators;
    private List<Validator.ResultItem> validationResult;
    private List<Model> validatedModels;

    public Validation() {
        this.initialise();
    }

    public void validate(Model model, ValidationType validationType) {
        if (this.validatedModels.contains(model)) {
            return;
        }
        this.validatedModels.add(model);
        for (Validator provider : validators) {
            ValidationResult result = provider.validate(model, this, validationType);
            if (result == null) continue;
            this.validationResult.addAll(result.getValidationResult());
            this.validatedModels.addAll(result.getValidatedModels());
        }
    }

    public List<Validator.ResultItem> getValidationResult() {
        return this.validationResult;
    }

    public List<Model> getValidatedModels() {
        return Collections.unmodifiableList(this.validatedModels);
    }

    private void initialise() {
        this.validationResult = new ArrayList<Validator.ResultItem>();
        this.validatedModels = new ArrayList<Model>();
    }

    private static void lookupProviders() {
        if (validators != null) {
            return;
        }
        validators = new ArrayList<Validator>();
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(Validator.class));
        for (Object obj : result.allInstances()) {
            Validator validator = (Validator)obj;
            validators.add(validator);
        }
    }

    static {
        Validation.lookupProviders();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValidationType {
        COMPLETE,
        PARTIAL;

    }
}

