/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.loaders;

import java.nio.charset.Charset;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class DataObjectEncodingQueryImplementation
extends FileEncodingQueryImplementation {
    private static ThreadLocal<DataFolder> TARGET = new ThreadLocal();

    public static DataFolder enterIgnoreTargetFolder(DataFolder df) {
        DataFolder prev = TARGET.get();
        TARGET.set(df);
        return prev;
    }

    public static void exitIgnoreTargetFolder(DataFolder prev) {
        TARGET.set(prev);
    }

    public Charset getEncoding(FileObject file) {
        assert (file != null);
        DataFolder df = TARGET.get();
        if (df != null && df.getPrimaryFile().equals(file.getParent())) {
            return null;
        }
        try {
            DataObject dobj = DataObject.find(file);
            FileEncodingQueryImplementation impl = (FileEncodingQueryImplementation)dobj.getLookup().lookup(FileEncodingQueryImplementation.class);
            if (impl == null) {
                return null;
            }
            return impl.getEncoding(file);
        }
        catch (DataObjectNotFoundException donf) {
            Exceptions.printStackTrace((Throwable)donf);
            return null;
        }
    }
}

