/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.io.IOException;
import org.openide.actions.NewTemplateAction;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeOperation;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.actions.NodeAction;

public final class SaveAsTemplateAction
extends NodeAction {
    public HelpCtx getHelpCtx() {
        return new HelpCtx(SaveAsTemplateAction.class);
    }

    public String getName() {
        return NbBundle.getMessage(DataObject.class, (String)"SaveAsTemplate");
    }

    @Deprecated
    public String iconResource() {
        return super.iconResource();
    }

    protected boolean surviveFocusChange() {
        return false;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        for (int i = 0; i < activatedNodes.length; ++i) {
            DataObject curCookie = (DataObject)activatedNodes[i].getCookie(DataObject.class);
            if (curCookie != null && curCookie.isCopyAllowed()) continue;
            return false;
        }
        return true;
    }

    protected void performAction(Node[] activatedNodes) {
        Node[] selected;
        FolderNodeAcceptor acceptor = FolderNodeAcceptor.getInstance();
        String title = NbBundle.getMessage(DataObject.class, (String)"Title_SaveAsTemplate");
        String rootTitle = NbBundle.getMessage(DataObject.class, (String)"CTL_SaveAsTemplate");
        Node templatesNode = NewTemplateAction.getTemplateRoot();
        templatesNode.setDisplayName(NbBundle.getMessage(DataObject.class, (String)"CTL_SaveAsTemplate_TemplatesRoot"));
        try {
            selected = NodeOperation.getDefault().select(title, rootTitle, templatesNode, (NodeAcceptor)acceptor, null);
        }
        catch (UserCancelException ex) {
            return;
        }
        DataFolder targetFolder = (DataFolder)selected[0].getCookie(DataFolder.class);
        for (int i = 0; i < activatedNodes.length; ++i) {
            this.createNewTemplate((DataObject)activatedNodes[i].getCookie(DataObject.class), targetFolder);
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    private void createNewTemplate(DataObject source, DataFolder targetFolder) {
        try {
            SaveCookie cookie = source.getCookie(SaveCookie.class);
            if (cookie != null) {
                cookie.save();
            }
            DataObject newTemplate = source.copy(targetFolder);
            newTemplate.setTemplate(true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    static final class FolderNodeAcceptor
    implements NodeAcceptor {
        private static FolderNodeAcceptor instance;

        private FolderNodeAcceptor() {
        }

        public final boolean acceptNodes(Node[] nodes) {
            if (nodes == null || nodes.length != 1) {
                return false;
            }
            return nodes[0].getCookie(DataFolder.class) != null;
        }

        static FolderNodeAcceptor getInstance() {
            if (instance == null) {
                instance = new FolderNodeAcceptor();
            }
            return instance;
        }
    }
}

