/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.TooManyListenersException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import org.openide.awt.AWTTask;
import org.openide.awt.Actions;
import org.openide.awt.ExecBridge;
import org.openide.awt.ToolbarPool;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.InstanceSupport;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Task;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;
import org.openide.util.datatransfer.ExTransferable;

public class Toolbar
extends JToolBar {
    @Deprecated
    public static final int BASIC_HEIGHT = 34;
    static int HEIGHT_TOLERANCE;
    static int TOP;
    static int LEFT;
    static int BOTTOM;
    static int RIGHT;
    static int RESIDUAL_WIDTH;
    private boolean floatable;
    private DnDListener listener;
    private ToolbarMouseListener mouseListener;
    private String displayName;
    private DataFolder backingFolder;
    private Folder processor;
    private static final boolean isMetalLaF;
    private static final boolean isJdk15;
    private static final boolean isJdk16;
    static final long serialVersionUID = 5011742660516204764L;
    private static final int customFontHeightCorrection;
    private static Class synthIconClass;
    private static boolean testExecuted;
    int dropTargetButtonIndex = -1;
    int dragSourceButtonIndex = -1;
    boolean insertBefore = true;
    boolean isDragSourceToolbar = false;
    private static DataFlavor buttonDataFlavor;
    private static DataFlavor actionDataFlavor;
    private DnDSupport dnd;
    private static final Insets emptyInsets;
    private static Boolean isXP;
    private static Map<RenderingHints.Key, Object> hintsMap;

    public Toolbar() {
        this("");
    }

    public Toolbar(String name) {
        this(name, name, false);
    }

    public Toolbar(String name, String displayName) {
        this(name, displayName, false);
    }

    public Toolbar(String name, boolean f) {
        this(name, name, f);
    }

    Toolbar(DataFolder folder, boolean f) {
        this.backingFolder = folder;
        this.initAll(folder.getName(), f);
        this.initDnD();
    }

    private static boolean useSynthIcon() {
        if (!testExecuted) {
            testExecuted = true;
            try {
                synthIconClass = Class.forName("sun.swing.plaf.synth.SynthIcon");
            }
            catch (ClassNotFoundException exc) {
                Logger.getLogger(Toolbar.class.getName()).log(Level.INFO, null, exc);
            }
        }
        return synthIconClass != null;
    }

    private void initDnD() {
        DropTarget dt = new DropTarget(this, this.getDnd());
    }

    DataFolder getFolder() {
        return this.backingFolder;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (-1 != this.dropTargetButtonIndex) {
            this.paintDropGesture(g);
        }
    }

    private void updateDropGesture(DropTargetDragEvent e) {
        Point p = e.getLocation();
        Component c = this.getComponentAt(p);
        int index = this.getComponentIndex(c);
        if (index == 0) {
            this.resetDropGesture();
        } else {
            boolean b;
            boolean bl = b = p.x <= c.getLocation().x + c.getWidth() / 2;
            if (index != this.dropTargetButtonIndex || b != this.insertBefore) {
                this.dropTargetButtonIndex = index;
                this.insertBefore = b;
                this.repaint();
            }
        }
    }

    private void resetDropGesture() {
        this.dropTargetButtonIndex = -1;
        this.repaint();
    }

    private void paintDropGesture(Graphics g) {
        Component c = this.getComponentAtIndex(this.dropTargetButtonIndex);
        if (null == c) {
            return;
        }
        Point location = c.getLocation();
        int cursorLocation = location.x;
        if (!this.insertBefore) {
            cursorLocation += c.getWidth();
            if (this.dropTargetButtonIndex == this.getComponentCount() - 1) {
                cursorLocation -= 3;
            }
        }
        this.drawDropLine(g, cursorLocation);
    }

    private void drawDropLine(Graphics g, int x) {
        Color oldColor = g.getColor();
        g.setColor(Color.black);
        int height = this.getHeight();
        g.drawLine(x, 3, x, height - 4);
        g.drawLine(x - 1, 3, x - 1, height - 4);
        g.drawLine(x + 1, 2, x + 1 + 2, 2);
        g.drawLine(x + 1, height - 3, x + 1 + 2, height - 3);
        g.drawLine(x - 2, 2, x - 2 - 2, 2);
        g.drawLine(x - 2, height - 3, x - 2 - 2, height - 3);
        g.setColor(oldColor);
    }

    private void removeButton(Transferable t) {
        try {
            Object o = null;
            if (t.isDataFlavorSupported(buttonDataFlavor)) {
                o = t.getTransferData(buttonDataFlavor);
            }
            if (null != o && o instanceof DataObject) {
                ((DataObject)o).delete();
                this.repaint();
                if (this.backingFolder.getChildren().length == 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                Toolbar.this.backingFolder.delete();
                            }
                            catch (IOException e) {
                                Logger.getLogger(Toolbar.class.getName()).log(Level.WARNING, null, e);
                            }
                        }
                    });
                }
            }
        }
        catch (UnsupportedFlavorException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    private boolean handleDrop(Transferable t) {
        try {
            if (t.isDataFlavorSupported(actionDataFlavor)) {
                Object o = t.getTransferData(actionDataFlavor);
                if (o instanceof Node) {
                    DataObject dobj = (DataObject)((Node)o).getLookup().lookup(DataObject.class);
                    return this.addButton(dobj, this.dropTargetButtonIndex - 1, this.insertBefore);
                }
            } else {
                Object o = t.getTransferData(buttonDataFlavor);
                if (o instanceof DataObject) {
                    return this.moveButton((DataObject)o, this.dropTargetButtonIndex - 1, this.insertBefore);
                }
            }
        }
        catch (UnsupportedFlavorException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return false;
    }

    private boolean isInToolbarPanel(Point p) {
        ToolbarPool c = ToolbarPool.getDefault();
        SwingUtilities.convertPointFromScreen(p, c);
        return c.contains(p);
    }

    private boolean addButton(DataObject dobj, int dropIndex, boolean dropBefore) throws IOException {
        if (null == dobj) {
            return false;
        }
        String objName = dobj.getName();
        DataObject[] children = this.backingFolder.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!objName.equals(children[i].getName())) continue;
            this.isDragSourceToolbar = true;
            return this.moveButton(children[i], dropIndex, dropBefore);
        }
        DataObject objUnderCursor = this.getDataObjectUnderDropCursor(dropIndex, dropBefore);
        DataShadow shadow = DataShadow.create(this.backingFolder, dobj);
        DataObject newObj = null;
        children = this.backingFolder.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!objName.equals(children[i].getName())) continue;
            newObj = children[i];
            break;
        }
        if (null != newObj) {
            this.reorderButtons(newObj, objUnderCursor);
        }
        return true;
    }

    private boolean moveButton(DataObject ob, int dropIndex, boolean dropBefore) throws IOException {
        DataObject objUnderCursor = this.getDataObjectUnderDropCursor(dropIndex, dropBefore);
        if (!this.isDragSourceToolbar) {
            ob.move(this.backingFolder);
        }
        this.reorderButtons(ob, objUnderCursor);
        return true;
    }

    private void reorderButtons(DataObject objToMove, DataObject objUnderCursor) throws IOException {
        ArrayList<DataObject> children = new ArrayList<DataObject>(Arrays.asList(this.backingFolder.getChildren()));
        if (null == objUnderCursor) {
            children.remove(objToMove);
            children.add(objToMove);
        } else {
            int targetIndex = children.indexOf(objUnderCursor);
            int currentIndex = children.indexOf(objToMove);
            if (currentIndex < targetIndex) {
                --targetIndex;
            }
            children.remove(objToMove);
            children.add(targetIndex, objToMove);
        }
        this.backingFolder.setOrder(children.toArray(new DataObject[children.size()]));
    }

    private DataObject getDataObjectUnderDropCursor(int dropIndex, boolean dropBefore) {
        DataObject[] buttons = this.backingFolder.getChildren();
        DataObject objUnderCursor = null;
        boolean appendToEnd = false;
        if (buttons.length > 0) {
            if (!dropBefore) {
                ++dropIndex;
            }
            if (dropIndex < buttons.length) {
                objUnderCursor = buttons[dropIndex];
            }
        }
        return objUnderCursor;
    }

    private boolean validateDropPosition() {
        return this.dropTargetButtonIndex >= 0 && (!this.isDragSourceToolbar || this.dragSourceButtonIndex != this.dropTargetButtonIndex && (this.dropTargetButtonIndex != this.dragSourceButtonIndex - 1 || this.insertBefore) && (this.dropTargetButtonIndex != this.dragSourceButtonIndex + 1 || !this.insertBefore)) || this.dropTargetButtonIndex < 0 && this.getComponentCount() == 1;
    }

    final Folder waitFinished() {
        if (this.backingFolder == null) {
            return null;
        }
        if (this.processor == null && this.isVisible()) {
            this.processor = new Folder();
        }
        return this.processor;
    }

    public void addNotify() {
        super.addNotify();
        this.waitFinished();
    }

    public Component[] getComponents() {
        this.waitFinished();
        return super.getComponents();
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        this.waitFinished();
    }

    protected void addImpl(Component c, Object constraints, int idx) {
        if (c instanceof AbstractButton) {
            c.setFocusable(false);
            ((JComponent)c).setOpaque(false);
            if (isMetalLaF && (isJdk15 || isJdk16)) {
                ((AbstractButton)c).setBorderPainted(false);
                ((AbstractButton)c).setOpaque(false);
            }
            if (isJdk16 && !isMetalLaF) {
                ((AbstractButton)c).setMargin(emptyInsets);
            }
        } else if (c instanceof JToolBar.Separator) {
            JToolBar.Separator separator = (JToolBar.Separator)c;
            if (this.getOrientation() == 1) {
                separator.setOrientation(0);
            } else {
                separator.setOrientation(1);
            }
        }
        super.addImpl(c, constraints, idx);
        if (!"grip".equals(c.getName()) && !(c instanceof JToolBar.Separator)) {
            this.getDnd().register(c);
        }
    }

    public Toolbar(String name, String displayName, boolean f) {
        this.setDisplayName(displayName);
        this.initAll(name, f);
    }

    public static int getBasicHeight() {
        if (ToolbarPool.getDefault().getPreferredIconSize() == 24) {
            return 44;
        }
        return 34;
    }

    private void initAll(String name, boolean f) {
        this.floatable = f;
        this.mouseListener = null;
        this.setName(name);
        this.setFloatable(false);
        String lAndF = UIManager.getLookAndFeel().getName();
        if (lAndF.equals("Windows")) {
            this.setBorder(Boolean.getBoolean("netbeans.small.main.window") ? BorderFactory.createEmptyBorder(1, 1, 1, 1) : BorderFactory.createEmptyBorder());
        } else if (!"Aqua".equals(UIManager.getLookAndFeel().getID()) && !"GTK".equals(UIManager.getLookAndFeel().getID())) {
            Border b = UIManager.getBorder("ToolBar.border");
            if (b == null || b instanceof MetalBorders.ToolBarBorder) {
                b = BorderFactory.createEtchedBorder(1);
            }
            this.setBorder(new CompoundBorder(b, new EmptyBorder(TOP, LEFT, BOTTOM, RIGHT)));
        }
        if (!"Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        }
        this.addGrip();
        this.getAccessibleContext().setAccessibleName(this.displayName == null ? this.getName() : this.displayName);
        this.getAccessibleContext().setAccessibleDescription(this.getName());
    }

    public String getUIClassID() {
        if (UIManager.get("Nb.Toolbar.ui") != null) {
            return "Nb.Toolbar.ui";
        }
        return super.getUIClassID();
    }

    public Dimension getPreferredSize() {
        String lfid = UIManager.getLookAndFeel().getID();
        int minheight = ToolbarPool.getDefault().getPreferredIconSize() == 24 ? ("Aqua".equals(lfid) ? 37 : ("Metal".equals(lfid) ? 44 : ("Windows".equals(lfid) ? (Toolbar.isXPTheme() ? 31 : 35) : ("GTK".equals(lfid) ? 38 : 36)))) : ("Aqua".equals(lfid) ? 29 : ("Metal".equals(lfid) ? 36 : ("Windows".equals(lfid) ? (Toolbar.isXPTheme() ? 23 : 27) : ("GTK".equals(lfid) ? 30 : 28))));
        Dimension result = super.getPreferredSize();
        result.height = Math.max(result.height, minheight);
        return result;
    }

    public void removeAll() {
        super.removeAll();
        this.addGrip();
    }

    void addGrip() {
        if (this.floatable) {
            String lfID = UIManager.getLookAndFeel().getID();
            JPanel dragarea = null;
            dragarea = lfID.endsWith("Windows") ? (Toolbar.isXPTheme() ? new ToolbarXP() : new ToolbarGrip()) : (lfID.equals("Aqua") ? new ToolbarAqua() : (lfID.equals("GTK") ? new ToolbarGtk() : new ToolbarBump()));
            if (this.mouseListener == null) {
                this.mouseListener = new ToolbarMouseListener();
            }
            if (dragarea != null) {
                dragarea.addMouseListener(this.mouseListener);
                dragarea.addMouseMotionListener(this.mouseListener);
                dragarea.setName("grip");
                this.add(dragarea);
            }
        }
    }

    public static int rowCount(int height) {
        return 1 + height / (Toolbar.getBasicHeight() + HEIGHT_TOLERANCE + customFontHeightCorrection);
    }

    public void setDnDListener(DnDListener l) {
        this.listener = l;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            if (!this.backingFolder.isValid()) {
                return this.backingFolder.getName();
            }
            return this.backingFolder.getNodeDelegate().getDisplayName();
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    protected void fireDragToolbar(int dx, int dy, int type) {
        if (this.listener != null) {
            this.listener.dragToolbar(new DnDEvent(this, this.getName(), dx, dy, type));
        }
    }

    protected void fireDropToolbar(int dx, int dy, int type) {
        if (this.listener != null) {
            this.listener.dropToolbar(new DnDEvent(this, this.getName(), dx, dy, type));
        }
    }

    final synchronized MouseInputListener mouseDelegate() {
        if (this.mouseListener == null) {
            this.mouseListener = new ToolbarMouseListener();
        }
        return this.mouseListener;
    }

    private static boolean isXPTheme() {
        if (isXP == null) {
            Boolean xp = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
            isXP = Boolean.TRUE.equals(xp) ? Boolean.TRUE : Boolean.FALSE;
        }
        return isXP;
    }

    static final Map getHints() {
        if (hintsMap == null && (hintsMap = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints")) == null) {
            hintsMap = new HashMap<RenderingHints.Key, Object>();
            hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        return hintsMap;
    }

    public void setUI(ToolBarUI ui) {
        super.setUI(ui);
        if (null != this.backingFolder && null != this.processor) {
            this.processor.recreate();
        }
    }

    private DnDSupport getDnd() {
        if (this.dnd == null) {
            this.dnd = new DnDSupport();
        }
        return this.dnd;
    }

    static {
        int defaultFontSize;
        HEIGHT_TOLERANCE = 5;
        TOP = 2;
        LEFT = 3;
        BOTTOM = 2;
        RIGHT = 3;
        RESIDUAL_WIDTH = 16;
        isMetalLaF = MetalLookAndFeel.class.isAssignableFrom(UIManager.getLookAndFeel().getClass());
        String javaVersion = System.getProperty("java.version");
        isJdk15 = javaVersion.startsWith("1.5");
        isJdk16 = javaVersion.startsWith("1.6");
        int customFontSize = UIManager.getInt("customFontSize");
        if (customFontSize < 1) {
            customFontSize = 1;
        }
        if ((defaultFontSize = UIManager.getInt("nbDefaultFontSize")) <= 0) {
            defaultFontSize = 11;
        }
        customFontHeightCorrection = Math.max(customFontSize - defaultFontSize, 0);
        synthIconClass = null;
        testExecuted = false;
        buttonDataFlavor = new DataFlavor(DataObject.class, "Toolbar Item");
        actionDataFlavor = new DataFlavor(Node.class, "Action Node");
        emptyInsets = new Insets(1, 1, 1, 1);
        isXP = null;
        hintsMap = null;
    }

    private static class DefaultIconButton
    extends JButton {
        private Icon unknownIcon;

        private DefaultIconButton() {
        }

        public Icon getIcon() {
            Icon retValue = super.getIcon();
            if (null == retValue && (null == this.getText() || this.getText().length() == 0)) {
                if (this.unknownIcon == null) {
                    this.unknownIcon = new ImageIcon(Utilities.loadImage((String)"org/openide/loaders/unknown.gif"));
                }
                retValue = this.unknownIcon;
            }
            return retValue;
        }
    }

    public static class DnDEvent
    extends EventObject {
        public static final int DND_ONE = 1;
        public static final int DND_END = 2;
        public static final int DND_LINE = 3;
        private String name;
        private int dx;
        private int dy;
        private int type;
        static final long serialVersionUID = 4389530973297716699L;

        public DnDEvent(Toolbar toolbar, String name, int dx, int dy, int type) {
            super(toolbar);
            this.name = name;
            this.dx = dx;
            this.dy = dy;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public int getDX() {
            return this.dx;
        }

        public int getDY() {
            return this.dy;
        }

        public int getType() {
            return this.type;
        }
    }

    public static interface DnDListener
    extends EventListener {
        public void dragToolbar(DnDEvent var1);

        public void dropToolbar(DnDEvent var1);
    }

    private class DnDSupport
    implements DragSourceListener,
    DragGestureListener,
    DropTargetListener,
    DragSourceMotionListener {
        private DragSource dragSource = new DragSource();
        private Cursor dragMoveCursor = DragSource.DefaultMoveDrop;
        private Cursor dragNoDropCursor = DragSource.DefaultMoveNoDrop;
        private Cursor dragRemoveCursor = Utilities.createCustomCursor((Component)Toolbar.this, (Image)Utilities.loadImage((String)"org/openide/loaders/delete.gif"), (String)"NO_ACTION_MOVE");
        DragGestureRecognizer dgr = null;

        public DnDSupport() {
            this.dragSource.addDragSourceMotionListener(this);
        }

        public void register(Component c) {
            this.dgr = this.dragSource.createDefaultDragGestureRecognizer(c, 2, this);
            if (this.dgr != this.dgr) {
                this.dgr = this.dgr;
                try {
                    this.dgr.addDragGestureListener(this);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    // empty catch block
                }
            }
        }

        public void dragEnter(DragSourceDragEvent e) {
        }

        public void dragOver(DragSourceDragEvent e) {
        }

        public void dragExit(DragSourceEvent e) {
            Toolbar.this.resetDropGesture();
        }

        public void dragDropEnd(DragSourceDropEvent e) {
            Toolbar.this.isDragSourceToolbar = false;
            Component sourceComponent = e.getDragSourceContext().getComponent();
            if (sourceComponent instanceof JButton) {
                ((JButton)sourceComponent).getModel().setRollover(false);
            }
            sourceComponent.repaint();
            Toolbar.this.resetDropGesture();
            if (!e.getDropSuccess() && !Toolbar.this.isInToolbarPanel(e.getLocation())) {
                Toolbar.this.removeButton(e.getDragSourceContext().getTransferable());
            }
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            if (!ToolbarPool.getDefault().isInEditMode()) {
                return;
            }
            try {
                DataObject dob;
                Component c = e.getComponent();
                if (c instanceof JToolBar.Separator || "grip".equals(c.getName())) {
                    return;
                }
                ExTransferable.Single t = null;
                if (c instanceof JComponent && (dob = (DataObject)((JComponent)c).getClientProperty("file")) != null) {
                    t = new ExTransferable.Single(buttonDataFlavor){

                        public Object getData() {
                            return dob;
                        }
                    };
                }
                if (c instanceof JButton) {
                    ((JButton)c).getModel().setArmed(false);
                    ((JButton)c).getModel().setPressed(false);
                    ((JButton)c).getModel().setRollover(true);
                }
                if (t != null) {
                    Toolbar.this.dragSourceButtonIndex = Toolbar.this.getComponentIndex(c);
                    Toolbar.this.isDragSourceToolbar = true;
                    this.dragSource.startDrag(e, this.dragMoveCursor, (Transferable)t, this);
                }
            }
            catch (InvalidDnDOperationException idoe) {
                Exceptions.printStackTrace((Throwable)idoe);
            }
        }

        public void dropActionChanged(DragSourceDragEvent e) {
        }

        public void drop(DropTargetDropEvent dtde) {
            if (Toolbar.this.validateDropPosition()) {
                dtde.dropComplete(Toolbar.this.handleDrop(dtde.getTransferable()));
            }
            Toolbar.this.resetDropGesture();
        }

        public void dragExit(DropTargetEvent dte) {
            Toolbar.this.resetDropGesture();
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        public void dragEnter(DropTargetDragEvent e) {
            if (e.isDataFlavorSupported(buttonDataFlavor) || e.isDataFlavorSupported(actionDataFlavor)) {
                e.acceptDrag(3);
            } else {
                e.rejectDrag();
            }
        }

        public void dragOver(DropTargetDragEvent e) {
            if (e.isDataFlavorSupported(buttonDataFlavor) || e.isDataFlavorSupported(actionDataFlavor)) {
                Toolbar.this.updateDropGesture(e);
                if (!Toolbar.this.validateDropPosition()) {
                    e.rejectDrag();
                } else {
                    e.acceptDrag(3);
                }
            } else {
                e.rejectDrag();
            }
        }

        public void dragMouseMoved(DragSourceDragEvent e) {
            DragSourceContext context = e.getDragSourceContext();
            int action = e.getDropAction();
            if ((action & 2) != 0) {
                context.setCursor(this.dragMoveCursor);
            } else if (Toolbar.this.isInToolbarPanel(e.getLocation())) {
                context.setCursor(this.dragNoDropCursor);
            } else {
                context.setCursor(this.dragRemoveCursor);
            }
        }
    }

    final class Folder
    extends FolderInstance {
        private Map<Object, Object> cookiesToObjects;

        public Folder() {
            super(Toolbar.this.backingFolder);
            this.cookiesToObjects = new HashMap<Object, Object>();
            this.recreate();
        }

        public String instanceName() {
            return Toolbar.this.getClass().getName();
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return Toolbar.this.getClass();
        }

        protected InstanceCookie acceptDataObject(DataObject dob) {
            InstanceCookie ic = super.acceptDataObject(dob);
            if (ic == null) {
                JButton button = ExecBridge.createButton(dob);
                if (button != null) {
                    button.putClientProperty("file", dob);
                }
                return button != null ? new InstanceSupport.Instance(button) : null;
            }
            return ic;
        }

        protected Object instanceForCookie(DataObject obj, InstanceCookie cookie) throws IOException, ClassNotFoundException {
            Object result = super.instanceForCookie(obj, cookie);
            this.cookiesToObjects.put(result, obj);
            return result;
        }

        protected InstanceCookie acceptCookie(InstanceCookie cookie) throws IOException, ClassNotFoundException {
            Class c;
            InstanceCookie.Of of;
            boolean is = cookie instanceof InstanceCookie.Of ? (of = (InstanceCookie.Of)cookie).instanceOf(Component.class) || of.instanceOf(Presenter.Toolbar.class) || of.instanceOf(Action.class) : Component.class.isAssignableFrom(c = cookie.instanceClass()) || Presenter.Toolbar.class.isAssignableFrom(c) || Action.class.isAssignableFrom(c);
            return is ? cookie : null;
        }

        protected InstanceCookie acceptFolder(DataFolder df) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
            Toolbar.this.removeAll();
            for (int i = 0; i < cookies.length; ++i) {
                try {
                    Object obj = cookies[i].instanceCreate();
                    Object file = this.cookiesToObjects.get(obj);
                    if (obj instanceof Presenter.Toolbar) {
                        obj = ((Presenter.Toolbar)obj).getToolbarPresenter();
                    }
                    if (obj instanceof Component) {
                        if (obj instanceof JComponent && "Fixed".equals(((JComponent)obj).getClientProperty("Toolbar"))) {
                            Toolbar.this.floatable = false;
                            Toolbar.this.removeAll();
                            Toolbar.this.setBorder(null);
                        }
                        if (obj instanceof JComponent) {
                            if (ToolbarPool.getDefault().getPreferredIconSize() == 24) {
                                ((JComponent)obj).putClientProperty("PreferredIconSize", new Integer(24));
                            }
                            ((JComponent)obj).putClientProperty("file", file);
                        }
                        Toolbar.this.add((Component)obj);
                        continue;
                    }
                    if (!(obj instanceof Action)) continue;
                    Action a = (Action)obj;
                    DefaultIconButton b = new DefaultIconButton();
                    if (ToolbarPool.getDefault().getPreferredIconSize() == 24) {
                        b.putClientProperty("PreferredIconSize", new Integer(24));
                    }
                    if (null == a.getValue("SmallIcon") && (null == a.getValue("Name") || a.getValue("Name").toString().length() == 0)) {
                        a.putValue("SmallIcon", new ImageIcon(Utilities.loadImage((String)"org/openide/loaders/unknown.gif")));
                    }
                    Actions.connect((AbstractButton)b, (Action)a);
                    b.putClientProperty("file", file);
                    Toolbar.this.add(b);
                    continue;
                }
                catch (IOException ex) {
                    Logger.getLogger(Toolbar.class.getName()).log(Level.WARNING, null, ex);
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    Logger.getLogger(Toolbar.class.getName()).log(Level.WARNING, null, ex);
                    continue;
                }
                finally {
                    this.cookiesToObjects.clear();
                }
            }
            Toolbar.this.invalidate();
            return Toolbar.this;
        }

        protected Task postCreationTask(Runnable run) {
            return new AWTTask(run);
        }
    }

    private final class ToolbarAqua
    extends JPanel {
        static final int WIDTH = 8;
        Dimension dim = new Dimension(8, 8);
        Dimension max = new Dimension(8, Integer.MAX_VALUE);
        static final long serialVersionUID = -8819972972003315277L;

        public ToolbarAqua() {
            this.setToolTipText(Toolbar.this.getDisplayName());
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.addRenderingHints(Toolbar.getHints());
            int sz = 5;
            int y = this.getHeight() / 2 - sz / 2 - 2;
            int x = this.getWidth() / 2 - sz / 2 - 2;
            GradientPaint gradient = new GradientPaint(x + 1, y + 1, Color.BLACK, x + sz - 1, y + sz - 1, Color.WHITE);
            Paint paint = g2d.getPaint();
            g2d.setPaint(gradient);
            g2d.drawArc(x, y, sz, sz, 0, 359);
            g.setColor(new Color(240, 240, 240));
            g.drawLine(x + sz / 2, y + sz / 2, x + sz / 2, y + sz / 2);
            g2d.setPaint(paint);
        }

        public Dimension getMinimumSize() {
            return this.dim;
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMaximumSize() {
            return this.max;
        }
    }

    private final class ToolbarBump
    extends JPanel {
        static final int TOPGAP = 2;
        static final int BOTGAP = 2;
        static final int WIDTH = 6;
        Dimension dim;
        Dimension max;
        static final long serialVersionUID = -8819972936203315277L;

        public ToolbarBump() {
            int width = 6;
            this.dim = new Dimension(width, width);
            this.max = new Dimension(width, Integer.MAX_VALUE);
            this.setToolTipText(Toolbar.this.getDisplayName());
        }

        public void paint(Graphics g) {
            Dimension size = this.getSize();
            int height = size.height - 2;
            g.setColor(this.getBackground());
            int x = 0;
            while (x + 1 < size.width) {
                int y = 2;
                while (y + 1 < height) {
                    g.setColor(this.getBackground().brighter());
                    g.drawLine(x, y, x, y);
                    if (x + 5 < size.width && y + 5 < height) {
                        g.drawLine(x + 2, y + 2, x + 2, y + 2);
                    }
                    g.setColor(this.getBackground().darker().darker());
                    g.drawLine(x + 1, y + 1, x + 1, y + 1);
                    if (x + 5 < size.width && y + 5 < height) {
                        g.drawLine(x + 3, y + 3, x + 3, y + 3);
                    }
                    y += 4;
                }
                x += 4;
            }
        }

        public Dimension getMinimumSize() {
            return this.dim;
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMaximumSize() {
            return this.max;
        }
    }

    private final class ToolbarGrip
    extends JPanel {
        static final int HGAP = 1;
        static final int VGAP = 2;
        static final int STEP = 1;
        static final int WIDTH = 2;
        int columns;
        Dimension dim;
        Dimension max;
        static final long serialVersionUID = -8819972936203315276L;

        public ToolbarGrip() {
            this(1);
        }

        public ToolbarGrip(int col) {
            this.columns = col;
            int width = (col - 1) * 1 + col * 2 + 2;
            this.dim = new Dimension(width, width);
            this.max = new Dimension(width, Integer.MAX_VALUE);
            this.setBorder(new EmptyBorder(2, 1, 2, 1));
            this.setToolTipText(Toolbar.this.getDisplayName());
        }

        public void paint(Graphics g) {
            Dimension size = this.getSize();
            int top = 2;
            int bottom = size.height - 1 - 2;
            int height = bottom - top;
            g.setColor(this.getBackground());
            int i = 0;
            int x = 1;
            while (i < this.columns) {
                g.draw3DRect(x, top, 2, height, true);
                ++i;
                x += 3;
            }
        }

        public Dimension getMinimumSize() {
            return this.dim;
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMaximumSize() {
            return this.max;
        }
    }

    private final class ToolbarGtk
    extends JPanel {
        static final int TOPGAP = 2;
        static final int BOTGAP = 2;
        static final int WIDTH = 6;
        Dimension dim;
        Dimension max;
        static final long serialVersionUID = -8819972936203315277L;

        public ToolbarGtk() {
            int width = 6;
            this.dim = new Dimension(width, width);
            this.max = new Dimension(width, Integer.MAX_VALUE);
            this.setToolTipText(Toolbar.this.getDisplayName());
        }

        public void paint(Graphics g) {
            if (Toolbar.useSynthIcon()) {
                int height = Toolbar.this.getHeight() - 2;
                Icon icon = UIManager.getIcon("ToolBar.handleIcon");
                Region region = Region.TOOL_BAR;
                SynthLookAndFeel laf = (SynthLookAndFeel)UIManager.getLookAndFeel();
                SynthStyleFactory sf = laf.getStyleFactory();
                SynthStyle style = sf.getStyle(Toolbar.this, region);
                SynthContext context = new SynthContext(Toolbar.this, region, style, 1024);
                Method m = null;
                try {
                    m = synthIconClass.getMethod("getIconWidth", Icon.class, SynthContext.class);
                }
                catch (NoSuchMethodException exc) {
                    Logger.getLogger(Toolbar.class.getName()).log(Level.WARNING, null, exc);
                }
                int width = 0;
                try {
                    width = (Integer)m.invoke(null, icon, context);
                }
                catch (IllegalAccessException exc) {
                    Logger.getLogger(Toolbar.class.getName()).log(Level.WARNING, null, exc);
                }
                catch (InvocationTargetException exc) {
                    Logger.getLogger(Toolbar.class.getName()).log(Level.WARNING, null, exc);
                }
                try {
                    m = synthIconClass.getMethod("paintIcon", Icon.class, SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                }
                catch (NoSuchMethodException exc) {
                    Logger.getLogger(Toolbar.class.getName()).log(Level.WARNING, null, exc);
                }
                try {
                    m.invoke(null, icon, context, g, new Integer(0), new Integer(0), new Integer(width), new Integer(height));
                }
                catch (IllegalAccessException exc) {
                    Logger.getLogger(Toolbar.class.getName()).log(Level.WARNING, null, exc);
                }
                catch (InvocationTargetException exc) {
                    Logger.getLogger(Toolbar.class.getName()).log(Level.WARNING, null, exc);
                }
            } else {
                Dimension size = this.getSize();
                int height = size.height - 2;
                g.setColor(this.getBackground());
                int x = 0;
                while (x + 1 < size.width) {
                    int y = 2;
                    while (y + 1 < height) {
                        g.setColor(this.getBackground().brighter());
                        g.drawLine(x, y, x, y);
                        if (x + 5 < size.width && y + 5 < height) {
                            g.drawLine(x + 2, y + 2, x + 2, y + 2);
                        }
                        g.setColor(this.getBackground().darker().darker());
                        g.drawLine(x + 1, y + 1, x + 1, y + 1);
                        if (x + 5 < size.width && y + 5 < height) {
                            g.drawLine(x + 3, y + 3, x + 3, y + 3);
                        }
                        y += 4;
                    }
                    x += 4;
                }
            }
        }

        public Dimension getMinimumSize() {
            return this.dim;
        }

        public Dimension getPreferredSize() {
            return new Dimension(6, Toolbar.this.getHeight() - 2 - 2);
        }

        public Dimension getMaximumSize() {
            return this.max;
        }
    }

    class ToolbarMouseListener
    extends MouseInputAdapter {
        private boolean dragging = false;
        private Point startPoint = null;

        ToolbarMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.startPoint = e.getPoint();
        }

        public void mouseReleased(MouseEvent e) {
            if (this.dragging) {
                int dx = Toolbar.this.getX() + e.getX() - this.startPoint.x > Toolbar.this.getParent().getWidth() - RESIDUAL_WIDTH ? 0 : e.getX() - this.startPoint.x;
                Toolbar.this.fireDropToolbar(dx, e.getY() - this.startPoint.y, 1);
                this.dragging = false;
            }
        }

        public void mouseDragged(MouseEvent e) {
            int m = e.getModifiers();
            int type = 1;
            if (e.isControlDown()) {
                type = 3;
            } else if ((m & 8) != 0 || (m & 4) != 0) {
                type = 2;
            }
            if (this.startPoint == null) {
                this.startPoint = new Point(e.getX(), e.getY());
            }
            int dx = Toolbar.this.getX() + e.getX() + this.startPoint.x > Toolbar.this.getParent().getWidth() - RESIDUAL_WIDTH ? (Toolbar.this.getX() >= Toolbar.this.getParent().getWidth() - RESIDUAL_WIDTH ? 0 : Toolbar.this.getParent().getWidth() - RESIDUAL_WIDTH - Toolbar.this.getX()) : e.getX() - this.startPoint.x;
            Toolbar.this.fireDragToolbar(dx, e.getY() - this.startPoint.y, type);
            this.dragging = true;
        }
    }

    private final class ToolbarXP
    extends JPanel {
        static final int WIDTH = 7;
        Dimension dim = new Dimension(7, 7);
        Dimension max = new Dimension(7, Integer.MAX_VALUE);
        static final long serialVersionUID = -8819972936203315277L;

        public ToolbarXP() {
            this.setToolTipText(Toolbar.this.getDisplayName());
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int x = 3;
            for (int i = 4; i < this.getHeight() - 4; i += 4) {
                g.setColor(UIManager.getColor("controlLtHighlight"));
                g.fillRect(x + 1, i + 1, 2, 2);
                Color col = UIManager.getColor("controlShadow");
                g.setColor(col);
                g.drawLine(x + 1, i + 1, x + 1, i + 1);
                int red = col.getRed();
                int green = col.getGreen();
                int blue = col.getBlue();
                Color back = this.getBackground();
                int rb = back.getRed();
                int gb = back.getGreen();
                int bb = back.getBlue();
                int incr = (rb - red) / 5;
                int incg = (gb - green) / 5;
                int incb = (bb - blue) / 5;
                col = new Color(red += incr, green += incg, blue += incb);
                g.setColor(col);
                g.drawLine(x + 1, i, x + 1, i);
                col = new Color(red += incr, green += incg, blue += incb);
                g.setColor(col);
                g.drawLine(x, i + 1, x, i + 1);
                col = new Color(red += incr, green += incg, blue += incb);
                g.setColor(col);
                g.drawLine(x, i, x, i);
            }
        }

        public Dimension getMinimumSize() {
            return this.dim;
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMaximumSize() {
            return this.max;
        }
    }
}

