/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.util.Date;
import java.util.Enumeration;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

class FolderComparator
extends DataFolder.SortMode {
    public static final int NONE = 0;
    public static final int NAMES = 1;
    public static final int CLASS = 2;
    public static final int FOLDER_NAMES = 3;
    public static final int LAST_MODIFIED = 4;
    public static final int SIZE = 5;
    private int mode;

    public FolderComparator() {
        this(3);
    }

    public FolderComparator(int mode) {
        this.mode = mode;
    }

    public int compare(Object o1, Object o2) {
        DataObject obj2;
        DataObject obj1;
        if (o1 instanceof Node) {
            obj1 = (DataObject)((Node)o1).getCookie(DataObject.class);
            obj2 = (DataObject)((Node)o2).getCookie(DataObject.class);
        } else {
            obj1 = (DataObject)o1;
            obj2 = (DataObject)o2;
        }
        switch (this.mode) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.compareNames(obj1, obj2);
            }
            case 2: {
                return this.compareClass(obj1, obj2);
            }
            case 3: {
                return this.compareFoldersFirst(obj1, obj2);
            }
            case 4: {
                return FolderComparator.compareLastModified(obj1, obj2);
            }
            case 5: {
                return FolderComparator.compareSize(obj1, obj2);
            }
        }
        assert (false) : this.mode;
        return 0;
    }

    private int compareNames(DataObject obj1, DataObject obj2) {
        int part = obj1.getName().compareTo(obj2.getName());
        return part != 0 ? part : obj1.getPrimaryFile().getExt().compareTo(obj2.getPrimaryFile().getExt());
    }

    private int compareFoldersFirst(DataObject obj1, DataObject obj2) {
        if (obj1.getClass() != obj2.getClass()) {
            if (obj1 instanceof DataFolder) {
                return -1;
            }
            if (obj2 instanceof DataFolder) {
                return 1;
            }
        }
        return this.compareNames(obj1, obj2);
    }

    private int compareClass(DataObject obj1, DataObject obj2) {
        Class<?> c2;
        Class<?> c1 = obj1.getClass();
        if (c1 == (c2 = obj2.getClass())) {
            return this.compareNames(obj1, obj2);
        }
        DataLoaderPool dlp = DataLoaderPool.getDefault();
        Enumeration<DataLoader> loaders = dlp.allLoaders();
        while (loaders.hasMoreElements()) {
            Class<? extends DataObject> clazz = loaders.nextElement().getRepresentationClass();
            if (clazz == DataObject.class) continue;
            boolean r1 = clazz.isAssignableFrom(c1);
            boolean r2 = clazz.isAssignableFrom(c2);
            if (r1 && r2) {
                return this.compareNames(obj1, obj2);
            }
            if (r1) {
                return -1;
            }
            if (!r2) continue;
            return 1;
        }
        return this.compareNames(obj1, obj2);
    }

    private static int compareLastModified(DataObject obj1, DataObject obj2) {
        Date d2;
        if (obj1 instanceof DataFolder) {
            if (obj2 instanceof DataFolder) {
                return obj1.getName().compareTo(obj2.getName());
            }
            return -1;
        }
        if (obj2 instanceof DataFolder) {
            return 1;
        }
        FileObject fo1 = obj1.getPrimaryFile();
        FileObject fo2 = obj2.getPrimaryFile();
        Date d1 = fo1.lastModified();
        if (d1.after(d2 = fo2.lastModified())) {
            return -1;
        }
        if (d2.after(d1)) {
            return 1;
        }
        return fo1.getNameExt().compareTo(fo2.getNameExt());
    }

    private static int compareSize(DataObject obj1, DataObject obj2) {
        long s2;
        if (obj1 instanceof DataFolder) {
            if (obj2 instanceof DataFolder) {
                return obj1.getName().compareTo(obj2.getName());
            }
            return -1;
        }
        if (obj2 instanceof DataFolder) {
            return 1;
        }
        FileObject fo1 = obj1.getPrimaryFile();
        FileObject fo2 = obj2.getPrimaryFile();
        long s1 = fo1.getSize();
        if (s1 > (s2 = fo2.getSize())) {
            return -1;
        }
        if (s2 > s1) {
            return 1;
        }
        return fo1.getNameExt().compareTo(fo2.getNameExt());
    }
}

