/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.xml.parsers.DocumentBuilder;
import org.openide.actions.OpenAction;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.Environment;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.loaders.XMLDataObjectImpl;
import org.openide.loaders.XMLEntityResolverChain;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.text.DataEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.windows.CloneableOpenSupport;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLDataObject
extends MultiDataObject {
    static final long serialVersionUID = 8757854986453256578L;
    @Deprecated
    public static final String XMLINFO_DTD_PUBLIC_ID_FORTE = "-//Forte for Java//DTD xmlinfo//EN";
    @Deprecated
    public static final String XMLINFO_DTD_PUBLIC_ID = "-//NetBeans IDE//DTD xmlinfo//EN";
    public static final String MIME = "text/xml";
    public static final int STATUS_NOT = 0;
    public static final int STATUS_OK = 1;
    public static final int STATUS_WARNING = 2;
    public static final int STATUS_ERROR = 3;
    public static final String PROP_DOCUMENT = "document";
    @Deprecated
    public static final String PROP_INFO = "info";
    private static ErrorPrinter errorHandler = new ErrorPrinter();
    private static XMLEntityResolverChain chainingEntityResolver;
    private static HashMap<String, Info> infos;
    private static Object emgrLock;
    private DelDoc doc;
    private int status;
    @Deprecated
    private EditorCookie editor = null;
    private InfoParser infoParser;
    private static final Logger ERR;
    private static final StopSaxException STOP;
    private static XMLReader sharedParserImpl;
    private static final String NULL = "";

    public XMLDataObject(FileObject fo, MultiFileLoader loader) throws DataObjectExistsException {
        super(fo, loader);
        fo.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.getIP(), (Object)fo));
        this.status = 0;
        CookieSet.Factory factory = new CookieSet.Factory(){

            public <T extends Node.Cookie> T createCookie(Class<T> klass) {
                if (klass.isAssignableFrom(EditorCookie.class) || klass.isAssignableFrom(OpenCookie.class) || klass.isAssignableFrom(CloseCookie.class) || klass.isAssignableFrom(PrintCookie.class)) {
                    if (XMLDataObject.this.editor == null) {
                        XMLDataObject.this.editor = XMLDataObject.this.createEditorCookie();
                    }
                    if (XMLDataObject.this.editor == null) {
                        return null;
                    }
                    return (T)(klass.isAssignableFrom(XMLDataObject.this.editor.getClass()) ? XMLDataObject.this.editor : null);
                }
                return null;
            }
        };
        CookieSet cookies = this.getCookieSet();
        cookies.add(EditorCookie.class, factory);
        cookies.add(OpenCookie.class, factory);
        cookies.add(CloseCookie.class, factory);
        cookies.add(PrintCookie.class, factory);
        cookies.assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject folder, String fileName) throws IOException {
                XMLEditorSupport es = XMLDataObject.this.getCookie(XMLEditorSupport.class);
                es.saveAs(folder, fileName);
            }
        }});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InfoParser getIP() {
        Object object = emgrLock;
        synchronized (object) {
            if (this.infoParser == null) {
                this.infoParser = new InfoParser();
            }
        }
        return this.infoParser;
    }

    @Override
    protected Node createNodeDelegate() {
        XMLNode xn = new XMLNode(this);
        xn.setShortDescription(NbBundle.getMessage(XMLDataObject.class, (String)"HINT_XMLDataObject"));
        return xn;
    }

    @Deprecated
    protected void updateIconBase(String res) {
    }

    @Override
    protected void handleDelete() throws IOException {
        this.getIP().waitFinished();
        super.handleDelete();
    }

    @Override
    public HelpCtx getHelpCtx() {
        try {
            if (this.getPrimaryFile().getFileSystem().isDefault() && this.getCookie(InstanceCookie.class) != null) {
                return HelpCtx.DEFAULT_HELP;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return new HelpCtx(XMLDataObject.class);
    }

    @Override
    public <T extends Node.Cookie> T getCookie(Class<T> cls) {
        this.getIP().waitFinished();
        Object cake = this.getIP().lookupCookie(cls);
        if (ERR.isLoggable(Level.FINE)) {
            ERR.fine("Query for " + cls + " for " + this);
            ERR.fine("Gives a cake " + cake + " for " + this);
        }
        if (cake instanceof InstanceCookie) {
            cake = this.ofCookie((InstanceCookie)cake, cls);
        }
        if (ERR.isLoggable(Level.FINE)) {
            ERR.fine("After ofCookie: " + cake + " for " + this);
        }
        if (cake == null) {
            cake = super.getCookie(cls);
        }
        if (ERR.isLoggable(Level.FINE)) {
            ERR.fine("getCookie returns " + cake + " for " + this);
        }
        return (T)((Node.Cookie)cls.cast(cake));
    }

    private InstanceCookie ofCookie(InstanceCookie ic, Class cls) {
        if (ic instanceof InstanceCookie.Of) {
            return ic;
        }
        if (!cls.isAssignableFrom(ICDel.class)) {
            return ic;
        }
        ICDel d = new ICDel(this, ic);
        return d;
    }

    private void notifyEx(Exception e) {
        Exceptions.attachLocalizedMessage((Throwable)e, (String)"Cannot resolve following class in xmlinfo.");
        Exceptions.printStackTrace((Throwable)e);
    }

    @Deprecated
    protected EditorCookie createEditorCookie() {
        return new XMLEditorSupport(this);
    }

    private final void addSaveCookie(SaveCookie save) {
        this.getCookieSet().add((Node.Cookie)save);
    }

    private final void removeSaveCookie(SaveCookie save) {
        this.getCookieSet().remove((Node.Cookie)save);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Document getDocument() throws IOException, SAXException {
        if (ERR.isLoggable(Level.FINE)) {
            ERR.fine("getDocument for " + this);
        }
        XMLDataObject xMLDataObject = this;
        synchronized (xMLDataObject) {
            DelDoc d = this.doc;
            if (d == null) {
                this.doc = d = new DelDoc();
            }
            return d.getProxyDocument();
        }
    }

    final void clearDocument() {
        if (ERR.isLoggable(Level.FINE)) {
            ERR.fine("clearDocument for " + this);
        }
        this.doc = null;
        this.firePropertyChange(PROP_DOCUMENT, null, null);
    }

    public final int getStatus() {
        return this.status;
    }

    @Deprecated
    public final Info getInfo() {
        return null;
    }

    @Deprecated
    public final synchronized void setInfo(Info ii) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Document parsePrimaryFile() throws IOException, SAXException {
        if (ERR.isLoggable(Level.FINE)) {
            ERR.fine("parsePrimaryFile for " + this);
        }
        String loc = this.getPrimaryFile().getURL().toExternalForm();
        try {
            return XMLUtil.parse((InputSource)new InputSource(loc), (boolean)false, (boolean)true, (ErrorHandler)errorHandler, (EntityResolver)XMLDataObject.getSystemResolver());
        }
        catch (IOException e) {
            InputStream is = this.getPrimaryFile().getInputStream();
            try {
                Document document = XMLUtil.parse((InputSource)new InputSource(is), (boolean)false, (boolean)true, (ErrorHandler)errorHandler, (EntityResolver)XMLDataObject.getSystemResolver());
                return document;
            }
            finally {
                is.close();
            }
        }
    }

    @Deprecated
    public static Document parse(URL url) throws IOException, SAXException {
        return XMLDataObject.parse(url, errorHandler, false);
    }

    @Deprecated
    public static Document parse(URL url, boolean validate) throws IOException, SAXException {
        return XMLDataObject.parse(url, errorHandler, validate);
    }

    @Deprecated
    public static Document parse(URL url, ErrorHandler eh) throws IOException, SAXException {
        return XMLDataObject.parse(url, eh, false);
    }

    @Deprecated
    public static Document parse(URL url, ErrorHandler eh, boolean validate) throws IOException, SAXException {
        DocumentBuilder builder = XMLDataObjectImpl.makeBuilder(validate);
        builder.setErrorHandler(eh);
        builder.setEntityResolver(XMLDataObject.getChainingEntityResolver());
        return builder.parse(new InputSource(url.toExternalForm()));
    }

    @Deprecated
    public static Parser createParser() {
        return XMLDataObject.createParser(false);
    }

    @Deprecated
    public static Parser createParser(boolean validate) {
        Parser parser = XMLDataObjectImpl.makeParser(validate);
        parser.setEntityResolver(XMLDataObject.getChainingEntityResolver());
        return parser;
    }

    @Deprecated
    public static Document createDocument() {
        XMLDataObject.deprecated();
        try {
            return XMLDataObjectImpl.makeBuilder(false).newDocument();
        }
        catch (IOException ex) {
            return null;
        }
        catch (SAXException ex) {
            return null;
        }
    }

    @Deprecated
    public static void write(Document doc, Writer writer) throws IOException {
        XMLDataObject.deprecated();
        String FAILURE = "org.openide.xml.XMLUtilImpl.write() invocation failed.";
        try {
            Class<?> clzz = Class.forName("org.openide.xml.XMLUtilImpl");
            Method impl = clzz.getDeclaredMethod("write", Document.class, Object.class, String.class);
            impl.setAccessible(true);
            impl.invoke(null, doc, writer, null);
        }
        catch (IllegalAccessException ex) {
            throw new IOException("org.openide.xml.XMLUtilImpl.write() invocation failed.");
        }
        catch (IllegalArgumentException ex) {
            throw new IOException("org.openide.xml.XMLUtilImpl.write() invocation failed.");
        }
        catch (NoSuchMethodException ex) {
            throw new IOException("org.openide.xml.XMLUtilImpl.write() invocation failed.");
        }
        catch (ClassNotFoundException ex) {
            throw new IOException("org.openide.xml.XMLUtilImpl.write() invocation failed.");
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new IOException("org.openide.xml.XMLUtilImpl.write() invocation failed.");
        }
    }

    @Deprecated
    public static void write(Document doc, OutputStream out, String enc) throws IOException {
        XMLUtil.write((Document)doc, (OutputStream)out, (String)enc);
    }

    @Deprecated
    public static InputSource createInputSource(URL url) throws IOException {
        return new InputSource(url.toExternalForm());
    }

    @Deprecated
    public static void registerCatalogEntry(String publicId, String uri) {
        if (publicId == null) {
            throw new IllegalArgumentException("null public ID is not allowed.");
        }
        XMLDataObjectImpl.registerCatalogEntry(publicId, uri);
    }

    @Deprecated
    public static void registerCatalogEntry(String publicId, String resourceName, ClassLoader loader) {
        if (publicId == null) {
            throw new IllegalArgumentException("null public ID is not allowed.");
        }
        XMLDataObjectImpl.registerCatalogEntry(publicId, "nbres:/" + resourceName);
    }

    @Deprecated
    public static final boolean addEntityResolver(EntityResolver resolver) {
        return XMLDataObject.getChainingEntityResolver().addEntityResolver(resolver);
    }

    @Deprecated
    public static final EntityResolver removeEntityResolver(EntityResolver resolver) {
        return XMLDataObject.getChainingEntityResolver().removeEntityResolver(resolver);
    }

    private static synchronized XMLEntityResolverChain getChainingEntityResolver() {
        if (chainingEntityResolver == null) {
            chainingEntityResolver = new XMLEntityResolverChain();
            chainingEntityResolver.addEntityResolver(XMLDataObject.getSystemResolver());
        }
        return chainingEntityResolver;
    }

    private static EntityResolver getSystemResolver() {
        return EntityCatalog.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void registerInfo(String publicId, Info info) {
        HashMap<String, Info> hashMap = infos;
        synchronized (hashMap) {
            if (info == null) {
                infos.remove(publicId);
            } else {
                infos.put(publicId, info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Info getRegisteredInfo(String publicId) {
        HashMap<String, Info> hashMap = infos;
        synchronized (hashMap) {
            Info ret = infos.get(publicId);
            return ret == null ? null : (Info)ret.clone();
        }
    }

    private static void deprecated() {
        StringWriter wr = new StringWriter();
        PrintWriter pr = new PrintWriter(wr);
        new Exception(NULL).printStackTrace(pr);
        pr.flush();
        String stack = wr.toString().trim();
        int start = stack.indexOf("\n");
        int end = stack.indexOf("\n", start + 1);
        while (stack.indexOf("XMLDataObject", start + 1) > 0) {
            start = end;
            end = stack.indexOf("\n", start + 1);
        }
        String line = stack.substring(start + 1, end).trim();
        System.out.println("Warning: deprecated method called " + line);
    }

    static Lookup createInfoLookup(XMLDataObject obj, Info info) {
        return new InfoLkp(obj, info);
    }

    private Node findNode() {
        Node n = (Node)this.getIP().lookupCookie(Node.class);
        if (n == null) {
            return new PlainDataNode();
        }
        return n;
    }

    static {
        infos = new HashMap();
        emgrLock = new Object();
        ERR = Logger.getLogger(XMLDataObject.class.getName());
        STOP = new StopSaxException();
        sharedParserImpl = null;
        try {
            sharedParserImpl = XMLUtil.createXMLReader();
            sharedParserImpl.setEntityResolver(new EmptyEntityResolver());
        }
        catch (SAXException ex) {
            Exceptions.attachLocalizedMessage((Throwable)ex, (String)"System does not contain JAXP 1.1 compliant parser!");
            Logger.getLogger(XMLDataObject.class.getName()).log(Level.WARNING, null, ex);
        }
        try {
            Properties props = System.getProperties();
            String SAX2_KEY = "org.xml.sax.driver";
            if (props.getProperty("org.xml.sax.driver") == null) {
                props.put("org.xml.sax.driver", sharedParserImpl.getClass().getName());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private final class DelDoc
    implements InvocationHandler {
        private Reference<Document> xmlDocument;
        private final Document proxyDocument = (Document)Proxy.newProxyInstance(DelDoc.class.getClassLoader(), new Class[]{Document.class}, (InvocationHandler)this);

        DelDoc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Document getDocumentImpl(boolean force) {
            DelDoc delDoc = this;
            synchronized (delDoc) {
                Document doc;
                Document document = doc = this.xmlDocument == null ? null : this.xmlDocument.get();
                if (doc != null) {
                    return doc;
                }
                if (!force) {
                    return null;
                }
                XMLDataObject.this.status = 1;
                try {
                    Document d = XMLDataObject.this.parsePrimaryFile();
                    this.xmlDocument = new SoftReference<Document>(d);
                    return d;
                }
                catch (SAXException e) {
                    ERR.log(Level.WARNING, null, e);
                }
                catch (IOException e) {
                    ERR.log(Level.WARNING, null, e);
                }
                XMLDataObject.this.status = 3;
                Document d = XMLUtil.createDocument((String)"brokenDocument", null, null, null);
                this.xmlDocument = new SoftReference<Document>(d);
                XMLDataObject.this.firePropertyChange(XMLDataObject.PROP_DOCUMENT, null, null);
                return d;
            }
        }

        public Document getProxyDocument() {
            return this.proxyDocument;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getDoctype") && args == null) {
                return Proxy.newProxyInstance(DelDoc.class.getClassLoader(), new Class[]{DocumentType.class}, (InvocationHandler)this);
            }
            if (method.getName().equals("getPublicId") && args == null) {
                Document d = this.getDocumentImpl(false);
                if (d != null) {
                    DocumentType doctype = d.getDoctype();
                    return doctype == null ? null : doctype.getPublicId();
                }
                return XMLDataObject.this.getIP().getPublicId();
            }
            return method.invoke((Object)this.getDocumentImpl(true), args);
        }
    }

    private static class EmptyEntityResolver
    implements EntityResolver {
        EmptyEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemID) {
            InputSource ret = new InputSource(new StringReader(XMLDataObject.NULL));
            ret.setSystemId("StringReader");
            return ret;
        }
    }

    static class ErrorPrinter
    implements ErrorHandler {
        ErrorPrinter() {
        }

        private void message(String level, SAXParseException e) {
            if (!DataObject.LOG.isLoggable(Level.FINE)) {
                return;
            }
            String msg = NbBundle.getMessage(XMLDataObject.class, (String)"PROP_XmlMessage", (Object[])new Object[]{level, e.getMessage(), e.getSystemId() == null ? XMLDataObject.NULL : e.getSystemId(), XMLDataObject.NULL + e.getLineNumber(), XMLDataObject.NULL + e.getColumnNumber()});
            DataObject.LOG.fine(msg);
        }

        public void error(SAXParseException e) {
            this.message(NbBundle.getMessage(XMLDataObject.class, (String)"PROP_XmlError"), e);
        }

        public void warning(SAXParseException e) {
            this.message(NbBundle.getMessage(XMLDataObject.class, (String)"PROP_XmlWarning"), e);
        }

        public void fatalError(SAXParseException e) {
            this.message(NbBundle.getMessage(XMLDataObject.class, (String)"PROP_XmlFatalError"), e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ICDel
    implements InstanceCookie.Of {
        private XMLDataObject obj;
        private InstanceCookie ic;

        public ICDel(XMLDataObject obj, InstanceCookie ic) {
            this.obj = obj;
            this.ic = ic;
        }

        public String instanceName() {
            return this.ic.instanceName();
        }

        public Class<?> instanceClass() throws IOException, ClassNotFoundException {
            return this.ic.instanceClass();
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            return this.ic.instanceCreate();
        }

        public boolean instanceOf(Class cls2) {
            if (this.ic instanceof InstanceCookie.Of) {
                return ((InstanceCookie.Of)this.ic).instanceOf(cls2);
            }
            try {
                return cls2.isAssignableFrom(this.instanceClass());
            }
            catch (IOException ioe) {
                return false;
            }
            catch (ClassNotFoundException cnfe) {
                return false;
            }
        }

        public int hashCode() {
            return 2 * this.obj.hashCode() + this.ic.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ICDel) {
                ICDel d = (ICDel)obj;
                return d.obj == obj && d.ic == this.ic;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static final class Info
    implements Cloneable {
        List<Class<?>> processors = new ArrayList();
        String iconBase = null;

        public Object clone() {
            Info ii = new Info();
            for (Class<?> proc : this.processors) {
                ii.processors.add(proc);
            }
            ii.iconBase = this.iconBase;
            return ii;
        }

        public synchronized void addProcessorClass(Class<?> proc) {
            if (!Processor.class.isAssignableFrom(proc)) {
                Constructor<?>[] arr = proc.getConstructors();
                for (int i = 0; i < arr.length; ++i) {
                    Class<?>[] params = arr[i].getParameterTypes();
                    if (params.length != 1 || params[0] != DataObject.class && params[0] != XMLDataObject.class) continue;
                    arr = null;
                    break;
                }
                if (arr != null) {
                    throw new IllegalArgumentException();
                }
            }
            this.processors.add(proc);
        }

        public boolean removeProcessorClass(Class<?> proc) {
            return this.processors.remove(proc);
        }

        public Iterator<Class<?>> processorClasses() {
            return this.processors.iterator();
        }

        public void setIconBase(String base) {
            this.iconBase = base;
        }

        public String getIconBase() {
            return this.iconBase;
        }

        public void write(Writer writer) throws IOException {
            throw new IOException("Not supported anymore");
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Info)) {
                return false;
            }
            Info i = (Info)obj;
            return (this.iconBase != null && this.iconBase.equals(i.iconBase) || i.iconBase == this.iconBase) && ((Object)this.processors).equals(i.processors);
        }
    }

    private static final class InfoLkp
    extends AbstractLookup {
        public final Info info;

        public InfoLkp(XMLDataObject obj, Info info) {
            this.info = info;
            Iterator<Class<?>> it = info.processorClasses();
            ArrayList<InfoPair> arr = new ArrayList<InfoPair>(info.processors.size());
            while (it.hasNext()) {
                Class<?> c = it.next();
                arr.add(new InfoPair(obj, c));
            }
            this.setPairs(arr);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class InfoPair
        extends AbstractLookup.Pair {
            private Class<?> clazz;
            private Object obj;

            protected InfoPair(XMLDataObject obj, Class<?> c) {
                this.obj = obj;
                this.clazz = c;
            }

            protected boolean instanceOf(Class c) {
                Class<?> temp = this.clazz;
                if (temp == null) {
                    return c.isInstance(this.obj);
                }
                return c.isAssignableFrom(temp);
            }

            protected boolean creatorOf(Object obj) {
                return this.obj == obj;
            }

            public synchronized Object getInstance() {
                if (this.clazz == null) {
                    return this.obj;
                }
                XMLDataObject xmlDataObject = (XMLDataObject)this.obj;
                this.obj = null;
                Class<?> next = this.clazz;
                this.clazz = null;
                try {
                    if (Processor.class.isAssignableFrom(next)) {
                        this.obj = next.newInstance();
                        Processor proc = (Processor)this.obj;
                        proc.attachTo(xmlDataObject);
                        return this.obj;
                    }
                    Constructor<?>[] arr = next.getConstructors();
                    for (int i = 0; i < arr.length; ++i) {
                        Class<?>[] params = arr[i].getParameterTypes();
                        if (params.length != 1 || params[0] != DataObject.class && params[0] != XMLDataObject.class) continue;
                        this.obj = arr[i].newInstance(xmlDataObject);
                        return this.obj;
                    }
                    throw new InternalError("XMLDataObject processor class " + next + " invalid");
                }
                catch (InvocationTargetException e) {
                    xmlDataObject.notifyEx(e);
                }
                catch (InstantiationException e) {
                    xmlDataObject.notifyEx(e);
                }
                catch (IllegalAccessException e) {
                    xmlDataObject.notifyEx(e);
                }
                return this.obj;
            }

            public Class getType() {
                Class<?> temp = this.clazz;
                return temp != null ? temp : this.obj.getClass();
            }

            public String getId() {
                return "Info[" + this.getType().getName();
            }

            public String getDisplayName() {
                return this.getType().getName();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InfoParser
    extends DefaultHandler
    implements FileChangeListener,
    LexicalHandler,
    LookupListener {
        private String parsedId;
        private Lookup lookup;
        private Lookup.Result result;
        private ThreadLocal<Class<?>> QUERY = new ThreadLocal();

        InfoParser() {
        }

        public String getPublicId() {
            String id = this.waitFinished();
            return id == XMLDataObject.NULL ? null : id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lookupCookie(final Class<?> clazz) {
            if (this.QUERY.get() == clazz) {
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("Cyclic deps on queried class: " + clazz + " for " + XMLDataObject.this);
                }
                return new InstanceCookie(){

                    public Class<?> instanceClass() {
                        return clazz;
                    }

                    public Object instanceCreate() throws IOException {
                        throw new IOException("Cyclic reference, sorry: " + clazz);
                    }

                    public String instanceName() {
                        return clazz.getName();
                    }
                };
            }
            Class<?> previous = this.QUERY.get();
            try {
                Lookup.Result r;
                Lookup l;
                block19: {
                    this.QUERY.set(clazz);
                    if (ERR.isLoggable(Level.FINE)) {
                        ERR.fine("Will do query for class: " + clazz + " for " + XMLDataObject.this);
                    }
                    do {
                        String id = this.waitFinished();
                        InfoParser infoParser = this;
                        synchronized (infoParser) {
                            l = this.lookup != null ? this.lookup : null;
                        }
                        if (ERR.isLoggable(Level.FINE)) {
                            ERR.fine("Lookup is " + l + " for id: " + id);
                        }
                        if (l == null) {
                            l = this.updateLookup(null, id);
                            if (ERR.isLoggable(Level.FINE)) {
                                ERR.fine("Updating lookup: " + l);
                            }
                        }
                        if (ERR.isLoggable(Level.FINE)) {
                            ERR.fine("Wait lookup is over: " + l + XMLDataObject.this);
                        }
                        if (l != null) break block19;
                    } while (this.parsedId != null);
                    l = Lookup.EMPTY;
                }
                if ((r = this.result) != null) {
                    if (ERR.isLoggable(Level.FINE)) {
                        ERR.fine("Querying the result: " + r);
                    }
                    r.allItems();
                } else if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("No result for lookup: " + this.lookup);
                }
                Object ret = l.lookup(clazz);
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("Returning value: " + ret + " for " + XMLDataObject.this);
                }
                Object object = ret;
                return object;
            }
            finally {
                this.QUERY.set(previous);
            }
        }

        public String waitFinished() {
            return this.waitFinished(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private String waitFinished(String ignorePreviousId) {
            InputStream in;
            String previousID;
            String newID;
            block72: {
                URL url;
                FileObject myFileObject;
                XMLReader parser;
                block71: {
                    String string;
                    if (sharedParserImpl == null) {
                        ERR.fine("No sharedParserImpl, exiting");
                        return XMLDataObject.NULL;
                    }
                    parser = sharedParserImpl;
                    myFileObject = XMLDataObject.this.getPrimaryFile();
                    newID = null;
                    if (ERR.isLoggable(Level.FINE)) {
                        ERR.fine("Going to read parsedId for " + XMLDataObject.this);
                    }
                    InfoParser infoParser = this;
                    // MONITORENTER : infoParser
                    previousID = this.parsedId;
                    // MONITOREXIT : infoParser
                    if (previousID != null) {
                        if (!ERR.isLoggable(Level.FINE)) return previousID;
                        ERR.fine("Has already been parsed: " + this.parsedId + " for " + XMLDataObject.this);
                        return previousID;
                    }
                    url = null;
                    in = null;
                    try {
                        url = myFileObject.getURL();
                    }
                    catch (IOException ex) {
                        this.warning(ex, "I/O exception while retrieving xml FileObject URL.");
                        return XMLDataObject.NULL;
                    }
                    InfoParser infoParser2 = this;
                    // MONITORENTER : infoParser2
                    try {
                        if (myFileObject.isValid()) break block71;
                        if (ERR.isLoggable(Level.FINE)) {
                            ERR.fine("Invalid file object: " + myFileObject);
                        }
                        string = XMLDataObject.NULL;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (in == null) throw throwable;
                            in.close();
                            throw throwable;
                        }
                        catch (IOException ex) {
                            ERR.log(Level.WARNING, null, ex);
                        }
                        throw throwable;
                    }
                    try {
                        if (in == null) return string;
                        in.close();
                        return string;
                    }
                    catch (IOException ex2) {
                        ERR.log(Level.WARNING, null, ex2);
                    }
                    return string;
                }
                this.parsedId = XMLDataObject.NULL;
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("parsedId set to NULL for " + XMLDataObject.this);
                }
                try {
                    in = myFileObject.getInputStream();
                }
                catch (IOException ex) {
                    this.warning(ex, "I/O exception while openning xml.");
                    String ex2 = XMLDataObject.NULL;
                    try {
                        if (in == null) return ex2;
                        in.close();
                        return ex2;
                    }
                    catch (IOException ex3) {
                        ERR.log(Level.WARNING, null, ex3);
                    }
                    return ex2;
                }
                try {
                    XMLReader ex = sharedParserImpl;
                    // MONITORENTER : ex
                    this.configureParser(parser, false, this);
                    parser.setContentHandler(this);
                    parser.setErrorHandler(this);
                    InputSource input = new InputSource(url.toExternalForm());
                    input.setByteStream(in);
                    parser.parse(input);
                    // MONITOREXIT : ex
                    if (ERR.isLoggable(Level.FINE)) {
                        ERR.fine("Parse finished for " + XMLDataObject.this);
                    }
                }
                catch (StopSaxException stopped) {
                    newID = this.parsedId;
                    ERR.fine("Parsing successfully stopped: " + this.parsedId + " for " + XMLDataObject.this);
                }
                catch (SAXException checkStop) {
                    if (STOP.getMessage().equals(checkStop.getMessage())) {
                        newID = this.parsedId;
                        ERR.fine("Parsing stopped with STOP message: " + this.parsedId + " for " + XMLDataObject.this);
                        break block72;
                    }
                    String msg = "Thread:" + Thread.currentThread().getName();
                    ERR.warning("DocListener should not throw SAXException but STOP one.\n" + msg);
                    ERR.log(Level.WARNING, null, checkStop);
                    Exception ex = checkStop.getException();
                    if (ex != null) {
                        ERR.log(Level.WARNING, null, ex);
                    }
                }
                catch (FileNotFoundException ex) {
                    ERR.log(Level.WARNING, null, ex);
                }
                catch (IOException ex) {
                    ERR.log(Level.WARNING, null, ex);
                }
                finally {
                    if (Boolean.getBoolean("netbeans.profile.memory")) {
                        parser.setContentHandler(NullHandler.INSTANCE);
                        parser.setErrorHandler(NullHandler.INSTANCE);
                        try {
                            parser.setProperty("http://xml.org/sax/properties/lexical-handler", NullHandler.INSTANCE);
                        }
                        catch (SAXException ignoreIt) {}
                        try {
                            parser.parse((InputSource)null);
                        }
                        catch (Exception ignoreIt) {}
                    }
                    parser = null;
                }
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ERR.log(Level.WARNING, null, ex);
            }
            // MONITOREXIT : infoParser2
            if (ignorePreviousId != null && newID.equals(ignorePreviousId)) {
                if (!ERR.isLoggable(Level.FINE)) return newID;
                ERR.fine("No update to ID: " + ignorePreviousId + " for " + XMLDataObject.this);
                return newID;
            }
            if (ERR.isLoggable(Level.FINE)) {
                ERR.fine("New id: " + newID + " for " + XMLDataObject.this);
            }
            if (newID == null) return newID;
            this.updateLookup(previousID, newID);
            return newID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Lookup updateLookup(String previousID, String id) {
            Lookup newLookup;
            InfoParser infoParser = this;
            synchronized (infoParser) {
                if (previousID != null && previousID.equals(id) && this.lookup != null) {
                    ERR.fine("No need to update lookup: " + id + " for " + XMLDataObject.this);
                    return this.lookup;
                }
            }
            Info info = XMLDataObject.getRegisteredInfo(id);
            if (info != null) {
                newLookup = XMLDataObject.createInfoLookup(XMLDataObject.this, info);
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("Lookup from info: " + newLookup + " for " + XMLDataObject.this);
                }
            } else {
                newLookup = Environment.findForOne(XMLDataObject.this);
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("Lookup from env: " + newLookup + " for " + XMLDataObject.this);
                }
                if (newLookup == null) {
                    newLookup = Lookup.EMPTY;
                }
            }
            InfoParser infoParser2 = this;
            synchronized (infoParser2) {
                Lookup.Result prevRes = this.result;
                this.lookup = newLookup;
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("Shared lookup updated: " + this.lookup + " for " + XMLDataObject.this);
                }
                this.result = this.lookup.lookupResult(Node.Cookie.class);
                this.result.addLookupListener((LookupListener)this);
                if (prevRes != null) {
                    prevRes.removeLookupListener((LookupListener)this);
                    if (ERR.isLoggable(Level.FINE)) {
                        ERR.fine("Firing property change for " + XMLDataObject.this);
                    }
                    XMLDataObject.this.firePropertyChange("cookie", null, null);
                    if (ERR.isLoggable(Level.FINE)) {
                        ERR.fine("Firing done for " + XMLDataObject.this);
                    }
                }
                return newLookup;
            }
        }

        private void configureParser(XMLReader parser, boolean validation, LexicalHandler lex) {
            try {
                parser.setFeature("http://xml.org/sax/features/validation", validation);
            }
            catch (SAXException sex) {
                ERR.fine("Warning: XML parser does not support validation feature.");
            }
            try {
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", lex);
            }
            catch (SAXException sex) {
                ERR.fine("Warning: XML parser does not support lexical-handler feature.");
            }
        }

        public void warning(Throwable ex) {
            this.warning(ex, null);
        }

        public void warning(Throwable ex, String annotation) {
            ERR.log(Level.WARNING, annotation, ex);
        }

        @Override
        public void startDTD(String root, String pID, String sID) throws SAXException {
            this.parsedId = pID == null ? XMLDataObject.NULL : pID;
            ERR.fine("Parsed to " + this.parsedId);
            this.stop();
        }

        @Override
        public void endDTD() throws SAXException {
            this.stop();
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void error(SAXParseException p1) throws SAXException {
            this.stop();
        }

        @Override
        public void fatalError(SAXParseException p1) throws SAXException {
            this.stop();
        }

        @Override
        public void endDocument() throws SAXException {
            this.stop();
        }

        @Override
        public void startElement(String uri, String lName, String qName, Attributes atts) throws SAXException {
            this.stop();
        }

        private void stop() throws SAXException {
            throw STOP;
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        private void fileCreated(FileObject fo) {
        }

        public void fileChanged(FileEvent fe) {
            if (XMLDataObject.this.getPrimaryFile().equals(fe.getFile())) {
                XMLDataObject.this.clearDocument();
                String prevId = this.parsedId;
                this.parsedId = null;
                ERR.fine("cleared parsedId");
                this.waitFinished(prevId);
            }
        }

        public void fileDeleted(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            XMLDataObject.this.firePropertyChange("cookie", null, null);
            Node n = XMLDataObject.this.getNodeDelegateOrNull();
            if (n instanceof XMLNode) {
                ((XMLNode)n).update();
            }
        }
    }

    static final class Loader
    extends MultiFileLoader {
        static final long serialVersionUID = 3917883920409453930L;

        public Loader() {
            super("org.openide.loaders.XMLDataObject");
        }

        protected String actionsContext() {
            return "Loaders/text/xml/Actions";
        }

        protected String defaultDisplayName() {
            return NbBundle.getMessage(XMLDataObject.class, (String)"PROP_XmlLoader_Name");
        }

        protected FileObject findPrimaryFile(FileObject fo) {
            String mime = fo.getMIMEType();
            if (mime.endsWith("/xml") || mime.endsWith("+xml")) {
                return fo;
            }
            return null;
        }

        protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException {
            return new XMLDataObject(primaryFile, this);
        }

        protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
            return new FileEntry(obj, primaryFile);
        }

        protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject obj, FileObject secondaryFile) {
            return new FileEntry(obj, secondaryFile);
        }
    }

    private static class NullHandler
    extends DefaultHandler
    implements LexicalHandler {
        static final NullHandler INSTANCE = new NullHandler();

        NullHandler() {
        }

        public void startDTD(String root, String pID, String sID) throws SAXException {
        }

        public void endDTD() throws SAXException {
        }

        public void startEntity(String name) throws SAXException {
        }

        public void endEntity(String name) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void endCDATA() throws SAXException {
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
        }
    }

    private final class PlainDataNode
    extends DataNode {
        public PlainDataNode() {
            super(XMLDataObject.this, Children.LEAF);
            this.setIconBaseWithExtension("org/openide/loaders/xmlObject.gif");
        }

        public Action getPreferredAction() {
            return SystemAction.get(OpenAction.class);
        }
    }

    @Deprecated
    public static interface Processor
    extends Node.Cookie {
        public void attachTo(XMLDataObject var1);
    }

    private static class StopSaxException
    extends SAXException {
        public StopSaxException() {
            super("STOP");
        }
    }

    private static class XMLEditorSupport
    extends DataEditorSupport
    implements OpenCookie,
    EditorCookie.Observable,
    PrintCookie,
    CloseCookie {
        public XMLEditorSupport(XMLDataObject obj) {
            super(obj, new XMLEditorEnv(obj));
            this.setMIMEType(XMLDataObject.MIME);
        }

        protected boolean notifyModified() {
            if (!super.notifyModified()) {
                return false;
            }
            if (this.getDataObject().getCookie(SaveCookie.class) == null) {
                ((XMLDataObject)this.getDataObject()).addSaveCookie(new Save());
                this.getDataObject().setModified(true);
            }
            return true;
        }

        protected void notifyUnmodified() {
            super.notifyUnmodified();
            SaveCookie save = this.getDataObject().getCookie(SaveCookie.class);
            if (save != null) {
                ((XMLDataObject)this.getDataObject()).removeSaveCookie(save);
                this.getDataObject().setModified(false);
            }
        }

        class Save
        implements SaveCookie {
            Save() {
            }

            public void save() throws IOException {
                XMLEditorSupport.this.saveDocument();
                XMLEditorSupport.this.getDataObject().setModified(false);
            }
        }

        private static class XMLEditorEnv
        extends DataEditorSupport.Env {
            private static final long serialVersionUID = 6593415381104273008L;

            public XMLEditorEnv(DataObject obj) {
                super(obj);
            }

            protected FileObject getFile() {
                return this.getDataObject().getPrimaryFile();
            }

            protected FileLock takeLock() throws IOException {
                return ((XMLDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
            }

            public CloneableOpenSupport findCloneableOpenSupport() {
                return (CloneableOpenSupport)this.getDataObject().getCookie(EditorCookie.class);
            }
        }
    }

    private final class XMLNode
    extends FilterNode {
        public XMLNode(XMLDataObject obj) {
            this(obj.findNode());
        }

        private XMLNode(Node del) {
            super(del, (Children)new FilterNode.Children(del));
        }

        private void update() {
            this.changeOriginal(XMLDataObject.this.findNode(), true);
        }
    }
}

