/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.GridLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.openfile.OpenFile;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

class FileChooser
extends JFileChooser {
    FileChooser() {
        this.setFileSelectionMode(0);
        this.setMultiSelectionEnabled(true);
        FileFilter currentFilter = this.getFileFilter();
        this.addChoosableFileFilter(new Filter(new String[]{".JAVA"}, NbBundle.getMessage(FileChooser.class, (String)"TXT_JavaFilter")));
        this.addChoosableFileFilter(new Filter(new String[]{".TXT"}, NbBundle.getMessage(FileChooser.class, (String)"TXT_TxtFilter")));
        this.setFileFilter(currentFilter);
    }

    public void approveSelection() {
        File[] selectedFiles = this.getSelectedFiles();
        ArrayList<String> errorMsgs = null;
        for (int i = 0; i < selectedFiles.length; ++i) {
            String msgPatternRef = null;
            boolean isUNCPath = false;
            File file = selectedFiles[i];
            if (!file.exists()) {
                msgPatternRef = "MSG_FileDoesNotExist";
            } else if (OpenFile.isSpecifiedByUNCPath(file)) {
                msgPatternRef = "MSG_FileSpecifiedByUNC";
                isUNCPath = true;
            } else if (file.isDirectory()) {
                msgPatternRef = "MSG_FileIsADirectory";
            } else if (!file.isFile()) {
                msgPatternRef = "MSG_FileIsNotPlainFile";
            }
            if (msgPatternRef == null) continue;
            if (errorMsgs == null) {
                errorMsgs = new ArrayList<String>(selectedFiles.length - i);
            }
            errorMsgs.add(NbBundle.getMessage(FileChooser.class, (String)msgPatternRef, (Object)(isUNCPath ? FileChooser.getUNCPathToDisplay(file) : file.getName())));
        }
        if (errorMsgs == null) {
            super.approveSelection();
        } else {
            JPanel panel = new JPanel(new GridLayout(errorMsgs.size(), 0, 0, 2));
            Iterator i = errorMsgs.iterator();
            while (i.hasNext()) {
                panel.add(new JLabel((String)i.next()));
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)panel, 2));
        }
    }

    private static String getUNCPathToDisplay(File file) {
        char sep;
        String name = file.getName();
        String path = file.getPath();
        String pathToCheck = path.substring(2, path.length() - name.length() - 1);
        int slashIndex = pathToCheck.indexOf(sep = File.separatorChar);
        if (slashIndex != -1 && (slashIndex = pathToCheck.indexOf(sep, slashIndex + 1)) != -1 && pathToCheck.indexOf(sep, slashIndex + 1) != -1) {
            return new StringBuffer(slashIndex + name.length() + 7).append(path.substring(0, 2 + slashIndex)).append(sep).append("...").append(sep).append(name).toString();
        }
        return path;
    }

    private static class Filter
    extends FileFilter {
        private String[] extensions;
        private String description;

        public Filter(String[] extensions, String description) {
            this.extensions = new String[extensions.length];
            for (int i = 0; i < extensions.length; ++i) {
                this.extensions[i] = extensions[i].toUpperCase();
            }
            this.description = description;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            for (int i = 0; i < this.extensions.length; ++i) {
                if (!file.getName().toUpperCase().endsWith(this.extensions[i])) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

