/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.openfile.OpenFile;
import org.netbeans.modules.openfile.RecentFiles;
import org.openide.awt.DynamicMenuContent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class RecentFileAction
extends AbstractAction
implements Presenter.Menu,
PopupMenuListener {
    private static final String FO_PROP = "RecentFileAction.Recent_FO";
    private static final int MAX_COUNT = 15;
    private JMenu menu;

    public RecentFileAction() {
        super(NbBundle.getMessage(RecentFileAction.class, (String)"LBL_RecentFileAction_Name"));
    }

    public JMenuItem getMenuPresenter() {
        if (this.menu == null) {
            this.menu = new UpdatingMenu(this);
            this.menu.setMnemonic(NbBundle.getMessage(RecentFileAction.class, (String)"MNE_RecentFileAction_Name").charAt(0));
            this.menu.getPopupMenu().addPopupMenuListener(this);
        }
        return this.menu;
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
        this.fillSubMenu();
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
        this.menu.removeAll();
    }

    public void popupMenuCanceled(PopupMenuEvent arg0) {
    }

    private void fillSubMenu() {
        List<RecentFiles.HistoryItem> files = RecentFiles.getRecentFiles();
        int counter = 0;
        for (RecentFiles.HistoryItem hItem : files) {
            if (++counter > 15) break;
            Image icon = null;
            try {
                DataObject dObj = DataObject.find((FileObject)hItem.getFile());
                icon = dObj.getNodeDelegate().getIcon(1);
            }
            catch (DataObjectNotFoundException ex) {
                Logger.getLogger(RecentFiles.class.getName()).log(Level.INFO, ex.getMessage(), ex);
                continue;
            }
            JMenuItem jmi = null;
            jmi = icon != null ? new JMenuItem(hItem.getFile().getNameExt(), new ImageIcon(icon)) : new JMenuItem(hItem.getFile().getNameExt());
            jmi.putClientProperty(FO_PROP, hItem.getFile());
            jmi.addActionListener(this);
            this.menu.add(jmi);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        JMenuItem source = (JMenuItem)evt.getSource();
        FileObject fo = (FileObject)source.getClientProperty(FO_PROP);
        if (fo != null) {
            OpenFile.open(fo, -1);
        }
    }

    private static class UpdatingMenu
    extends JMenu
    implements DynamicMenuContent {
        private final JComponent[] content = new JComponent[]{this};

        public UpdatingMenu(Action action) {
            super(action);
        }

        public JComponent[] getMenuPresenters() {
            this.setEnabled(!RecentFiles.getRecentFiles().isEmpty());
            return this.content;
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return this.getMenuPresenters();
        }
    }
}

