/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.util.NbPreferences;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecentFiles {
    private static List<HistoryItem> history = new ArrayList<HistoryItem>();
    private static Preferences prefs;
    private static final Object HISTORY_LOCK;
    private static final String PREFS_NODE = "RecentFilesHistory";
    private static final String SEPARATOR = "; time=";
    private static final int MAX_HISTORY_ITEMS = 20;

    private RecentFiles() {
    }

    public static void init() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                List<HistoryItem> loaded = RecentFiles.load();
                Object object = HISTORY_LOCK;
                synchronized (object) {
                    history.addAll(0, loaded);
                }
                TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)new WindowRegistryL());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HistoryItem> getRecentFiles() {
        Object object = HISTORY_LOCK;
        synchronized (object) {
            RecentFiles.checkHistory();
            return Collections.unmodifiableList(history);
        }
    }

    static List<HistoryItem> load() {
        String[] keys;
        Preferences prefs = RecentFiles.getPrefs();
        try {
            keys = prefs.keys();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(RecentFiles.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
            return Collections.emptyList();
        }
        ArrayList<HistoryItem> result = new ArrayList<HistoryItem>(keys.length + 10);
        for (String curKey : keys) {
            HistoryItem hItem = RecentFiles.decode(prefs.get(curKey, null));
            if (hItem != null) {
                result.add(hItem);
                continue;
            }
            prefs.remove(curKey);
        }
        Collections.sort(result);
        return result;
    }

    private static HistoryItem decode(String value) {
        int sepIndex = value.lastIndexOf(SEPARATOR);
        if (sepIndex <= 0) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(value.substring(0, sepIndex));
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(RecentFiles.class.getName()).log(Level.INFO, ex.getMessage(), ex);
            return null;
        }
        FileObject fo = URLMapper.findFileObject((URL)url);
        if (fo == null) {
            return null;
        }
        long time = 0L;
        try {
            time = Long.decode(value.substring(sepIndex + SEPARATOR.length()));
        }
        catch (NumberFormatException ex) {
            Logger.getLogger(RecentFiles.class.getName()).log(Level.INFO, ex.getMessage(), ex);
            return null;
        }
        return new HistoryItem(fo, time);
    }

    static void storeRemoved(HistoryItem hItem) {
        String stringURL = null;
        URL url = URLMapper.findURL((FileObject)hItem.getFile(), (int)1);
        if (url == null) {
            Logger.getLogger(RecentFiles.class.getName()).log(Level.INFO, "storeRemoved: URL can't be found for FileObject " + hItem.getFile());
            return;
        }
        stringURL = url.toExternalForm();
        RecentFiles.getPrefs().remove(RecentFiles.trimToKeySize(stringURL));
    }

    static void storeAdded(HistoryItem hItem) {
        String stringURL = null;
        URL url = URLMapper.findURL((FileObject)hItem.getFile(), (int)1);
        if (url == null) {
            Logger.getLogger(RecentFiles.class.getName()).log(Level.INFO, "storeAdded: URL can't be found for FileObject " + hItem.getFile());
            return;
        }
        stringURL = url.toExternalForm();
        String value = stringURL + SEPARATOR + String.valueOf(hItem.getTime());
        RecentFiles.getPrefs().put(RecentFiles.trimToKeySize(stringURL), value);
    }

    private static String trimToKeySize(String path) {
        int length = path.length();
        if (length > 80) {
            path = path.substring(length - 80, length);
        }
        return path;
    }

    static Preferences getPrefs() {
        if (prefs == null) {
            prefs = NbPreferences.forModule(RecentFiles.class).node(PREFS_NODE);
        }
        return prefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFile(TopComponent tc) {
        FileObject fo;
        if (tc instanceof CloneableTopComponent && (fo = RecentFiles.obtainFileObject(tc)) != null) {
            boolean added = false;
            Object object = HISTORY_LOCK;
            synchronized (object) {
                HistoryItem hItem = RecentFiles.findHistoryItem(fo);
                if (hItem == null) {
                    hItem = new HistoryItem(fo, System.currentTimeMillis());
                    history.add(0, hItem);
                    RecentFiles.storeAdded(hItem);
                    added = true;
                    if (history.size() > 20) {
                        HistoryItem oldest = history.get(history.size() - 1);
                        history.remove(oldest);
                        RecentFiles.storeRemoved(oldest);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFile(TopComponent tc) {
        FileObject fo;
        if (tc instanceof CloneableTopComponent && (fo = RecentFiles.obtainFileObject(tc)) != null) {
            boolean removed = false;
            Object object = HISTORY_LOCK;
            synchronized (object) {
                HistoryItem hItem = RecentFiles.findHistoryItem(fo);
                if (hItem != null) {
                    history.remove(hItem);
                    RecentFiles.storeRemoved(hItem);
                    removed = true;
                }
            }
        }
    }

    private static FileObject obtainFileObject(TopComponent tc) {
        DataObject dObj = (DataObject)tc.getLookup().lookup(DataObject.class);
        return dObj != null ? dObj.getPrimaryFile() : null;
    }

    private static HistoryItem findHistoryItem(FileObject fo) {
        for (HistoryItem hItem : history) {
            if (!fo.equals(hItem.getFile())) continue;
            return hItem;
        }
        return null;
    }

    private static void checkHistory() {
        ArrayList<HistoryItem> invalidEntries = new ArrayList<HistoryItem>(3);
        for (HistoryItem historyItem : history) {
            if (historyItem.getFile().isValid()) continue;
            invalidEntries.add(historyItem);
        }
        for (HistoryItem<Object> historyItem : invalidEntries) {
            history.remove(historyItem);
        }
    }

    static {
        HISTORY_LOCK = new Object();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class HistoryItem<T extends HistoryItem>
    implements Comparable<T> {
        private long time;
        private FileObject file;

        HistoryItem(FileObject file, long time) {
            this.file = file;
            this.time = time;
        }

        public FileObject getFile() {
            return this.file;
        }

        public long getTime() {
            return this.time;
        }

        @Override
        public int compareTo(T other) {
            long diff = this.time - ((HistoryItem)other).getTime();
            return diff < 0L ? 1 : (diff > 0L ? -1 : 0);
        }
    }

    private static class WindowRegistryL
    implements PropertyChangeListener {
        private WindowRegistryL() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("tcClosed".equals(evt.getPropertyName())) {
                RecentFiles.addFile((TopComponent)evt.getNewValue());
            }
            if ("tcOpened".equals(evt.getPropertyName())) {
                RecentFiles.removeFile((TopComponent)evt.getNewValue());
            }
        }
    }
}

